/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.mlsql.sources.mysql.binlog.io;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.apache.spark.sql.mlsql.sources.mysql.binlog.RawBinlogEvent;

public abstract class AbstractEventWriter {
    private final JsonFactory JSON_FACTORY = new JsonFactory();
    protected JsonGenerator jsonGenerator;

    protected void startJson(StringWriter outputStream, RawBinlogEvent event) throws IOException {
        this.jsonGenerator = this.createJsonGenerator(outputStream);
        this.jsonGenerator.writeStartObject();
        String eventType = event.getEventType();
        if (eventType == null) {
            this.jsonGenerator.writeNullField("type");
        } else {
            this.jsonGenerator.writeStringField("type", eventType);
        }
        Long timestamp = event.getTimestamp();
        if (timestamp == null) {
            this.jsonGenerator.writeNullField("timestamp");
        } else {
            this.jsonGenerator.writeNumberField("timestamp", event.getTimestamp().longValue());
        }
        if (event.getTableInfo() != null) {
            String db = event.getTableInfo().getDatabaseName();
            String tableName = event.getTableInfo().getTableName();
            String schema = event.getTableInfo().getSchema();
            this.jsonGenerator.writeStringField("databaseName", db);
            this.jsonGenerator.writeStringField("tableName", tableName);
            this.jsonGenerator.writeStringField("schema", schema);
        } else {
            this.jsonGenerator.writeNullField("databaseName");
            this.jsonGenerator.writeNullField("tableName");
            this.jsonGenerator.writeNullField("schema");
        }
    }

    protected void endJson() throws IOException {
        if (this.jsonGenerator == null) {
            throw new IOException("endJson called without a JsonGenerator");
        }
        this.jsonGenerator.writeEndObject();
        this.jsonGenerator.flush();
        this.jsonGenerator.close();
    }

    private JsonGenerator createJsonGenerator(StringWriter out) throws IOException {
        return this.JSON_FACTORY.createGenerator((Writer)out);
    }

    public abstract List<String> writeEvent(RawBinlogEvent var1);
}

