/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.mlsql.sources.mysql.binlog.io;

import com.github.shyiko.mysql.binlog.event.WriteRowsEventData;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.apache.spark.sql.mlsql.sources.mysql.binlog.MySQLCDCUtils;
import org.apache.spark.sql.mlsql.sources.mysql.binlog.RawBinlogEvent;
import org.apache.spark.sql.mlsql.sources.mysql.binlog.TableInfo;
import org.apache.spark.sql.mlsql.sources.mysql.binlog.io.AbstractEventWriter;
import org.apache.spark.sql.mlsql.sources.mysql.binlog.io.SchemaTool;

public class InsertRowsWriter
extends AbstractEventWriter {
    @Override
    public List<String> writeEvent(RawBinlogEvent event) {
        WriteRowsEventData data = (WriteRowsEventData)event.getEvent().getData();
        ArrayList<String> items = new ArrayList<String>();
        for (Serializable[] row : data.getRows()) {
            try {
                StringWriter writer = new StringWriter();
                this.startJson(writer, event);
                BitSet bitSet = data.getIncludedColumns();
                this.writeRow(event.getTableInfo(), row, bitSet);
                this.endJson();
                items.add(writer.toString());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return items;
    }

    protected void writeRow(TableInfo tableInfo, Serializable[] row, BitSet includedColumns) throws IOException {
        this.jsonGenerator.writeArrayFieldStart("rows");
        int i = includedColumns.nextSetBit(0);
        this.jsonGenerator.writeStartObject();
        while (i != -1) {
            String columnName = new SchemaTool(tableInfo.getSchema()).getColumnNameByIndex(i);
            if (row[i] != null) {
                this.jsonGenerator.writeObjectField(columnName, MySQLCDCUtils.getWritableObject(row[i]));
            }
            i = includedColumns.nextSetBit(i + 1);
        }
        this.jsonGenerator.writeEndObject();
        this.jsonGenerator.writeEndArray();
    }
}

