/*
 * Decompiled with CFR 0.152.
 */
package tech.sqlclub.common.utils;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.Serializable;
import java.net.URL;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Set$;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import tech.sqlclub.common.exception.SQLClubException;
import tech.sqlclub.common.log.Logger;
import tech.sqlclub.common.log.Logging;

public final class ConfigUtils$
implements Logging {
    public static ConfigUtils$ MODULE$;
    private Config config;
    private transient Logger tech$sqlclub$common$log$Logging$$log_;
    private final Object tech$sqlclub$common$log$Logging$$INSTANTIATION_LOCK;

    static {
        new ConfigUtils$();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public Logger tech$sqlclub$common$log$Logging$$log_() {
        return this.tech$sqlclub$common$log$Logging$$log_;
    }

    @Override
    public void tech$sqlclub$common$log$Logging$$log__$eq(Logger x$1) {
        this.tech$sqlclub$common$log$Logging$$log_ = x$1;
    }

    @Override
    public Object tech$sqlclub$common$log$Logging$$INSTANTIATION_LOCK() {
        return this.tech$sqlclub$common$log$Logging$$INSTANTIATION_LOCK;
    }

    @Override
    public final void tech$sqlclub$common$log$Logging$_setter_$tech$sqlclub$common$log$Logging$$INSTANTIATION_LOCK_$eq(Object x$1) {
        this.tech$sqlclub$common$log$Logging$$INSTANTIATION_LOCK = x$1;
    }

    public Config config() {
        return this.config;
    }

    public void config_$eq(Config x$1) {
        this.config = x$1;
    }

    public void configBuilder(scala.collection.immutable.Map<String, Object> map) {
        scala.collection.immutable.Map tempMap = ((TraversableOnce)((SetLike)this.getKeys().$minus$minus((GenTraversableOnce)map.keySet())).map((Function1 & Serializable & scala.Serializable)k -> new Tuple2(k, MODULE$.getAnyValue((String)k)), scala.collection.immutable.Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map unionMap = map.$plus$plus((GenTraversableOnce)tempMap);
        this.config_$eq(ConfigFactory.parseMap((java.util.Map)JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap((Map)unionMap)));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "ConfigUtils build configuration succeed!");
    }

    public Set<String> getConfigKeys(Config config) {
        return ((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020asScalaSet(config.entrySet()).map((Function1 & Serializable & scala.Serializable)map -> (String)map.getKey(), Set$.MODULE$.canBuildFrom())).toSet();
    }

    public Set<String> getKeys() {
        return this.getConfigKeys(this.config());
    }

    public scala.collection.immutable.Map<String, Object> config2Map(Config config) {
        return ((TraversableOnce)this.getConfigKeys(config).map((Function1 & Serializable & scala.Serializable)k -> new Tuple2(k, config.getAnyRef(k)), scala.collection.immutable.Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public scala.collection.immutable.Map<String, Object> toMap() {
        return this.config2Map(this.config());
    }

    public scala.collection.immutable.Map<String, String> config2StringMap(Config config) {
        return ((TraversableOnce)this.getConfigKeys(config).map((Function1 & Serializable & scala.Serializable)k -> new Tuple2(k, (Object)config.getString(k)), scala.collection.immutable.Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public scala.collection.immutable.Map<String, String> toStringMap() {
        return this.config2StringMap(this.config());
    }

    public boolean hasConfig(String path) {
        return this.config().hasPath(path);
    }

    public Config getConfig(String path) {
        Config config;
        try {
            config = this.config().getConfig(path);
        }
        catch (Exception ex) {
            config = null;
        }
        return config;
    }

    public String getStringValue(String path, String string) {
        String string2;
        try {
            string2 = this.config().getString(path);
        }
        catch (Exception ex) {
            string2 = string;
        }
        return string2;
    }

    public String getStringValue(String path) {
        return this.getStringValue(path, null);
    }

    public int getIntValue(String path, int n) {
        int n2;
        try {
            n2 = this.config().getInt(path);
        }
        catch (Exception ex) {
            n2 = n;
        }
        return n2;
    }

    public int getIntValue(String path) {
        return this.getIntValue(path, 0);
    }

    public long getLongValue(String path, long l) {
        long l2;
        try {
            l2 = this.config().getLong(path);
        }
        catch (Exception ex) {
            l2 = l;
        }
        return l2;
    }

    public long getLongValue(String path) {
        return this.getLongValue(path, 0L);
    }

    public double getDoubleValue(String path, double d) {
        double d2;
        try {
            d2 = this.config().getDouble(path);
        }
        catch (Exception ex) {
            d2 = d;
        }
        return d2;
    }

    public double getDoubleValue(String path) {
        return this.getDoubleValue(path, 0.0);
    }

    public List<String> getStringList(String path) {
        List list;
        try {
            list = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.config().getStringList(path)).asScala()).toList();
        }
        catch (Exception ex) {
            list = List$.MODULE$.empty();
        }
        return list;
    }

    public Object getAnyValue(String path) {
        return this.config().getAnyRef(path);
    }

    public Config parseString(String str) {
        return ConfigFactory.parseString((String)str);
    }

    public Object getAnyValueByConfig(Config config, String path) {
        return config != null ? config.getAnyRef(path) : null;
    }

    public String getStringValueByConfig(Config config, String path) {
        return config != null ? config.getString(path) : null;
    }

    public Config getConfByConfig(Config config, String path) {
        return config != null ? config.getConfig(path) : null;
    }

    public void showConf(scala.collection.immutable.Map<String, String> conf) {
        int keyLength = BoxesRunTime.unboxToInt((Object)((TraversableOnce)conf.keys().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)ConfigUtils$.$anonfun$showConf$1(x$1)), scala.collection.Iterable$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Int$.MODULE$));
        int valueLength = BoxesRunTime.unboxToInt((Object)((TraversableOnce)conf.values().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)ConfigUtils$.$anonfun$showConf$2(x$2)), scala.collection.Iterable$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Int$.MODULE$));
        String header = new StringOps(Predef$.MODULE$.augmentString("-")).$times(keyLength + valueLength + 3);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> header);
        ((IterableLike)conf.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            String keyStr = new StringBuilder(0).append(key).append(new StringOps(Predef$.MODULE$.augmentString(" ")).$times(keyLength - new StringOps(Predef$.MODULE$.augmentString(key)).size())).toString();
            String valueStr = new StringBuilder(0).append(value).append(new StringOps(Predef$.MODULE$.augmentString(" ")).$times(valueLength - new StringOps(Predef$.MODULE$.augmentString(value)).size())).toString();
            String string = new StringBuilder(3).append("|").append(keyStr).append("|").append(valueStr).append("|").toString();
            return string;
        }, Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)line -> {
            ConfigUtils$.MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> line);
            return BoxedUnit.UNIT;
        });
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> header);
    }

    public scala.collection.immutable.Map<String, String> showConf$default$1() {
        return this.toStringMap();
    }

    public static final /* synthetic */ int $anonfun$showConf$1(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).size();
    }

    public static final /* synthetic */ int $anonfun$showConf$2(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).size();
    }

    private ConfigUtils$() {
        MODULE$ = this;
        Logging.$init$(this);
        try {
            URL url = this.getClass().getClassLoader().getResource("application.conf");
            if (url != null) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("ConfigUtils load file: ").append(url.getFile()).toString());
                this.config_$eq(ConfigFactory.parseURL((URL)url));
            } else {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Didn't find the config file application.conf in classpath!");
                this.config_$eq(ConfigFactory.empty());
            }
        }
        catch (Exception ex) {
            throw new SQLClubException(ex.getMessage(), ex);
        }
    }
}

