/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.compat;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleClassLoader
extends ClassLoader {
    static Log logger = LogFactory.getLog((Class)(class$org$apache$tomcat$util$compat$SimpleClassLoader == null ? (class$org$apache$tomcat$util$compat$SimpleClassLoader = SimpleClassLoader.class$("org.apache.tomcat.util.compat.SimpleClassLoader")) : class$org$apache$tomcat$util$compat$SimpleClassLoader));
    protected URL[] urls;
    protected ClassLoader parent;
    protected String[] reserved;
    SecurityManager sm;
    static /* synthetic */ Class class$org$apache$tomcat$util$compat$SimpleClassLoader;

    public SimpleClassLoader(URL[] urls) {
        this.urls = urls;
        this.sm = System.getSecurityManager();
        this.checkURLs();
    }

    public SimpleClassLoader(URL[] urls, ClassLoader parent) {
        this.urls = urls;
        this.parent = parent;
        this.sm = System.getSecurityManager();
        this.checkURLs();
    }

    public SimpleClassLoader(URL[] urls, ClassLoader parent, String[] reserved) {
        this.urls = urls;
        this.parent = parent;
        this.reserved = reserved;
        this.sm = System.getSecurityManager();
        this.checkURLs();
    }

    public ClassLoader getParentLoader() {
        return this.parent;
    }

    private void checkURLs() {
        boolean cnt = false;
        for (int i = 0; i < this.urls.length; ++i) {
            URL cp = this.urls[i];
            String fileN = cp.getFile();
            File file = new File(fileN);
            if (!file.exists()) {
                this.urls[i] = null;
            }
            if (!file.isDirectory() || fileN.endsWith("/")) continue;
            try {
                this.urls[i] = new URL("file", null, fileN + "/");
                continue;
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        byte[] classData;
        Class<?> c;
        block48: {
            Resource r;
            block50: {
                int i;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("loadClass() " + name + " " + resolve));
                }
                c = null;
                c = this.findLoadedClass(name);
                if (c != null) {
                    if (resolve) {
                        this.resolveClass(c);
                    }
                    return c;
                }
                if (this.parent != null) {
                    try {
                        c = this.parent.loadClass(name);
                        if (c != null) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("loadClass() from parent " + name));
                            }
                            if (resolve) {
                                this.resolveClass(c);
                            }
                            return c;
                        }
                    }
                    catch (Exception e) {
                        c = null;
                    }
                }
                try {
                    c = this.findSystemClass(name);
                    if (c != null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("loadClass() from system " + name));
                        }
                        if (resolve) {
                            this.resolveClass(c);
                        }
                        return c;
                    }
                }
                catch (Exception e) {
                    c = null;
                }
                if (this.sm != null && (i = name.lastIndexOf(46)) >= 0) {
                    this.sm.checkPackageAccess(name.substring(0, i));
                    this.sm.checkPackageDefinition(name.substring(0, i));
                }
                if (this.reserved != null) {
                    for (i = 0; i < this.reserved.length; ++i) {
                        if (!name.startsWith(this.reserved[i])) continue;
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("reserved: " + name + " " + this.reserved[i]));
                        }
                        throw new ClassNotFoundException(name);
                    }
                }
                if (this.urls == null) {
                    throw new ClassNotFoundException(name);
                }
                String classFileName = name.replace('.', '/') + ".class";
                r = this.doFindResource(classFileName);
                if (r == null) {
                    throw new ClassNotFoundException(name);
                }
                classData = null;
                if (r.file == null) break block50;
                FileInputStream in = null;
                in = new FileInputStream(r.file);
                classData = this.loadBytesFromStream(in, (int)r.file.length());
                Object var11_16 = null;
                try {
                    if (in != null) {
                        ((InputStream)in).close();
                    }
                    break block48;
                }
                catch (IOException ex) {}
                break block48;
                {
                    catch (IOException ioex) {
                        Class clazz = null;
                        Object var11_17 = null;
                        try {
                            if (in != null) {
                                ((InputStream)in).close();
                            }
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                        return clazz;
                    }
                }
                catch (Throwable throwable) {
                    Object var11_18 = null;
                    try {
                        if (in != null) {
                            ((InputStream)in).close();
                        }
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            if (r.zipEntry != null) {
                try {
                    classData = this.loadBytesFromStream(r.zipFile.getInputStream(r.zipEntry), (int)r.zipEntry.getSize());
                }
                catch (IOException ioex) {
                    Class clazz = null;
                    return clazz;
                }
                finally {
                    try {
                        r.zipFile.close();
                    }
                    catch (IOException ignored) {}
                }
            }
        }
        if (classData != null) {
            try {
                c = this.defineClass(name, classData, 0, classData.length);
                if (resolve) {
                    this.resolveClass(c);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("loadClass() from local repository " + name));
                }
                return c;
            }
            catch (Throwable t) {
                logger.error((Object)("Error Defining class: " + name), t);
            }
        }
        throw new ClassNotFoundException(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getResource(String name) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getResource() " + name));
        }
        URL u = null;
        if (this.parent != null && (u = this.parent.getResource(name)) != null) {
            return u;
        }
        u = ClassLoader.getSystemResource(name);
        if (u != null) {
            return u;
        }
        Resource r = this.doFindResource(name);
        if (r == null) {
            return null;
        }
        if (r.file != null) {
            try {
                return new URL("file", null, r.file.getAbsolutePath());
            }
            catch (MalformedURLException badurl) {
                logger.error((Object)("bad file: " + r.file), (Throwable)badurl);
                return null;
            }
        }
        if (r.zipEntry != null) {
            try {
                URL badurl = new URL("jar:file:" + r.repository.getPath() + "!/" + name);
                return badurl;
            }
            catch (MalformedURLException badurl) {
                logger.error((Object)("bad jar: " + r.repository), (Throwable)badurl);
                URL uRL = null;
                return uRL;
            }
            finally {
                try {
                    r.zipFile.close();
                }
                catch (IOException ignored) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream getResourceAsStream(String name) {
        block23: {
            if (SimpleClassLoader.logger.isDebugEnabled()) {
                SimpleClassLoader.logger.debug((Object)("getResourceAsStream() " + name));
            }
            s = null;
            if (this.parent != null) {
                s = this.parent.getResourceAsStream(name);
                if (SimpleClassLoader.logger.isDebugEnabled()) {
                    SimpleClassLoader.logger.debug((Object)("Found resource in parent " + s));
                }
                if (s != null) {
                    return s;
                }
            }
            s = ClassLoader.getSystemResourceAsStream(name);
            if (SimpleClassLoader.logger.isDebugEnabled()) {
                SimpleClassLoader.logger.debug((Object)("System resource " + s));
            }
            if (s != null) {
                return s;
            }
            r = this.doFindResource(name);
            if (r == null) {
                return null;
            }
            if (r.file != null) {
                if (SimpleClassLoader.logger.isDebugEnabled()) {
                    SimpleClassLoader.logger.debug((Object)("Found " + r.file));
                }
                try {
                    return new FileInputStream(r.file);
                }
                catch (IOException shouldnothappen) {
                    SimpleClassLoader.logger.error((Object)("No File: " + r.file), (Throwable)shouldnothappen);
                    return null;
                }
            }
            if (r.zipEntry == null) return s;
            if (SimpleClassLoader.logger.isDebugEnabled()) {
                SimpleClassLoader.logger.debug((Object)("Found " + r.zipEntry));
            }
            try {
                try {
                    data = this.loadBytesFromStream(r.zipFile.getInputStream(r.zipEntry), (int)r.zipEntry.getSize());
                    if (data == null) break block23;
                    var6_9 = istream = new ByteArrayInputStream(data);
                    var8_10 = null;
                    if (r.zipFile == null) return var6_9;
                }
                catch (IOException e) {
                    var8_12 = null;
                    if (r.zipFile == null) return s;
                    try {
                        r.zipFile.close();
                        return s;
                    }
                    catch (IOException ignored) {
                        return s;
                    }
                }
            }
            catch (Throwable var7_18) {
                var8_13 = null;
                if (r.zipFile == null) throw var7_18;
                ** try [egrp 3[TRYBLOCK] [6 : 391->401)] { 
lbl52:
                // 1 sources

                r.zipFile.close();
                throw var7_18;
lbl54:
                // 1 sources

                catch (IOException ignored) {
                    // empty catch block
                }
                throw var7_18;
            }
            try {}
            catch (IOException ignored) {
                // empty catch block
                return var6_9;
            }
            r.zipFile.close();
            return var6_9;
        }
        var8_11 = null;
        if (r.zipFile == null) return s;
        try {}
        catch (IOException ignored) {}
        r.zipFile.close();
        return s;
        return s;
    }

    private Resource doFindResource(String name) {
        Resource r = new Resource();
        for (int i = 0; i < this.urls.length; ++i) {
            URL cp = this.urls[i];
            if (cp == null) continue;
            String fileN = cp.getFile();
            File file = new File(fileN);
            if (fileN.endsWith("/")) {
                String fileName = name.replace('/', File.separatorChar);
                File resFile = new File(file, fileName);
                if (!resFile.exists()) continue;
                r.file = resFile;
                r.repository = file;
                return r;
            }
            try {
                ZipFile zf = new ZipFile(file.getAbsolutePath());
                ZipEntry ze = zf.getEntry(name);
                if (ze != null) {
                    r.zipEntry = ze;
                    r.zipFile = zf;
                    r.repository = file;
                    return r;
                }
                zf.close();
                continue;
            }
            catch (IOException ioe) {
                logger.error((Object)("Name= " + name + " " + file), (Throwable)ioe);
                return null;
            }
        }
        return null;
    }

    private byte[] loadBytesFromStream(InputStream in, int length) throws IOException {
        int nRead;
        byte[] buf = new byte[length];
        int count = 0;
        while (length > 0 && (nRead = in.read(buf, count, length)) != -1) {
            count += nRead;
            length -= nRead;
        }
        return buf;
    }

    public URL[] getURLs() {
        return this.urls;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Resource {
        File repository;
        File file;
        ZipEntry zipEntry;
        ZipFile zipFile;

        private Resource() {
        }
    }
}

