/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.depend;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.util.compat.Jdk11Compat;
import org.apache.tomcat.util.depend.DependManager;
import org.apache.tomcat.util.depend.Dependency;

public class DependClassLoader
extends ClassLoader {
    static Log logger = LogFactory.getLog((Class)(class$org$apache$tomcat$util$depend$DependClassLoader == null ? (class$org$apache$tomcat$util$depend$DependClassLoader = DependClassLoader.class$("org.apache.tomcat.util.depend.DependClassLoader")) : class$org$apache$tomcat$util$depend$DependClassLoader));
    protected ClassLoader parent;
    protected ClassLoader parent2;
    private static int debug = 0;
    DependManager dependM;
    protected Object pd;
    static Jdk11Compat jdkCompat = Jdk11Compat.getJdkCompat();
    static /* synthetic */ Class class$org$apache$tomcat$util$depend$DependClassLoader;

    public static ClassLoader getDependClassLoader(DependManager depM, ClassLoader parent, Object pd, int debug) {
        if (jdkCompat.isJava2()) {
            try {
                Class<?> c = Class.forName("org.apache.tomcat.util.depend.DependClassLoader12");
                DCLFactory dcl = (DCLFactory)c.newInstance();
                return dcl.createDependLoader(depM, parent, pd, debug);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return new DependClassLoader(depM, parent, pd);
    }

    DependClassLoader() {
    }

    public DependClassLoader(DependManager depM, ClassLoader parent, Object pd) {
        this.init(depM, parent, pd);
    }

    void init(DependManager depM, ClassLoader parent, Object pd) {
        this.parent = parent;
        this.parent2 = jdkCompat.getParentLoader(parent);
        this.dependM = depM;
        this.pd = pd;
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return this.loadClassInternal1(name, resolve);
    }

    protected Class loadClassInternal1(String name, boolean resolve) throws ClassNotFoundException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("loadClass() " + name + " " + resolve));
        }
        Class c = null;
        c = this.findLoadedClass(name);
        if (c != null) {
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
        String classFileName = name.replace('.', '/') + ".class";
        URL res = this.getResource(classFileName);
        try {
            c = this.parent2.loadClass(name);
            if (c != null) {
                if (resolve) {
                    this.resolveClass(c);
                }
                return c;
            }
        }
        catch (Exception e) {
            c = null;
        }
        if (res == null) {
            throw new ClassNotFoundException(name);
        }
        InputStream is = this.getResourceAsStream(classFileName);
        if (is == null) {
            throw new ClassNotFoundException(name);
        }
        byte[] data = null;
        try {
            if (is.available() > 0 && (data = this.readFully(is)).length == 0) {
                data = null;
            }
            is.close();
        }
        catch (IOException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(" error reading " + name), (Throwable)ex);
            }
            data = null;
            throw new ClassNotFoundException(name + " error reading " + ex.toString());
        }
        if (data == null) {
            throw new ClassNotFoundException(name + " lenght==0");
        }
        c = this.defineClassCompat(name, data, 0, data.length, res);
        this.dependency(c, res);
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    protected Class defineClassCompat(String name, byte[] data, int s, int end, URL res) throws ClassNotFoundException {
        return this.defineClass(data, s, end);
    }

    public URL getResource(String name) {
        return this.parent.getResource(name);
    }

    public InputStream getResourceAsStream(String name) {
        return this.parent.getResourceAsStream(name);
    }

    private void dependency(Class c, URL res) {
        if (res == null) {
            return;
        }
        File f = null;
        if ("file".equals(res.getProtocol())) {
            f = new File(res.getFile());
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("File dep " + f));
            }
            if (!f.exists()) {
                f = null;
            }
        }
        if ("jar".equals(res.getProtocol())) {
            String fileN = res.getFile();
            int idx = fileN.indexOf("!");
            if (idx >= 0) {
                fileN = fileN.substring(0, idx);
            }
            if (fileN.startsWith("file:")) {
                fileN = fileN.substring(5);
            }
            if (fileN.startsWith("/file:")) {
                fileN = fileN.substring(6);
            }
            f = new File(fileN);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Jar dep " + f + " " + f.exists()));
            }
            if (!f.exists()) {
                f = null;
            }
        }
        if (f == null) {
            return;
        }
        Dependency dep = new Dependency();
        dep.setLastModified(f.lastModified());
        dep.setTarget(c);
        dep.setOrigin(f);
        this.dependM.addDependency(dep);
    }

    public ClassLoader getParentLoader() {
        return this.parent;
    }

    private byte[] readFully(InputStream is) throws IOException {
        byte[] b = new byte[1024];
        int count = 0;
        int available = 1024;
        while (true) {
            int nRead;
            if ((nRead = is.read(b, count, available)) == -1) {
                byte[] result = new byte[count];
                System.arraycopy(b, 0, result, 0, count);
                return result;
            }
            count += nRead;
            if ((available -= nRead) != 0) continue;
            byte[] b1 = new byte[b.length * 2];
            available = b.length;
            System.arraycopy(b, 0, b1, 0, b.length);
            b = b1;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface DCLFactory {
        public ClassLoader createDependLoader(DependManager var1, ClassLoader var2, Object var3, int var4);
    }
}

