/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.depend;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.util.depend.Dependency;

public class DependManager {
    static Log logger = LogFactory.getLog((Class)(class$org$apache$tomcat$util$depend$DependManager == null ? (class$org$apache$tomcat$util$depend$DependManager = DependManager.class$("org.apache.tomcat.util.depend.DependManager")) : class$org$apache$tomcat$util$depend$DependManager));
    int delay = 4000;
    Dependency[] deps;
    int depsCount = 0;
    long lastCheck = 0L;
    boolean checking = false;
    long checkTime = 0L;
    int checkCount = 0;
    private boolean expired = false;
    static final int INITIAL_DEP_SIZE = 32;
    private static boolean noWarnBadVM = true;
    private int debug = 0;
    static /* synthetic */ Class class$org$apache$tomcat$util$depend$DependManager;

    public DependManager() {
        this(32);
    }

    public DependManager(int initial_size) {
        this.deps = new Dependency[initial_size];
    }

    public void reset() {
        this.expired = false;
        for (int i = 0; i < this.depsCount; ++i) {
            Dependency d = this.deps[i];
            d.reset();
        }
    }

    public void setDelay(int d) {
        this.delay = d;
    }

    public long getCheckTime() {
        return this.checkTime;
    }

    public long getCheckCount() {
        return this.checkCount;
    }

    public boolean shouldReload() {
        boolean b = this.shouldReload1();
        if (b != this.expired && noWarnBadVM) {
            logger.info((Object)("BUG ( VM or Tomcat? ) shouldReload returns expired=" + b + " and the real value is " + this.expired));
            noWarnBadVM = false;
        }
        return this.expired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean shouldReload1() {
        if (this.expired && logger.isDebugEnabled()) {
            logger.debug((Object)("ShouldReload1 E=" + this.expired + " C=" + this.checking));
        }
        if (this.checking) {
            return this.expired;
        }
        DependManager dependManager = this;
        synchronized (dependManager) {
            try {
                if (this.expired && logger.isDebugEnabled()) {
                    logger.debug((Object)("ShouldReload2 E=" + this.expired + " C=" + this.checking));
                }
                if (this.checking) {
                    boolean bl = this.expired;
                    return bl;
                }
                long startCheck = System.currentTimeMillis();
                if (startCheck - this.lastCheck < (long)this.delay) {
                    if (this.expired && logger.isDebugEnabled()) {
                        logger.debug((Object)("ShouldReload3 E=" + this.expired + " C=" + this.checking));
                    }
                    boolean bl = this.expired;
                    return bl;
                }
                this.checking = true;
                for (int i = 0; i < this.depsCount; ++i) {
                    Dependency d = this.deps[i];
                    if (!d.checkExpiry()) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Found expired file " + d.getOrigin().getName()));
                    }
                    if (d.isLocal()) continue;
                    this.expired = true;
                }
                this.checkTime += this.lastCheck - startCheck;
                ++this.checkCount;
                this.lastCheck = startCheck;
            }
            finally {
                this.checking = false;
            }
            if (this.expired && logger.isDebugEnabled()) {
                logger.debug((Object)("ShouldReload5 E=" + this.expired + " C=" + this.checking));
            }
            return this.expired;
        }
    }

    public void setLastModified(long time) {
        for (int i = 0; i < this.depsCount; ++i) {
            this.deps[i].setLastModified(time);
        }
    }

    public void setExpired(boolean e) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("SetExpired " + e));
        }
        for (int i = 0; i < this.depsCount; ++i) {
            this.deps[i].setExpired(e);
        }
    }

    public synchronized void addDependency(Dependency dep) {
        if (this.depsCount >= this.deps.length) {
            Dependency[] deps1 = new Dependency[this.deps.length * 2];
            System.arraycopy(this.deps, 0, deps1, 0, this.depsCount);
            this.deps = deps1;
        }
        this.deps[this.depsCount++] = dep;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Added " + dep.getOrigin() + " " + dep.getTarget()));
        }
    }

    public void setDebug(int i) {
        this.debug = i;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

