/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.xml;

import java.lang.reflect.Method;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.xml.SaxContext;
import org.apache.tomcat.util.xml.XmlAction;

class MethodSetter
extends XmlAction {
    String mName;
    int paramC;
    String[] paramTypes;
    static final Class STRING_CLASS = "String".getClass();

    public MethodSetter(String mName, int paramC) {
        this.mName = mName;
        this.paramC = paramC;
    }

    public MethodSetter(String mName, int paramC, String[] paramTypes) {
        this.mName = mName;
        this.paramC = paramC;
        this.paramTypes = paramTypes;
    }

    public void start(SaxContext ctx) {
        String[] params = new String[this.paramC];
        ctx.pushObject(params);
    }

    public void end(SaxContext ctx) throws Exception {
        String[] params = (String[])ctx.popObject();
        Object parent = ctx.currentObject();
        if (this.paramC == 0) {
            params = new String[]{ctx.getBody().trim()};
            if (ctx.getDebug() > 0) {
                ctx.log("" + parent.getClass().getName() + "." + this.mName + "( " + params[0] + ")");
            }
        }
        Class[] paramT = new Class[params.length];
        Object[] realParam = new Object[params.length];
        for (int i = 0; i < params.length; ++i) {
            if (this.paramTypes == null) {
                realParam[i] = params[i];
                paramT[i] = STRING_CLASS;
                continue;
            }
            if ("int".equals(this.paramTypes[i])) {
                realParam[i] = new Integer(params[i]);
                paramT[i] = Integer.TYPE;
                continue;
            }
            realParam[i] = params[i];
            paramT[i] = STRING_CLASS;
        }
        Method m = null;
        m = IntrospectionUtils.findMethod(parent.getClass(), (String)this.mName, (Class[])paramT);
        if (m == null) {
            ctx.log("Can't find method " + this.mName + " in " + parent + " CLASS " + parent.getClass());
            return;
        }
        m.invoke(parent, realParam);
        if (ctx.getDebug() > 0) {
            StringBuffer sb = new StringBuffer();
            sb.append("" + parent.getClass().getName() + "." + this.mName + "( ");
            for (int i = 0; i < this.paramC; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(params[i]);
            }
            sb.append(")");
            if (ctx.getDebug() > 0) {
                ctx.log(sb.toString());
            }
        }
    }
}

