/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.EnumSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.python.core.BytecodeLoader;
import org.python.core.Py;
import org.python.core.PyCode;
import org.python.core.PyList;
import org.python.core.PyModule;
import org.python.core.PyObject;
import org.python.core.PyType;
import org.python.core.imp;

public abstract class importer<T>
extends PyObject {
    protected static Logger logger = Logger.getLogger("org.python.import");
    final SearchOrderEntry[] searchOrder = this.makeSearchOrder();

    public importer(PyType subType) {
        super(subType);
    }

    public importer() {
    }

    public abstract String get_data(String var1);

    protected abstract String getSeparator();

    protected abstract String makePackagePath(String var1);

    protected abstract String makeFilename(String var1);

    protected abstract String makeFilePath(String var1);

    protected abstract T makeEntry(String var1);

    protected abstract Bundle makeBundle(String var1, T var2);

    private SearchOrderEntry[] makeSearchOrder() {
        String initName = "__init__.py";
        return new SearchOrderEntry[]{new SearchOrderEntry(this.getSeparator() + imp.makeCompiledFilename(initName), EnumSet.of(EntryType.IS_PACKAGE, EntryType.IS_BYTECODE)), new SearchOrderEntry(this.getSeparator() + initName, EnumSet.of(EntryType.IS_PACKAGE, EntryType.IS_SOURCE)), new SearchOrderEntry("$py.class", EnumSet.of(EntryType.IS_BYTECODE)), new SearchOrderEntry(".py", EnumSet.of(EntryType.IS_SOURCE))};
    }

    protected final PyObject importer_find_module(String fullname, String path) {
        ModuleInfo moduleInfo = this.getModuleInfo(fullname);
        if (moduleInfo == ModuleInfo.ERROR || moduleInfo == ModuleInfo.NOT_FOUND) {
            return Py.None;
        }
        return this;
    }

    protected final PyObject importer_load_module(String fullname) {
        ModuleCodeData moduleCodeData = this.getModuleCode(fullname);
        if (moduleCodeData == null) {
            return Py.None;
        }
        PyModule mod2 = imp.addModule(fullname);
        mod2.__dict__.__setitem__("__loader__", (PyObject)this);
        if (moduleCodeData.isPackage) {
            PyList pkgpath = new PyList();
            pkgpath.add(this.makePackagePath(fullname));
            mod2.__dict__.__setitem__("__path__", (PyObject)pkgpath);
        }
        imp.createFromCode(fullname, moduleCodeData.code, moduleCodeData.path);
        logger.log(Level.FINE, "import {0} # loaded from {1}", new Object[]{fullname, moduleCodeData.path});
        return mod2;
    }

    protected final boolean importer_is_package(String fullname) {
        ModuleInfo info = this.getModuleInfo(fullname);
        return info == ModuleInfo.PACKAGE;
    }

    protected abstract long getSourceMtime(String var1);

    protected final ModuleInfo getModuleInfo(String fullname) {
        String path = this.makeFilename(fullname);
        for (SearchOrderEntry entry : this.searchOrder) {
            T importEntry = this.makeEntry(path + entry.suffix);
            if (importEntry == null) continue;
            if (entry.type.contains((Object)EntryType.IS_PACKAGE)) {
                return ModuleInfo.PACKAGE;
            }
            return ModuleInfo.MODULE;
        }
        return ModuleInfo.NOT_FOUND;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final ModuleCodeData getModuleCode(String fullname) {
        String path = this.makeFilename(fullname);
        String fullPath = this.makeFilePath(fullname);
        if (path.length() < 0) {
            return null;
        }
        for (SearchOrderEntry entry : this.searchOrder) {
            byte[] codeBytes;
            boolean isPackage;
            String fullSearchPath;
            block11: {
                String suffix = entry.suffix;
                String searchPath = path + suffix;
                fullSearchPath = fullPath + suffix;
                logger.log(Level.FINE, "# trying {0}", searchPath);
                T tocEntry = this.makeEntry(searchPath);
                if (tocEntry == null) continue;
                isPackage = entry.type.contains((Object)EntryType.IS_PACKAGE);
                boolean isBytecode = entry.type.contains((Object)EntryType.IS_BYTECODE);
                long mtime = -1L;
                if (isBytecode) {
                    mtime = this.getSourceMtime(searchPath);
                }
                try (Bundle bundle = this.makeBundle(searchPath, tocEntry);){
                    if (isBytecode) {
                        try {
                            codeBytes = imp.readCode(fullname, bundle.inputStream, true, mtime);
                        }
                        catch (IOException ioe) {
                            throw Py.ImportError(ioe.getMessage() + "[path=" + fullSearchPath + "]");
                        }
                        if (codeBytes == null) {
                            continue;
                        }
                        break block11;
                    }
                    codeBytes = imp.compileSource(fullname, bundle.inputStream, fullSearchPath);
                }
            }
            PyCode code2 = BytecodeLoader.makeCode(fullname + "$py", codeBytes, fullSearchPath);
            return new ModuleCodeData(code2, isPackage, fullSearchPath);
        }
        return null;
    }

    protected static class SearchOrderEntry {
        public String suffix;
        public EnumSet<EntryType> type;

        public SearchOrderEntry(String suffix, EnumSet<EntryType> type) {
            this.suffix = suffix;
            this.type = type;
        }
    }

    static enum EntryType {
        IS_SOURCE,
        IS_BYTECODE,
        IS_PACKAGE;

    }

    protected static enum ModuleInfo {
        ERROR,
        NOT_FOUND,
        MODULE,
        PACKAGE;

    }

    protected class ModuleCodeData {
        public PyCode code;
        public boolean isPackage;
        public String path;

        public ModuleCodeData(PyCode code2, boolean isPackage, String path) {
            this.code = code2;
            this.isPackage = isPackage;
            this.path = path;
        }
    }

    protected static abstract class Bundle
    implements AutoCloseable {
        public InputStream inputStream;

        public Bundle(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        @Override
        public abstract void close();
    }
}

