/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core.se;

import jakarta.ws.rs.SeBootstrap;
import java.io.IOException;
import java.net.ServerSocket;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLContext;
import org.jboss.resteasy.core.se.ConfigurationOption;
import org.jboss.resteasy.core.se.DelegateConfiguration;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;

public class ResteasySeConfiguration
implements SeBootstrap.Configuration {
    private final Map<String, Object> properties;

    private ResteasySeConfiguration(Map<String, Object> properties) {
        this.properties = properties;
    }

    public static SeBootstrap.Configuration.Builder builder() {
        return new Builder();
    }

    public static SeBootstrap.Configuration from(SeBootstrap.Configuration configuration) {
        if (configuration instanceof ResteasySeConfiguration) {
            return configuration;
        }
        return new DelegateConfiguration(configuration, new Builder().build());
    }

    public Object property(String name) {
        Object value = this.properties.get(name);
        if (value instanceof LazyValue) {
            return ((LazyValue)value).get();
        }
        return value;
    }

    public boolean hasProperty(String name) {
        return this.properties.containsKey(name);
    }

    private static class LazyValue {
        private final Supplier<Object> supplier;
        private volatile Object value;

        private LazyValue(Supplier<Object> supplier) {
            this.supplier = supplier;
        }

        static LazyValue of(Supplier<Object> supplier) {
            return new LazyValue(supplier);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object get() {
            if (this.value == null) {
                LazyValue lazyValue = this;
                synchronized (lazyValue) {
                    if (this.value == null) {
                        this.value = this.supplier.get();
                    }
                }
            }
            return this.value;
        }
    }

    private static class Builder
    implements SeBootstrap.Configuration.Builder {
        private final Map<String, Object> properties = new ConcurrentHashMap<String, Object>();

        private Builder() {
        }

        public SeBootstrap.Configuration build() {
            HashMap<String, Object> properties = new HashMap<String, Object>(this.properties);
            properties.putIfAbsent("jakarta.ws.rs.SeBootstrap.Protocol", ConfigurationOption.PROTOCOL.defaultValue());
            properties.computeIfAbsent("jakarta.ws.rs.SeBootstrap.Host", host -> ConfigurationOption.HOST.defaultValue());
            if (properties.containsKey("jakarta.ws.rs.SeBootstrap.Port")) {
                Object portValue = properties.get("jakarta.ws.rs.SeBootstrap.Port");
                if (portValue instanceof Integer) {
                    int port = (Integer)portValue;
                    if (port == 0) {
                        properties.put("jakarta.ws.rs.SeBootstrap.Port", LazyValue.of(() -> {
                            Integer n;
                            block8: {
                                ServerSocket socket = ServerSocketFactory.getDefault().createServerSocket(0);
                                try {
                                    socket.setReuseAddress(true);
                                    n = socket.getLocalPort();
                                    if (socket == null) break block8;
                                }
                                catch (Throwable throwable) {
                                    try {
                                        if (socket != null) {
                                            try {
                                                socket.close();
                                            }
                                            catch (Throwable throwable2) {
                                                throwable.addSuppressed(throwable2);
                                            }
                                        }
                                        throw throwable;
                                    }
                                    catch (IOException e) {
                                        LogMessages.LOGGER.debug((Object)"Failed to discover port. Passing port 0 to implementation.", (Throwable)e);
                                        return port;
                                    }
                                }
                                socket.close();
                            }
                            return n;
                        }));
                    } else if (port == -1) {
                        properties.put("jakarta.ws.rs.SeBootstrap.Port", ConfigurationOption.PORT.defaultValue());
                    }
                } else if (!(portValue instanceof LazyValue)) {
                    throw Messages.MESSAGES.invalidArgumentType("jakarta.ws.rs.SeBootstrap.Port", portValue, ConfigurationOption.PORT.expectedType());
                }
            } else {
                properties.put("jakarta.ws.rs.SeBootstrap.Port", ConfigurationOption.PORT.defaultValue());
            }
            properties.putIfAbsent("jakarta.ws.rs.SeBootstrap.RootPath", "/");
            properties.putIfAbsent("jakarta.ws.rs.SeBootstrap.SSLContext", LazyValue.of(() -> {
                try {
                    return SSLContext.getDefault();
                }
                catch (NoSuchAlgorithmException e) {
                    throw Messages.MESSAGES.couldNotLoadSslContext((Throwable)e);
                }
            }));
            properties.putIfAbsent("jakarta.ws.rs.SeBootstrap.SSLClientAuthentication", ConfigurationOption.SSL_CLIENT_AUTHENTICATION.defaultValue());
            return new ResteasySeConfiguration(Collections.unmodifiableMap(properties));
        }

        public SeBootstrap.Configuration.Builder property(String name, Object value) {
            if (value == null) {
                this.properties.remove(name);
            } else {
                ConfigurationOption option = ConfigurationOption.of(name);
                if (option != null) {
                    option.validate(value);
                }
                this.properties.put(name, value);
            }
            return this;
        }

        public <T> SeBootstrap.Configuration.Builder from(BiFunction<String, Class<T>, Optional<T>> propertiesProvider) {
            for (ConfigurationOption option : ConfigurationOption.values()) {
                Optional<Object> value = propertiesProvider.apply(option.key(), option.expectedType());
                value.ifPresent(v -> this.property(option.key(), v));
            }
            return this;
        }

        public SeBootstrap.Configuration.Builder from(Object externalConfig) {
            if (externalConfig instanceof ResteasySeConfiguration) {
                this.properties.putAll(((ResteasySeConfiguration)externalConfig).properties);
            } else if (externalConfig instanceof Builder) {
                this.properties.putAll(((Builder)externalConfig).properties);
            } else if (externalConfig instanceof SeBootstrap.Configuration) {
                SeBootstrap.Configuration configuration = (SeBootstrap.Configuration)externalConfig;
                for (ConfigurationOption option : ConfigurationOption.values()) {
                    Object value = configuration.property(option.key());
                    if (value == null) continue;
                    option.validate(value);
                    this.properties.put(option.key(), value);
                }
            }
            return this;
        }
    }
}

