/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.Closeable;
import java.io.Serializable;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pekko.Done;
import org.apache.pekko.Version$;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorCell;
import org.apache.pekko.actor.ActorPath;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorRefProvider;
import org.apache.pekko.actor.ActorRefWithCell;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ActorSystem$Settings$;
import org.apache.pekko.actor.Cell;
import org.apache.pekko.actor.CoordinatedShutdown;
import org.apache.pekko.actor.CoordinatedShutdown$;
import org.apache.pekko.actor.CoordinatedShutdown$ActorSystemTerminateReason$;
import org.apache.pekko.actor.DynamicAccess;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.Extension;
import org.apache.pekko.actor.ExtensionId;
import org.apache.pekko.actor.ExtensionIdProvider;
import org.apache.pekko.actor.InternalActorRef;
import org.apache.pekko.actor.LocalActorRef;
import org.apache.pekko.actor.Props;
import org.apache.pekko.actor.Props$;
import org.apache.pekko.actor.ReflectiveDynamicAccess;
import org.apache.pekko.actor.Scheduler;
import org.apache.pekko.actor.StopChild;
import org.apache.pekko.actor.Terminated;
import org.apache.pekko.actor.dungeon.ChildrenContainer;
import org.apache.pekko.actor.dungeon.ChildrenContainer$EmptyChildrenContainer$;
import org.apache.pekko.actor.dungeon.ChildrenContainer$TerminatedChildrenContainer$;
import org.apache.pekko.actor.setup.ActorSystemSetup;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.dispatch.DefaultDispatcherPrerequisites;
import org.apache.pekko.dispatch.Dispatchers;
import org.apache.pekko.dispatch.Mailboxes;
import org.apache.pekko.dispatch.MonitorableThreadFactory;
import org.apache.pekko.dispatch.MonitorableThreadFactory$;
import org.apache.pekko.event.DeadLetterListener;
import org.apache.pekko.event.EventStream;
import org.apache.pekko.event.LogMarker$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.event.LoggingFilter;
import org.apache.pekko.event.MarkerLoggingAdapter;
import org.apache.pekko.japi.Util$;
import org.apache.pekko.serialization.SerializationExtension$;
import org.apache.pekko.util.FutureConverters$;
import org.apache.pekko.util.FutureConverters$FutureOps$;
import org.apache.pekko.util.ManifestInfo;
import org.apache.pekko.util.ManifestInfo$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.NotImplementedError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.package$;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.ControlThrowable;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0011-b!B0a\u0001\tD\u0007\u0002C7\u0001\u0005\u000b\u0007I\u0011A8\t\u0011u\u0004!\u0011!Q\u0001\nAD\u0001B \u0001\u0003\u0002\u0003\u0006Ia \u0005\u000b\u0003'\u0001!\u0011!Q\u0001\n\u0005U\u0001BCA\u0013\u0001\t\u0005\t\u0015!\u0003\u0002(!Q\u00111\b\u0001\u0003\u0006\u0004%\t!!\u0010\t\u0015\u0005\u001d\u0003A!A!\u0002\u0013\ty\u0004\u0003\u0006\u0002J\u0001\u0011\t\u0011)A\u0005\u0003\u0017Bq!!\u0016\u0001\t\u0003\t9\u0006C\u0005\u0002h\u0001\u0011\r\u0011\"\u0001\u0002j!A\u0011\u0011\u000f\u0001!\u0002\u0013\tY\u0007C\u0005\u0002t\u0001\u0001\r\u0011\"\u0003\u0002v!I\u0011q\u0010\u0001A\u0002\u0013%\u0011\u0011\u0011\u0005\t\u0003\u001b\u0003\u0001\u0015)\u0003\u0002x!I\u0011q\u0013\u0001C\u0002\u0013%\u0011\u0011\u0014\u0005\t\u0003C\u0003\u0001\u0015!\u0003\u0002\u001c\"I\u00111\u0015\u0001C\u0002\u0013\u0015\u0011Q\u0015\u0005\t\u0003k\u0003\u0001\u0015!\u0004\u0002(\"9\u0011q\u0017\u0001\u0005\u0012\u0005e\u0006\"CAe\u0001\t\u0007IQAAf\u0011!\tI\u000e\u0001Q\u0001\u000e\u00055\u0007bBAn\u0001\u0011E\u0011Q\u001c\u0005\b\u0003?\u0004A\u0011AAM\u0011\u001d\t\t\u000f\u0001C\u0001\u0003GDq!!:\u0001\t#\t9\u000fC\u0004\u0002j\u0002!\t!a;\t\u000f\u0005M\b\u0001\"\u0001\u0002v\"9\u00111\u001f\u0001\u0005\u0002\u0005m\bbBA\u0000\u0001\u0011\u0005!\u0011\u0001\u0005\n\u0005\u000b\u0001!\u0019!C\u0001\u0005\u000fA\u0001B!\u0006\u0001A\u0003%!\u0011\u0002\u0005\n\u0005/\u0001!\u0019!C\u0001\u00053A\u0001B!\t\u0001A\u0003%!1\u0004\u0005\u000f\u0005G\u0001A\u0011!A\u0003\u0002\u0003\u0005\u000b\u0011\u0002B\u0013\u0011%\u0011Y\u0003\u0001b\u0001\n\u0003\u0011i\u0003\u0003\u0005\u00036\u0001\u0001\u000b\u0011\u0002B\u0018\u0011%\u00119\u0004\u0001b\u0001\n\u0003\u0011I\u0004\u0003\u0005\u0003B\u0001\u0001\u000b\u0011\u0002B\u001e\u0011%\u0011\u0019\u0005\u0001b\u0001\n\u0003\u0011)\u0005\u0003\u0005\u0003N\u0001\u0001\u000b\u0011\u0002B$\u0011\u001d\u0011y\u0005\u0001C\u0001\u0005#B\u0011Ba\u0015\u0001\u0005\u0004%\tA!\u0016\t\u0011\tu\u0003\u0001)A\u0005\u0005/B\u0011Ba\u0018\u0001\u0005\u0004%\tA!\u0019\t\u0011\t%\u0004\u0001)A\u0005\u0005GB\u0011Ba\u001b\u0001\u0005\u0004%\tA!\u001c\t\u0011\tU\u0004\u0001)A\u0005\u0005_B\u0001Ba\u001e\u0001A\u00035!\u0011\u0010\u0005\b\u0005O\u0004A\u0011\tBu\u0011\u001d\u0011i\u000f\u0001C!\u0005_DqA!?\u0001\t\u0003\u0011Y\u0010C\u0004\u0004\u0004\u0001!\ta!\u0002\t\u000f\r5\u0001\u0001\"\u0001\u0004\u0006!91q\u0002\u0001\u0005\u0002\rE\u0001bBB\b\u0001\u0011\u00051Q\u0004\u0005\b\u0007k\u0001A\u0011IB\u001c\u0011\u001d\u0019y\u0004\u0001C\u0005\u0007\u0003B\u0011b!\u0013\u0001\u0001\u0004%Iaa\u0013\t\u0013\rM\u0003\u00011A\u0005\n\rU\u0003\u0002CB-\u0001\u0001\u0006Ka!\u0014\t\u000f\ru\u0003\u0001\"\u0001\u0002d\"Q1q\f\u0001\t\u0006\u0004%Ia!\u0019\t\u000f\r\r\u0004\u0001\"\u0001\u0004f!91q\r\u0001\u0005\u0002\r%\u0004bBB4\u0001\u0011\u000511\u0010\u0005\n\u0007\u007f\u0002\u0001\u0019!C\u0005\u0007\u0017B\u0011b!!\u0001\u0001\u0004%Iaa!\t\u0011\r\u001d\u0005\u0001)Q\u0005\u0007\u001bBqaa#\u0001\t\u0003\u001ai\t\u0003\u0005\u0004\u0010\u0002!\tEYAr\u0011!\u0019\t\n\u0001C!E\u000eM\u0005\"CBK\u0001\u0001\u0007I\u0011AB&\u0011%\u00199\n\u0001a\u0001\n\u0003\u0019I\n\u0003\u0005\u0004\u001e\u0002\u0001\u000b\u0015BB'\u0011\u001d\u0019\t\u000b\u0001C\u0001\u0003GDqaa)\u0001\t#\u0019)\u000bC\u0004\u0004(\u0002!\t\"a9\t\u0013\r%\u0006A1A\u0005\n\r-\u0006\u0002CBa\u0001\u0001\u0006Ia!,\t\u000f\r\r\u0007\u0001\"\u0003\u0004F\"91\u0011\u001e\u0001\u0005\u0006\r-\bbBB}\u0001\u0011\u000511 \u0005\b\t\u000f\u0001A\u0011\u0001C\u0005\u0011\u001d!9\u0002\u0001C\u0005\u0003GDq\u0001\"\u0007\u0001\t\u0003\"Y\u0002\u0003\u0004\u0005\u001e\u0001!\te\u001c\u0004\u0007\u0005{\u0002!Aa \t\u0015\t%uK!A!\u0002\u0013\u0011Y\t\u0003\u0006\u0003(^\u0013\t\u0011)A\u0006\u0003_Aq!!\u0016X\t\u0003\u0011I\u000b\u0003\u0005\u00034^\u0003\u000bQ\u0002B[\u0011!\u0011Yl\u0016Q\u0001\u000e\tu\u0006b\u0002Bh/\u0012\u0015!\u0011\u001b\u0005\b\u0005;<F\u0011\u0001Bp\u0005=\t5\r^8s'f\u001cH/Z7J[Bd'BA1c\u0003\u0015\t7\r^8s\u0015\t\u0019G-A\u0003qK.\\wN\u0003\u0002fM\u00061\u0011\r]1dQ\u0016T\u0011aZ\u0001\u0004_J<7C\u0001\u0001j!\tQ7.D\u0001a\u0013\ta\u0007MA\nFqR,g\u000eZ3e\u0003\u000e$xN]*zgR,W.\u0001\u0003oC6,7\u0001A\u000b\u0002aB\u0011\u0011O\u001f\b\u0003eb\u0004\"a\u001d<\u000e\u0003QT!!\u001e8\u0002\rq\u0012xn\u001c;?\u0015\u00059\u0018!B:dC2\f\u0017BA=w\u0003\u0019\u0001&/\u001a3fM&\u00111\u0010 \u0002\u0007'R\u0014\u0018N\\4\u000b\u0005e4\u0018!\u00028b[\u0016\u0004\u0013!E1qa2L7-\u0019;j_:\u001cuN\u001c4jOB!\u0011\u0011AA\b\u001b\t\t\u0019A\u0003\u0003\u0002\u0006\u0005\u001d\u0011AB2p]\u001aLwM\u0003\u0003\u0002\n\u0005-\u0011\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0005\u00055\u0011aA2p[&!\u0011\u0011CA\u0002\u0005\u0019\u0019uN\u001c4jO\u0006Y1\r\\1tg2{\u0017\rZ3s!\u0011\t9\"!\t\u000e\u0005\u0005e!\u0002BA\u000e\u0003;\tA\u0001\\1oO*\u0011\u0011qD\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002$\u0005e!aC\"mCN\u001cHj\\1eKJ\fq\u0003Z3gCVdG/\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0011\r\u0005%\u00121FA\u0018\u001b\u00051\u0018bAA\u0017m\n1q\n\u001d;j_:\u0004B!!\r\u000285\u0011\u00111\u0007\u0006\u0004\u0003k1\u0018AC2p]\u000e,(O]3oi&!\u0011\u0011HA\u001a\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH/A\u0007hk\u0006\u0014H-[1o!J|\u0007o]\u000b\u0003\u0003\u007f\u0001b!!\u000b\u0002,\u0005\u0005\u0003c\u00016\u0002D%\u0019\u0011Q\t1\u0003\u000bA\u0013x\u000e]:\u0002\u001d\u001d,\u0018M\u001d3jC:\u0004&o\u001c9tA\u0005)1/\u001a;vaB!\u0011QJA)\u001b\t\tyEC\u0002\u0002J\u0001LA!a\u0015\u0002P\t\u0001\u0012i\u0019;peNK8\u000f^3n'\u0016$X\u000f]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u001d\u0005e\u00131LA/\u0003?\n\t'a\u0019\u0002fA\u0011!\u000e\u0001\u0005\u0006[&\u0001\r\u0001\u001d\u0005\u0006}&\u0001\ra \u0005\b\u0003'I\u0001\u0019AA\u000b\u0011\u001d\t)#\u0003a\u0001\u0003OAq!a\u000f\n\u0001\u0004\ty\u0004C\u0004\u0002J%\u0001\r!a\u0013\u0002\u0007ULG-\u0006\u0002\u0002lA!\u0011\u0011FA7\u0013\r\tyG\u001e\u0002\u0005\u0019>tw-\u0001\u0003vS\u0012\u0004\u0013!\u00067pO\u0012+\u0017\r\u001a'fiR,'\u000fT5ti\u0016tWM]\u000b\u0003\u0003o\u0002b!!\u000b\u0002,\u0005e\u0004c\u00016\u0002|%\u0019\u0011Q\u00101\u0003\u0011\u0005\u001bGo\u001c:SK\u001a\f\u0011\u0004\\8h\t\u0016\fG\rT3ui\u0016\u0014H*[:uK:,'o\u0018\u0013fcR!\u00111QAE!\u0011\tI#!\"\n\u0007\u0005\u001deO\u0001\u0003V]&$\b\"CAF\u001b\u0005\u0005\t\u0019AA<\u0003\rAH%M\u0001\u0017Y><G)Z1e\u0019\u0016$H/\u001a:MSN$XM\\3sA!\u001aa\"!%\u0011\t\u0005%\u00121S\u0005\u0004\u0003+3(\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002\u001d}#\u0017P\\1nS\u000e\f5mY3tgV\u0011\u00111\u0014\t\u0004U\u0006u\u0015bAAPA\niA)\u001f8b[&\u001c\u0017iY2fgN\fqb\u00183z]\u0006l\u0017nY!dG\u0016\u001c8\u000fI\u0001\tg\u0016$H/\u001b8hgV\u0011\u0011q\u0015\t\u0005\u0003S\u000byKD\u0002k\u0003WK1!!,a\u0003-\t5\r^8s'f\u001cH/Z7\n\t\u0005E\u00161\u0017\u0002\t'\u0016$H/\u001b8hg*\u0019\u0011Q\u00161\u0002\u0013M,G\u000f^5oON\u0004\u0013\u0001G;oG\u0006,x\r\u001b;Fq\u000e,\u0007\u000f^5p]\"\u000bg\u000e\u001a7feV\u0011\u00111\u0018\t\u0005\u0003{\u000b\u0019M\u0004\u0003\u0002\u0018\u0005}\u0016\u0002BAa\u00033\ta\u0001\u00165sK\u0006$\u0017\u0002BAc\u0003\u000f\u0014\u0001$\u00168dCV<\u0007\u000e^#yG\u0016\u0004H/[8o\u0011\u0006tG\r\\3s\u0015\u0011\t\t-!\u0007\u0002\u001bQD'/Z1e\r\u0006\u001cGo\u001c:z+\t\ti\r\u0005\u0003\u0002P\u0006UWBAAi\u0015\r\t\u0019NY\u0001\tI&\u001c\b/\u0019;dQ&!\u0011q[Ai\u0005aiuN\\5u_J\f'\r\\3UQJ,\u0017\r\u001a$bGR|'/_\u0001\u000fi\"\u0014X-\u00193GC\u000e$xN]=!\u0003M\u0019'/Z1uK\u0012Kh.Y7jG\u0006\u001b7-Z:t)\t\tY*A\u0007es:\fW.[2BG\u000e,7o]\u0001\u0011Y><7i\u001c8gS\u001e,(/\u0019;j_:$\"!a!\u0002\u0015ML8\u000f^3n\u00136\u0004H.\u0006\u0002\u0002Z\u0005i1/_:uK6\f5\r^8s\u001f\u001a$b!!\u001f\u0002n\u0006E\bbBAx5\u0001\u0007\u0011\u0011I\u0001\u0006aJ|\u0007o\u001d\u0005\u0006[j\u0001\r\u0001]\u0001\bC\u000e$xN](g)\u0019\tI(a>\u0002z\"9\u0011q^\u000eA\u0002\u0005\u0005\u0003\"B7\u001c\u0001\u0004\u0001H\u0003BA=\u0003{Dq!a<\u001d\u0001\u0004\t\t%\u0001\u0003ti>\u0004H\u0003BAB\u0005\u0007Aa!Y\u000fA\u0002\u0005e\u0014aC3wK:$8\u000b\u001e:fC6,\"A!\u0003\u0011\t\t-!\u0011C\u0007\u0003\u0005\u001bQ1Aa\u0004c\u0003\u0015)g/\u001a8u\u0013\u0011\u0011\u0019B!\u0004\u0003\u0017\u00153XM\u001c;TiJ,\u0017-\\\u0001\rKZ,g\u000e^*ue\u0016\fW\u000eI\u0001\nY><g)\u001b7uKJ,\"Aa\u0007\u0011\t\t-!QD\u0005\u0005\u0005?\u0011iAA\u0007M_\u001e<\u0017N\\4GS2$XM]\u0001\u000bY><g)\u001b7uKJ\u0004\u0013!N8sO\u0012\n\u0007/Y2iK\u0012\u0002Xm[6pI\u0005\u001cGo\u001c:%\u0003\u000e$xN]*zgR,W.S7qY\u0012\"S.\u0019:lKJdunZ4j]\u001e\u0004BAa\u0003\u0003(%!!\u0011\u0006B\u0007\u0005Qi\u0015M]6fe2{wmZ5oO\u0006#\u0017\r\u001d;fe\u0006\u0019An\\4\u0016\u0005\t=\u0002\u0003\u0002B\u0006\u0005cIAAa\r\u0003\u000e\tqAj\\4hS:<\u0017\tZ1qi\u0016\u0014\u0018\u0001\u00027pO\u0002\n\u0011b]2iK\u0012,H.\u001a:\u0016\u0005\tm\u0002c\u00016\u0003>%\u0019!q\b1\u0003\u0013M\u001b\u0007.\u001a3vY\u0016\u0014\u0018AC:dQ\u0016$W\u000f\\3sA\u0005A\u0001O]8wS\u0012,'/\u0006\u0002\u0003HA\u0019!N!\u0013\n\u0007\t-\u0003M\u0001\tBGR|'OU3g!J|g/\u001b3fe\u0006I\u0001O]8wS\u0012,'\u000fI\u0001\fI\u0016\fG\rT3ui\u0016\u00148/\u0006\u0002\u0002z\u0005IQ.Y5mE>DXm]\u000b\u0003\u0005/\u0002B!a4\u0003Z%!!1LAi\u0005%i\u0015-\u001b7c_b,7/\u0001\u0006nC&d'm\u001c=fg\u0002\n1\u0002Z5ta\u0006$8\r[3sgV\u0011!1\r\t\u0005\u0003\u001f\u0014)'\u0003\u0003\u0003h\u0005E'a\u0003#jgB\fGo\u00195feN\fA\u0002Z5ta\u0006$8\r[3sg\u0002\n!\u0002Z5ta\u0006$8\r[3s+\t\u0011y\u0007\u0005\u0003\u00022\tE\u0014\u0002\u0002B:\u0003g\u0011\u0001$\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;Fq\u0016\u001cW\u000f^8s\u0003-!\u0017n\u001d9bi\u000eDWM\u001d\u0011\u0002)Q,'/\\5oCRLwN\\\"bY2\u0014\u0017mY6t!\u0015\u0011Yh\u0016Bq\u001b\u0005\u0001!\u0001\u0006+fe6Lg.\u0019;j_:\u001c\u0015\r\u001c7cC\u000e\\7/\u0006\u0003\u0003\u0002\nU5cA,\u0003\u0004B!\u0011\u0011\u0006BC\u0013\r\u00119I\u001e\u0002\u0007\u0003:L(+\u001a4\u0002%U\u00048\u000b\u001e:fC6$VM]7j]\u0006$X\r\u001a\t\u0007\u0003c\u0011iI!%\n\t\t=\u00151\u0007\u0002\u0007\rV$XO]3\u0011\t\tM%Q\u0013\u0007\u0001\t\u001d\u00119j\u0016b\u0001\u00053\u0013\u0011\u0001V\t\u0005\u00057\u0013\t\u000b\u0005\u0003\u0002*\tu\u0015b\u0001BPm\n9aj\u001c;iS:<\u0007\u0003BA\u0015\u0005GK1A!*w\u0005\r\te._\u0001\u0003K\u000e$BAa+\u00032R!!Q\u0016BX!\u0015\u0011Yh\u0016BI\u0011\u001d\u00119K\u0017a\u0002\u0003_AqA!#[\u0001\u0004\u0011Y)\u0001\u0003e_:,\u0007CBA\u0019\u0005o\u0013\t*\u0003\u0003\u0003:\u0006M\"a\u0002)s_6L7/Z\u0001\u0004e\u00164\u0007C\u0002B`\u0005\u0017\u0014),\u0004\u0002\u0003B*!!1\u0019Bc\u0003\u0019\tGo\\7jG*!\u0011Q\u0007Bd\u0015\u0011\u0011I-!\b\u0002\tU$\u0018\u000e\\\u0005\u0005\u0005\u001b\u0014\tMA\bBi>l\u0017n\u0019*fM\u0016\u0014XM\\2f\u0003\r\tG\r\u001a\u000b\u0005\u0003\u0007\u0013\u0019\u000eC\u0004\u0003Vv\u0003\rAa6\u0002\u0003I\u0004B!a\u0006\u0003Z&!!1\\A\r\u0005!\u0011VO\u001c8bE2,\u0017!\u0005;fe6Lg.\u0019;j_:4U\u000f^;sKV\u0011!1\u0012\t\u0004U\n\r\u0018b\u0001BsA\nQA+\u001a:nS:\fG/\u001a3\u0002\u001d]DWM\u001c+fe6Lg.\u0019;fIV\u0011!1\u001e\t\u0007\u0003c\u0011iI!9\u0002#\u001d,Go\u00165f]R+'/\\5oCR,G-\u0006\u0002\u0003rB1!1\u001fB{\u0005Cl!A!2\n\t\t](Q\u0019\u0002\u0010\u0007>l\u0007\u000f\\3uS>t7\u000b^1hK\u0006QAn\\8lkB\u0014vn\u001c;\u0016\u0005\tu\bc\u00016\u0003\u0000&\u00191\u0011\u00011\u0003!%sG/\u001a:oC2\f5\r^8s%\u00164\u0017\u0001C4vCJ$\u0017.\u00198\u0016\u0005\r\u001d\u0001c\u00016\u0004\n%\u001911\u00021\u0003\u001b1{7-\u00197BGR|'OU3g\u00039\u0019\u0018p\u001d;f[\u001e+\u0018M\u001d3jC:\fA\u0001\n3jmR!11CB\r!\rQ7QC\u0005\u0004\u0007/\u0001'!C!di>\u0014\b+\u0019;i\u0011\u0019\u0019YB\u000ea\u0001a\u0006I\u0011m\u0019;pe:\u000bW.\u001a\u000b\u0005\u0007'\u0019y\u0002C\u0004\u0004\"]\u0002\raa\t\u0002\tA\fG\u000f\u001b\t\u0006\u0007K\u0019y\u0003\u001d\b\u0005\u0007O\u0019YCD\u0002t\u0007SI\u0011a^\u0005\u0004\u0007[1\u0018a\u00029bG.\fw-Z\u0005\u0005\u0007c\u0019\u0019D\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\r\u0019iC^\u0001\u000eG2\f7o]5d'f\u001cH/Z7\u0016\u0005\re\u0002c\u00016\u0004<%\u00191Q\b1\u0003\u0017\u0005\u001bGo\u001c:TsN$X-\\\u0001\u000bC2dWj\u001c3vY\u0016\u001cXCAB\"!\u0015\u0019)c!\u0012q\u0013\u0011\u00199ea\r\u0003\t1K7\u000f^\u0001\r?&t\u0017\u000e^5bY&TX\rZ\u000b\u0003\u0007\u001b\u0002B!!\u000b\u0004P%\u00191\u0011\u000b<\u0003\u000f\t{w\u000e\\3b]\u0006\u0001r,\u001b8ji&\fG.\u001b>fI~#S-\u001d\u000b\u0005\u0003\u0007\u001b9\u0006C\u0005\u0002\fn\n\t\u00111\u0001\u0004N\u0005iq,\u001b8ji&\fG.\u001b>fI\u0002B3\u0001PAI\u0003E\t7o]3si&s\u0017\u000e^5bY&TX\rZ\u0001\u0007?N$\u0018M\u001d;\u0016\u0005\tm\u0014!B:uCJ$HC\u0001B>\u0003U\u0011XmZ5ti\u0016\u0014xJ\u001c+fe6Lg.\u0019;j_:,Baa\u001b\u0004zQ!\u00111QB7\u0011!\u0019y\u0007\u0011CA\u0002\rE\u0014\u0001B2pI\u0016\u0004b!!\u000b\u0004t\r]\u0014bAB;m\nAAHY=oC6,g\b\u0005\u0003\u0003\u0014\u000eeDa\u0002BL\u0001\n\u0007!\u0011\u0014\u000b\u0005\u0003\u0007\u001bi\bC\u0004\u0004p\u0005\u0003\rAa6\u0002\u0017Q,'/\\5oCRLgnZ\u0001\u0010i\u0016\u0014X.\u001b8bi&twm\u0018\u0013fcR!\u00111QBC\u0011%\tYiQA\u0001\u0002\u0004\u0019i%\u0001\u0007uKJl\u0017N\\1uS:<\u0007\u0005K\u0002E\u0003#\u000b\u0011\u0002^3s[&t\u0017\r^3\u0015\u0005\t-\u0018A\u00044j]\u0006dG+\u001a:nS:\fG/Z\u0001\u000eSN$VM]7j]\u0006$\u0018N\\4\u0015\u0005\r5\u0013\u0001C1c_J$\u0018N\\4\u0002\u0019\u0005\u0014wN\u001d;j]\u001e|F%Z9\u0015\t\u0005\r51\u0014\u0005\n\u0003\u0017K\u0015\u0011!a\u0001\u0007\u001b\n\u0011\"\u00192peRLgn\u001a\u0011)\u0007)\u000b\t*A\u0003bE>\u0014H/A\bde\u0016\fG/Z*dQ\u0016$W\u000f\\3s)\t\u0011Y$A\u0007ti>\u00048k\u00195fIVdWM]\u0001\u000bKb$XM\\:j_:\u001cXCABW!!\u0011\u0019pa,\u00044\n\r\u0015\u0002BBY\u0005\u000b\u0014\u0011cQ8oGV\u0014(/\u001a8u\u0011\u0006\u001c\b.T1qa\u0011\u0019)l!0\u0011\u000b)\u001c9la/\n\u0007\re\u0006MA\u0006FqR,gn]5p]&#\u0007\u0003\u0002BJ\u0007{#1ba0P\u0003\u0003\u0005\tQ!\u0001\u0003\u001a\n\u0019q\f\n\u001a\u0002\u0017\u0015DH/\u001a8tS>t7\u000fI\u0001\u000eM&tG-\u0012=uK:\u001c\u0018n\u001c8\u0016\t\r\u001d71\u001a\u000b\u0005\u0007\u0013\u001c)\u000e\u0005\u0003\u0003\u0014\u000e-Ga\u0002BL!\n\u00071QZ\t\u0005\u00057\u001by\rE\u0002k\u0007#L1aa5a\u0005%)\u0005\u0010^3og&|g\u000eC\u0004\u0004XB\u0003\ra!7\u0002\u0007\u0015DH\u000fE\u0003k\u0007o\u001bI\rK\u0002Q\u0007;\u0004Baa8\u0004f6\u00111\u0011\u001d\u0006\u0004\u0007G4\u0018AC1o]>$\u0018\r^5p]&!1q]Bq\u0005\u001d!\u0018-\u001b7sK\u000e\f\u0011C]3hSN$XM]#yi\u0016t7/[8o+\u0011\u0019io!=\u0015\t\r=81\u001f\t\u0005\u0005'\u001b\t\u0010B\u0004\u0003\u0018F\u0013\ra!4\t\u000f\r]\u0017\u000b1\u0001\u0004vB)!na.\u0004p\"\u001a\u0011k!8\u0002\u0013\u0015DH/\u001a8tS>tW\u0003BB\u007f\t\u0003!Baa@\u0005\u0004A!!1\u0013C\u0001\t\u001d\u00119J\u0015b\u0001\u0007\u001bDqaa6S\u0001\u0004!)\u0001E\u0003k\u0007o\u001by0\u0001\u0007iCN,\u0005\u0010^3og&|g\u000e\u0006\u0003\u0004N\u0011-\u0001bBBl'\u0002\u0007AQ\u0002\u0019\u0005\t\u001f!\u0019\u0002E\u0003k\u0007o#\t\u0002\u0005\u0003\u0003\u0014\u0012MA\u0001\u0004C\u000b\t\u0017\t\t\u0011!A\u0003\u0002\r5'aA0%g\u0005qAn\\1e\u000bb$XM\\:j_:\u001c\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003A\f\u0011\u0002\u001d:j]R$&/Z3)\u0007\u0001!\t\u0003\u0005\u0003\u0005$\u0011\u001dRB\u0001C\u0013\u0015\r\u0019\u0019OY\u0005\u0005\tS!)CA\u0006J]R,'O\\1m\u0003BL\u0007")
@InternalApi
public class ActorSystemImpl
extends ExtendedActorSystem {
    private ActorSystemImpl _start;
    private final String name;
    private final ClassLoader classLoader;
    private final Option<Props> guardianProps;
    private final long uid;
    private volatile Option<ActorRef> logDeadLetterListener;
    private final DynamicAccess _dynamicAccess;
    private final ActorSystem.Settings settings;
    private final MonitorableThreadFactory threadFactory;
    private final EventStream eventStream;
    private final LoggingFilter logFilter;
    public final MarkerLoggingAdapter org$apache$pekko$actor$ActorSystemImpl$$markerLogging;
    private final LoggingAdapter log;
    private final Scheduler scheduler;
    private final ActorRefProvider provider;
    private final Mailboxes mailboxes;
    private final Dispatchers dispatchers;
    private final ExecutionContextExecutor dispatcher;
    private final TerminationCallbacks<Terminated> terminationCallbacks;
    private volatile boolean _initialized;
    private volatile boolean terminating;
    private volatile boolean aborting;
    private final ConcurrentHashMap<ExtensionId<?>, Object> extensions;
    private volatile boolean bitmap$0;

    @Override
    public String name() {
        return this.name;
    }

    public Option<Props> guardianProps() {
        return this.guardianProps;
    }

    @Override
    public long uid() {
        return this.uid;
    }

    private Option<ActorRef> logDeadLetterListener() {
        return this.logDeadLetterListener;
    }

    private void logDeadLetterListener_$eq(Option<ActorRef> x$1) {
        this.logDeadLetterListener = x$1;
    }

    private DynamicAccess _dynamicAccess() {
        return this._dynamicAccess;
    }

    @Override
    public final ActorSystem.Settings settings() {
        return this.settings;
    }

    public Thread.UncaughtExceptionHandler uncaughtExceptionHandler() {
        return new Thread.UncaughtExceptionHandler(this){
            private final /* synthetic */ ActorSystemImpl $outer;

            public void uncaughtException(Thread thread, Throwable cause) {
                Option option;
                Throwable throwable = cause;
                if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty() ? true : (throwable instanceof InterruptedException ? true : (throwable instanceof NotImplementedError ? true : throwable instanceof ControlThrowable))) {
                    this.$outer.log().error(cause, "Uncaught error from thread [{}]", (Object)thread.getName());
                    return;
                }
                if (cause instanceof IncompatibleClassChangeError && cause.getMessage().startsWith("org.apache.pekko")) {
                    System.err.println(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(578).append("Detected ").append(cause.getClass().getName()).append(" error, which MAY be caused by incompatible Pekko versions on the classpath.\n                  | Please note that a given Pekko version MUST be the same across all modules of Pekko that you are using,\n                  | e.g. if you use pekko-actor [").append(Version$.MODULE$.current()).append(" (resolved from current classpath)] all other core\n                  | Pekko modules MUST be of the same version. External projects like Connectors, Persistence plugins or Pekko\n                  | HTTP etc. have their own version numbers - please make sure you're using a compatible set of libraries.\n                 ").toString())).replaceAll("[\r\n]", ""));
                }
                if (this.$outer.settings().JvmExitOnFatalError()) {
                    try {
                        this.logFatalError("shutting down JVM since 'pekko.jvm-exit-on-fatal-error' is enabled for", cause, thread);
                    }
                    finally {
                        System.exit(-1);
                    }
                    return;
                }
                try {
                    this.logFatalError("shutting down", cause, thread);
                }
                finally {
                    this.$outer.terminate();
                }
            }

            private void logFatalError(String message, Throwable cause, Thread thread) {
                System.err.print("Uncaught error from thread [");
                System.err.print(thread.getName());
                System.err.print("]: ");
                System.err.print(cause.getMessage());
                System.err.print(", ");
                System.err.print(message);
                System.err.print(" ActorSystem[");
                System.err.print(this.$outer.name());
                System.err.println("]");
                System.err.flush();
                cause.printStackTrace(System.err);
                System.err.flush();
                this.$outer.org$apache$pekko$actor$ActorSystemImpl$$markerLogging.error(LogMarker$.MODULE$.Security(), cause, new StringBuilder(51).append("Uncaught error from thread [{}]: ").append(cause.getMessage()).append(", ").append(message).append(" ActorSystem[{}]").toString(), (Object)thread.getName(), (Object)this.$outer.name());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    @Override
    public final MonitorableThreadFactory threadFactory() {
        return this.threadFactory;
    }

    public DynamicAccess createDynamicAccess() {
        return new ReflectiveDynamicAccess(this.classLoader);
    }

    @Override
    public DynamicAccess dynamicAccess() {
        return this._dynamicAccess();
    }

    @Override
    public void logConfiguration() {
        this.log().info(this.settings().toString());
    }

    @Override
    public ActorSystemImpl systemImpl() {
        return this;
    }

    @Override
    public ActorRef systemActorOf(Props props, String name) {
        return this.systemGuardian().underlying().attachChild(props, name, true);
    }

    @Override
    public ActorRef actorOf(Props props, String name) {
        if (this.guardianProps().isEmpty()) {
            return this.guardian().underlying().attachChild(props, name, false);
        }
        throw new UnsupportedOperationException(new StringBuilder(90).append("cannot create top-level actor [").append(name).append("] from the outside on ActorSystem with custom user guardian").toString());
    }

    @Override
    public ActorRef actorOf(Props props) {
        if (this.guardianProps().isEmpty()) {
            return this.guardian().underlying().attachChild(props, false);
        }
        throw new UnsupportedOperationException("cannot create top-level actor from the outside on ActorSystem with custom user guardian");
    }

    @Override
    public void stop(ActorRef actor) {
        ActorPath path = actor.path();
        ActorPath guard = this.guardian().path();
        ActorPath sys = this.systemGuardian().path();
        ActorPath actorPath = path.parent();
        ActorPath actorPath2 = guard;
        ActorPath actorPath3 = actorPath;
        if (!(actorPath2 != null ? !actorPath2.equals(actorPath3) : actorPath3 != null)) {
            LocalActorRef qual$1 = this.guardian();
            StopChild x$1 = new StopChild(actor);
            ActorRef x$2 = qual$1.$bang$default$2(x$1);
            qual$1.$bang(x$1, x$2);
            return;
        }
        ActorPath actorPath4 = sys;
        ActorPath actorPath5 = actorPath;
        if (!(actorPath4 != null ? !actorPath4.equals(actorPath5) : actorPath5 != null)) {
            LocalActorRef qual$2 = this.systemGuardian();
            StopChild x$3 = new StopChild(actor);
            ActorRef x$4 = qual$2.$bang$default$2(x$3);
            qual$2.$bang(x$3, x$4);
            return;
        }
        ((InternalActorRef)actor).stop();
    }

    @Override
    public EventStream eventStream() {
        return this.eventStream;
    }

    @Override
    public LoggingFilter logFilter() {
        return this.logFilter;
    }

    @Override
    public LoggingAdapter log() {
        return this.log;
    }

    @Override
    public Scheduler scheduler() {
        return this.scheduler;
    }

    @Override
    public ActorRefProvider provider() {
        return this.provider;
    }

    @Override
    public ActorRef deadLetters() {
        return this.provider().deadLetters();
    }

    @Override
    public Mailboxes mailboxes() {
        return this.mailboxes;
    }

    @Override
    public Dispatchers dispatchers() {
        return this.dispatchers;
    }

    @Override
    public ExecutionContextExecutor dispatcher() {
        return this.dispatcher;
    }

    @Override
    public Future<Terminated> whenTerminated() {
        return this.terminationCallbacks.terminationFuture();
    }

    @Override
    public CompletionStage<Terminated> getWhenTerminated() {
        return FutureConverters$FutureOps$.MODULE$.asJava$extension(FutureConverters$.MODULE$.FutureOps(this.whenTerminated()));
    }

    @Override
    public InternalActorRef lookupRoot() {
        return this.provider().rootGuardian();
    }

    @Override
    public LocalActorRef guardian() {
        return this.provider().guardian();
    }

    @Override
    public LocalActorRef systemGuardian() {
        return this.provider().systemGuardian();
    }

    @Override
    public ActorPath $div(String actorName) {
        return this.guardian().path().$div(actorName);
    }

    @Override
    public ActorPath $div(Iterable<String> path) {
        return this.guardian().path().$div(path);
    }

    @Override
    public ActorSystem classicSystem() {
        return this;
    }

    private List<String> allModules() {
        return (List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"pekko-actor", "pekko-actor-testkit-typed", "pekko-actor-typed", "pekko-cluster", "pekko-cluster-metrics", "pekko-cluster-sharding", "pekko-cluster-sharding-typed", "pekko-cluster-tools", "pekko-cluster-typed", "pekko-coordination", "pekko-discovery", "pekko-distributed-data", "pekko-testkit", "pekko-multi-node-testkit", "pekko-osgi", "pekko-persistence", "pekko-persistence-query", "pekko-persistence-shared", "pekko-persistence-testkit", "pekko-persistence-typed", "pekko-pki", "pekko-protobuf", "pekko-protobuf-v3", "pekko-remote", "pekko-serialization-jackson", "pekko-slf4j", "pekko-stream", "pekko-stream-testkit", "pekko-stream-typed", "pekko-stream-testkit"}));
    }

    private boolean _initialized() {
        return this._initialized;
    }

    private void _initialized_$eq(boolean x$1) {
        this._initialized = x$1;
    }

    public void assertInitialized() {
        if (!this._initialized()) {
            throw new IllegalStateException("The calling code expected that the ActorSystem was initialized but it wasn't yet. This is probably a bug in the ActorSystem initialization sequence often related to initialization of extensions. Please report at https://github.com/apache/pekko/issues.");
        }
    }

    private ActorSystemImpl _start$lzycompute() {
        ActorSystemImpl actorSystemImpl = this;
        synchronized (actorSystemImpl) {
            if (!this.bitmap$0) {
                this._start = this.liftedTree2$1();
                this.bitmap$0 = true;
            }
        }
        return this._start;
    }

    private ActorSystemImpl _start() {
        if (!this.bitmap$0) {
            return this._start$lzycompute();
        }
        return this._start;
    }

    public ActorSystemImpl start() {
        return this._start();
    }

    @Override
    public <T> void registerOnTermination(Function0<T> code) {
        this.registerOnTermination(new Runnable(null, code){
            private final Function0 code$1;

            public void run() {
                this.code$1.apply();
            }
            {
                this.code$1 = code$1;
            }
        });
    }

    @Override
    public void registerOnTermination(Runnable code) {
        this.terminationCallbacks.add(code);
    }

    private boolean terminating() {
        return this.terminating;
    }

    private void terminating_$eq(boolean x$1) {
        this.terminating = x$1;
    }

    @Override
    public Future<Terminated> terminate() {
        Future<Done> future;
        this.terminating_$eq(true);
        if (this.settings().CoordinatedShutdownRunByActorSystemTerminate() && !this.aborting()) {
            future = ((CoordinatedShutdown)CoordinatedShutdown$.MODULE$.apply(this)).run(CoordinatedShutdown$ActorSystemTerminateReason$.MODULE$);
        } else {
            this.finalTerminate();
            future = BoxedUnit.UNIT;
        }
        return this.whenTerminated();
    }

    @Override
    public void finalTerminate() {
        this.terminating_$eq(true);
        if (!this.settings().LogDeadLettersDuringShutdown()) {
            this.logDeadLetterListener().foreach((Function1 & Serializable)actor -> {
                this.stop(actor);
                return BoxedUnit.UNIT;
            });
        }
        this.guardian().stop();
    }

    @Override
    public boolean isTerminating() {
        return this.terminating() || this.aborting() || ((CoordinatedShutdown)CoordinatedShutdown$.MODULE$.apply(this)).shutdownReason().isDefined();
    }

    public boolean aborting() {
        return this.aborting;
    }

    public void aborting_$eq(boolean x$1) {
        this.aborting = x$1;
    }

    public void abort() {
        this.aborting_$eq(true);
        this.terminate();
    }

    public Scheduler createScheduler() {
        return (Scheduler)this.dynamicAccess().createInstanceFor(this.settings().SchedulerClass(), (Seq<Tuple2<Class<?>, Object>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Config.class), (Object)this.settings().config()), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(LoggingAdapter.class), (Object)this.log()), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(ThreadFactory.class), (Object)this.threadFactory().withName(new StringBuilder(10).append(this.threadFactory().name()).append("-scheduler").toString())), (List)Nil$.MODULE$))), ClassTag$.MODULE$.apply(Scheduler.class)).get();
    }

    public void stopScheduler() {
        Scheduler scheduler = this.scheduler();
        if (scheduler instanceof Closeable) {
            Scheduler scheduler2 = scheduler;
            ((Closeable)((Object)scheduler2)).close();
            return;
        }
    }

    private ConcurrentHashMap<ExtensionId<?>, Object> extensions() {
        return this.extensions;
    }

    private <T extends Extension> T findExtension(ExtensionId<T> ext) {
        Object object;
        while ((object = this.extensions().get(ext)) instanceof CountDownLatch) {
            CountDownLatch countDownLatch = (CountDownLatch)object;
            package$.MODULE$.blocking((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                long awaitMillis = this.settings().CreationTimeout().duration().toMillis();
                if (!countDownLatch.await(awaitMillis, TimeUnit.MILLISECONDS)) {
                    ExtensionId extensionId = ext;
                    SerializationExtension$ serializationExtension$ = SerializationExtension$.MODULE$;
                    throw new IllegalStateException(new StringBuilder(43).append("Initialization of [").append(ext).append("] took more than [").append(awaitMillis).append(" ms]. ").append((Object)(!(extensionId != null ? !((Object)extensionId).equals(serializationExtension$) : serializationExtension$ != null) ? "A serializer must not access the SerializationExtension from its constructor. Use lazy init." : "Could be deadlock due to cyclic initialization of extensions.")).toString());
                }
            });
        }
        if (object instanceof Throwable) {
            Throwable throwable = (Throwable)object;
            throw throwable;
        }
        return (T)((Extension)object);
    }

    @Override
    public final <T extends Extension> T registerExtension(ExtensionId<T> ext) {
        T t;
        while ((t = this.findExtension(ext)) == null) {
            T t2;
            CountDownLatch inProcessOfRegistration = new CountDownLatch(1);
            Object object = this.extensions().putIfAbsent(ext, inProcessOfRegistration);
            if (object != null) continue;
            try {
                try {
                    T t3 = ext.createExtension(this);
                    if (t3 == null) {
                        throw new IllegalStateException(new StringBuilder(53).append("Extension instance created as 'null' for extension [").append(ext).append("]").toString());
                    }
                    this.extensions().replace(ext, inProcessOfRegistration, t3);
                    t2 = t3;
                }
                catch (Throwable t4) {
                    this.extensions().replace(ext, inProcessOfRegistration, t4);
                    throw t4;
                }
            }
            finally {
                inProcessOfRegistration.countDown();
            }
            return t2;
        }
        return t;
    }

    @Override
    public <T extends Extension> T extension(ExtensionId<T> ext) {
        T t = this.findExtension(ext);
        if (t == null) {
            throw new IllegalArgumentException(new StringBuilder(41).append("Trying to get non-registered extension [").append(ext).append("]").toString());
        }
        return t;
    }

    @Override
    public boolean hasExtension(ExtensionId<? extends Extension> ext) {
        return this.findExtension(ext) != null;
    }

    private void loadExtensions() {
        this.loadExtensions$1("pekko.library-extensions", true);
        this.loadExtensions$1("pekko.extensions", false);
    }

    public String toString() {
        return this.lookupRoot().path().root().address().toString();
    }

    @Override
    public String printTree() {
        return ActorSystemImpl.printNode$1(this.lookupRoot(), "");
    }

    private final /* synthetic */ ActorRefProvider liftedTree1$1() {
        ActorRefProvider actorRefProvider;
        try {
            Vector arguments = (Vector)scala.package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(String.class), (Object)this.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(ActorSystem.Settings.class), (Object)this.settings()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(EventStream.class), (Object)this.eventStream()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(DynamicAccess.class), (Object)this.dynamicAccess())}));
            actorRefProvider = (ActorRefProvider)this.dynamicAccess().createInstanceFor(this.settings().ProviderClass(), (Seq<Tuple2<Class<?>, Object>>)arguments, ClassTag$.MODULE$.apply(ActorRefProvider.class)).get();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (NonFatal$.MODULE$.apply(throwable2)) {
                Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.stopScheduler());
                throw throwable2;
            }
            throw throwable;
        }
        return actorRefProvider;
    }

    private final /* synthetic */ ActorSystemImpl liftedTree2$1() {
        ActorSystemImpl actorSystemImpl;
        try {
            this.registerOnTermination((Function0)(JFunction0.mcV.sp & Serializable)() -> this.stopScheduler());
            this.provider().init(this);
            this._initialized_$eq(true);
            if (this.settings().LogDeadLetters() > 0) {
                this.logDeadLetterListener_$eq((Option<ActorRef>)new Some((Object)this.systemActorOf(Props$.MODULE$.apply(ClassTag$.MODULE$.apply(DeadLetterListener.class)), "deadLetterListener")));
            }
            this.eventStream().startUnsubscriber();
            ((ManifestInfo)ManifestInfo$.MODULE$.apply(this)).checkSameVersion("Apache Pekko", (Seq<String>)this.allModules(), true);
            if (!this.terminating()) {
                this.loadExtensions();
            }
            if (this.settings().LogConfigOnStart()) {
                this.logConfiguration();
            }
            actorSystemImpl = this;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (NonFatal$.MODULE$.apply(throwable2)) {
                block9: {
                    Try try_;
                    try {
                        try_ = this.terminate();
                    }
                    catch (Throwable throwable3) {
                        Option option;
                        Throwable throwable4 = throwable3;
                        if (throwable4 != null && !(option = NonFatal$.MODULE$.unapply(throwable4)).isEmpty()) {
                            try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.stopScheduler());
                            break block9;
                        }
                        throw throwable3;
                    }
                }
                throw throwable2;
            }
            throw throwable;
        }
        return actorSystemImpl;
    }

    private final void loadExtensions$1(String key, boolean throwOnLoadFail) {
        Util$.MODULE$.immutableSeq(this.settings().config().getStringList(key)).foreach((Function1 & Serializable)fqcn -> {
            Object p;
            boolean bl = false;
            Success success = null;
            Try try_ = this.dynamicAccess().getObjectFor((String)fqcn, ClassTag$.MODULE$.AnyRef()).recoverWith((PartialFunction)new Serializable(this, (String)fqcn){
                private static final long serialVersionUID = 0L;
                private final /* synthetic */ ActorSystemImpl $outer;
                private final String fqcn$1;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    return (B1)this.$outer.dynamicAccess().createInstanceFor(this.fqcn$1, (Seq<Tuple2<Class<?>, Object>>)Nil$.MODULE$, ClassTag$.MODULE$.AnyRef()).recoverWith((PartialFunction)new Serializable(null, A1){
                        private static final long serialVersionUID = 0L;
                        private final Throwable x1$1;

                        public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            A1 A1 = x1;
                            return (B1)new Failure(this.x1$1);
                        }

                        public final boolean isDefinedAt(Throwable x1) {
                            Throwable throwable = x1;
                            return true;
                        }
                        {
                            this.x1$1 = x1$1;
                        }
                    });
                }

                public final boolean isDefinedAt(Throwable x1) {
                    Throwable throwable = x1;
                    return true;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.fqcn$1 = fqcn$1;
                }
            });
            if (try_ instanceof Success) {
                bl = true;
                success = (Success)try_;
                Object p2 = success.value();
                if (p2 instanceof ExtensionIdProvider) {
                    ExtensionIdProvider extensionIdProvider = (ExtensionIdProvider)p2;
                    return this.registerExtension(extensionIdProvider.lookup());
                }
            }
            if (bl && (p = success.value()) instanceof ExtensionId) {
                ExtensionId extensionId = (ExtensionId)p;
                return this.registerExtension(extensionId);
            }
            if (bl) {
                if (!throwOnLoadFail) {
                    this.log().error("[{}] is not an 'ExtensionIdProvider' or 'ExtensionId', skipping...", fqcn);
                    return BoxedUnit.UNIT;
                }
                throw new RuntimeException(new StringBuilder(51).append("[").append((String)fqcn).append("] is not an 'ExtensionIdProvider' or 'ExtensionId'").toString());
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable problem = failure.exception();
                if (!throwOnLoadFail) {
                    this.log().error(problem, "While trying to load extension [{}], skipping...", fqcn);
                    return BoxedUnit.UNIT;
                }
                throw new RuntimeException(new StringBuilder(33).append("While trying to load extension [").append((String)fqcn).append("]").toString(), problem);
            }
            throw new MatchError((Object)try_);
        });
    }

    private static final String printNode$1(ActorRef node, String indent) {
        ActorRef actorRef = node;
        if (actorRef instanceof ActorRefWithCell) {
            String string;
            String string2;
            ActorCell actorCell;
            Actor realActor;
            Cell cell;
            ActorRefWithCell actorRefWithCell = (ActorRefWithCell)actorRef;
            Cell cell2 = actorRefWithCell.underlying();
            StringBuilder stringBuilder = new StringBuilder(3).append(indent.isEmpty() ? "-> " : new StringBuilder(4).append(StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(indent), 1)).append("\u230a-> ").toString()).append(node.path().name()).append(" ").append(Logging$.MODULE$.simpleName(node)).append(" ").append((cell = cell2) instanceof ActorCell ? ((realActor = (actorCell = (ActorCell)cell).actor()) != null ? realActor.getClass() : "null") : Logging$.MODULE$.simpleName(cell2));
            Cell cell3 = cell2;
            if (cell3 instanceof ActorCell) {
                ActorCell actorCell2 = (ActorCell)cell3;
                string2 = new StringBuilder(8).append(" status=").append(actorCell2.mailbox().currentStatus()).toString();
            } else {
                string2 = "";
            }
            StringBuilder stringBuilder2 = stringBuilder.append((Object)string2).append(" ");
            ChildrenContainer childrenContainer = cell2.childrenRefs();
            if (childrenContainer instanceof ChildrenContainer.TerminatingChildrenContainer) {
                ChildrenContainer.TerminatingChildrenContainer terminatingChildrenContainer = (ChildrenContainer.TerminatingChildrenContainer)childrenContainer;
                Set<ActorRef> toDie = terminatingChildrenContainer.toDie();
                ChildrenContainer.SuspendReason reason = terminatingChildrenContainer.reason();
                string = new StringBuilder(13).append("Terminating(").append(reason).append(")").append(((IterableOnceOps)toDie.toSeq().sorted(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).mkString(new StringBuilder(16).append("\n").append(indent).append("   |    toDie: ").toString(), new StringBuilder(16).append("\n").append(indent).append("   |           ").toString(), "")).toString();
            } else if (ChildrenContainer$TerminatedChildrenContainer$.MODULE$.equals(childrenContainer) ? true : ChildrenContainer$EmptyChildrenContainer$.MODULE$.equals(childrenContainer)) {
                string = childrenContainer.toString();
            } else if (childrenContainer instanceof ChildrenContainer.NormalChildrenContainer) {
                ChildrenContainer.NormalChildrenContainer normalChildrenContainer = (ChildrenContainer.NormalChildrenContainer)childrenContainer;
                string = new StringBuilder(9).append(Integer.toString(normalChildrenContainer.c().size())).append(" children").toString();
            } else {
                string = Logging$.MODULE$.simpleName(childrenContainer);
            }
            Seq children = (Seq)cell2.childrenRefs().children().toSeq().sorted(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
            Seq bulk = (Seq)((IterableOps)children.dropRight(1)).map((Function1 & Serializable)x$7 -> ActorSystemImpl.printNode$1(x$7, new StringBuilder(4).append(indent).append("   |").toString()));
            return stringBuilder2.append((Object)string).append((Object)(cell2.childrenRefs().children().isEmpty() ? "" : "\n")).append(((IterableOnceOps)bulk.$plus$plus((IterableOnce)children.lastOption().map((Function1 & Serializable)x$8 -> ActorSystemImpl.printNode$1(x$8, new StringBuilder(4).append(indent).append("    ").toString())))).mkString("\n")).toString();
        }
        return new StringBuilder(1).append(indent).append(node.path().name()).append(" ").append(Logging$.MODULE$.simpleName(node)).toString();
    }

    public ActorSystemImpl(String name, Config applicationConfig, ClassLoader classLoader, Option<ExecutionContext> defaultExecutionContext, Option<Props> guardianProps, ActorSystemSetup setup) {
        this.name = name;
        this.classLoader = classLoader;
        this.guardianProps = guardianProps;
        this.uid = ThreadLocalRandom.current().nextLong();
        if (!name.matches("^[a-zA-Z0-9][a-zA-Z0-9-_]*$")) {
            throw new IllegalArgumentException(new StringBuilder(109).append("invalid ActorSystem name [").append(name).append("], must contain only word characters (i.e. [a-zA-Z0-9] plus non-leading '-' or '_')").toString());
        }
        this.logDeadLetterListener = None$.MODULE$;
        this._dynamicAccess = this.createDynamicAccess();
        Config config = ActorSystem$Settings$.MODULE$.amendSlf4jConfig(applicationConfig.withFallback((ConfigMergeable)ConfigFactory.defaultReference((ClassLoader)classLoader)), this._dynamicAccess());
        this.settings = new ActorSystem.Settings(classLoader, config, name, setup);
        this.threadFactory = new MonitorableThreadFactory(name, this.settings().Daemonicity(), (Option<ClassLoader>)Option$.MODULE$.apply((Object)classLoader), this.uncaughtExceptionHandler(), MonitorableThreadFactory$.MODULE$.apply$default$5());
        this.eventStream = new EventStream(this, this.settings().DebugEventStream());
        this.eventStream().startStdoutLogger(this.settings());
        Vector arguments = (Vector)scala.package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(ActorSystem.Settings.class), (Object)this.settings()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(EventStream.class), (Object)this.eventStream())}));
        this.logFilter = (LoggingFilter)this.dynamicAccess().createInstanceFor(this.settings().LoggingFilter(), (Seq<Tuple2<Class<?>, Object>>)arguments, ClassTag$.MODULE$.apply(LoggingFilter.class)).get();
        this.org$apache$pekko$actor$ActorSystemImpl$$markerLogging = new MarkerLoggingAdapter(this.eventStream(), new StringBuilder(2).append(this.getClass().getName()).append("(").append(name).append(")").toString(), this.getClass(), this.logFilter());
        this.log = this.org$apache$pekko$actor$ActorSystemImpl$$markerLogging;
        this.scheduler = this.createScheduler();
        this.provider = this.liftedTree1$1();
        this.mailboxes = new Mailboxes(this.settings(), this.eventStream(), this.dynamicAccess(), this.deadLetters());
        this.dispatchers = new Dispatchers(this.settings(), new DefaultDispatcherPrerequisites(this.threadFactory(), this.eventStream(), this.scheduler(), this.dynamicAccess(), this.settings(), this.mailboxes(), defaultExecutionContext), this.log());
        this.dispatcher = this.dispatchers().defaultGlobalDispatcher();
        this.terminationCallbacks = new TerminationCallbacks<Terminated>(this, this.provider().terminationFuture(), (ExecutionContext)this.dispatcher());
        this._initialized = false;
        this.terminating = false;
        this.aborting = false;
        this.extensions = new ConcurrentHashMap();
    }

    public final class TerminationCallbacks<T> {
        private final ExecutionContext ec;
        private final Promise<T> done;
        private final AtomicReference<Promise<T>> ref;

        public final void add(Runnable r) {
            this.addRec$1(r, Promise$.MODULE$.apply());
        }

        public Future<T> terminationFuture() {
            return this.done.future();
        }

        private final void addRec$1(Runnable r, Promise p) {
            Promise<T> promise;
            while (true) {
                if ((promise = this.ref.get()) == null) {
                    throw new RejectedExecutionException("ActorSystem already terminated.");
                }
                if (this.ref.compareAndSet(promise, p)) break;
            }
            promise.completeWith(p.future().andThen((PartialFunction)new Serializable(null, r){
                private static final long serialVersionUID = 0L;
                private final Runnable r$1;

                public final <A1 extends Try<T>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    this.r$1.run();
                    return (B1)BoxedUnit.UNIT;
                }

                public final boolean isDefinedAt(Try<T> x1) {
                    Try<T> try_ = x1;
                    return true;
                }
                {
                    this.r$1 = r$1;
                }
            }, this.ec));
        }

        public TerminationCallbacks(ActorSystemImpl $outer, Future<T> upStreamTerminated, ExecutionContext ec) {
            this.ec = ec;
            this.done = Promise$.MODULE$.apply();
            this.ref = new AtomicReference<Promise<T>>(this.done);
            upStreamTerminated.onComplete((Function1 & Serializable)t -> ((Promise)$this.ref.getAndSet(null)).complete(t), ec);
        }
    }
}

