/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.util.Properties;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.PlaceholderParser;

public class PropertyPlaceholderHelper {
    private final PlaceholderParser parser;

    public PropertyPlaceholderHelper(String placeholderPrefix, String placeholderSuffix) {
        this(placeholderPrefix, placeholderSuffix, null, null, true);
    }

    @Deprecated(since="6.2", forRemoval=true)
    public PropertyPlaceholderHelper(String placeholderPrefix, String placeholderSuffix, @Nullable String valueSeparator, boolean ignoreUnresolvablePlaceholders) {
        this(placeholderPrefix, placeholderSuffix, valueSeparator, null, ignoreUnresolvablePlaceholders);
    }

    public PropertyPlaceholderHelper(String placeholderPrefix, String placeholderSuffix, @Nullable String valueSeparator, @Nullable Character escapeCharacter, boolean ignoreUnresolvablePlaceholders) {
        Assert.notNull((Object)placeholderPrefix, "'placeholderPrefix' must not be null");
        Assert.notNull((Object)placeholderSuffix, "'placeholderSuffix' must not be null");
        this.parser = new PlaceholderParser(placeholderPrefix, placeholderSuffix, valueSeparator, escapeCharacter, ignoreUnresolvablePlaceholders);
    }

    public String replacePlaceholders(String value, Properties properties) {
        Assert.notNull((Object)properties, "'properties' must not be null");
        return this.replacePlaceholders(value, properties::getProperty);
    }

    public String replacePlaceholders(String value, PlaceholderResolver placeholderResolver) {
        Assert.notNull((Object)value, "'value' must not be null");
        return this.parseStringValue(value, placeholderResolver);
    }

    protected String parseStringValue(String value, PlaceholderResolver placeholderResolver) {
        return this.parser.replacePlaceholders(value, placeholderResolver);
    }

    @FunctionalInterface
    public static interface PlaceholderResolver {
        @Nullable
        public String resolvePlaceholder(String var1);
    }
}

