/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.help;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.cli.CliObject;
import com.xebialabs.deployit.cli.help.ClassHelp;
import com.xebialabs.deployit.cli.help.MethodHelp;
import com.xebialabs.deployit.cli.help.ParameterHelp;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;

public class HelpScanner {
    private static final AtomicReference<Set<Class<?>>> discoveredCliObjects = new AtomicReference();

    private HelpScanner() {
    }

    public static void init(Set<Class<?>> clazzes) {
        discoveredCliObjects.set(clazzes);
    }

    public static List<String> loadCliObjectCompletions() {
        ArrayList<String> completions = new ArrayList<String>();
        Set<Class<?>> availableCliObjects = HelpScanner.loadAvailableCliObjects();
        for (Class<?> clazz : availableCliObjects) {
            CliObject cliObject = clazz.getAnnotation(CliObject.class);
            completions.add(cliObject.name());
        }
        return completions;
    }

    private static Set<Class<?>> loadAvailableCliObjects() {
        TreeSet availableCliObjects = Sets.newTreeSet(Comparator.comparing(Class::getSimpleName));
        if (discoveredCliObjects.get() != null) {
            availableCliObjects.addAll((Collection)discoveredCliObjects.get());
        }
        return availableCliObjects;
    }

    public static List<String> loadObjectMethodCompletions(String objectName) {
        ArrayList<String> completions = new ArrayList<String>();
        Set<Class<?>> availableCliObjects = HelpScanner.loadAvailableCliObjects();
        for (Class<?> cliClazz : availableCliObjects) {
            CliObject cliObject = cliClazz.getAnnotation(CliObject.class);
            if (!objectName.equals(cliObject.name())) continue;
            List<String> completionsForObject = HelpScanner.loadObjectMethodCompletionsForObject(cliObject, cliClazz);
            completions.addAll(completionsForObject);
        }
        return completions;
    }

    private static List<String> loadObjectMethodCompletionsForObject(CliObject cliObject, Class<?> cliClazz) {
        ArrayList<String> completions = new ArrayList<String>();
        String objectName = cliObject.name();
        ArrayList availableMethods = Lists.newArrayList((Object[])cliClazz.getDeclaredMethods());
        for (Method method : availableMethods) {
            String suggestion;
            String help = HelpScanner.loadMethodSignatureHelp(objectName, method);
            if (help == null || completions.contains(suggestion = cliObject.name() + "." + method.getName())) continue;
            completions.add(suggestion);
        }
        return completions;
    }

    public static List<String> loadMethodSignatureSuggestions(String objectName, String methodName) {
        ArrayList<String> helpSuggestions = new ArrayList<String>();
        Set<Class<?>> availableCliObjects = HelpScanner.loadAvailableCliObjects();
        for (Class<?> cliClazz : availableCliObjects) {
            CliObject cliObject = cliClazz.getAnnotation(CliObject.class);
            if (!objectName.equals(cliObject.name())) continue;
            List<String> suggestionsForObject = HelpScanner.loadMethodSignatureSuggestionsForObject(objectName, cliClazz, methodName);
            helpSuggestions.addAll(suggestionsForObject);
            break;
        }
        return helpSuggestions;
    }

    private static List<String> loadMethodSignatureSuggestionsForObject(String objectName, Class<?> cliClazz, String methodName) {
        ArrayList<String> helpSuggestions = new ArrayList<String>();
        ArrayList availableMethods = Lists.newArrayList((Object[])cliClazz.getDeclaredMethods());
        for (Method method : availableMethods) {
            String help;
            if (!methodName.equals(method.getName()) || (help = HelpScanner.loadMethodSignatureHelp(objectName, method)) == null) continue;
            helpSuggestions.add(help);
        }
        return helpSuggestions;
    }

    public static void printHelp() {
        Set<Class<?>> availableCliObjects = HelpScanner.loadAvailableCliObjects();
        System.out.println("XL Deploy Objects available on the CLI:\n");
        for (Class<?> clazz : availableCliObjects) {
            ClassHelp classHelp = clazz.getAnnotation(ClassHelp.class);
            CliObject cliObject = clazz.getAnnotation(CliObject.class);
            if (classHelp == null) continue;
            System.out.printf("* %s: %s\n", cliObject.name(), classHelp.description());
        }
        System.out.println("\nTo know more about a specific object, type <objectname>.help()");
        System.out.println("To get to know more about a specific method of an object, type <objectname>.help(\"<methodname>\")\n");
    }

    public static void printHelp(Class<?> clazz) {
        ClassHelp classHelp = clazz.getAnnotation(ClassHelp.class);
        CliObject cliObject = clazz.getAnnotation(CliObject.class);
        if (classHelp != null) {
            String objectName = cliObject.name();
            System.out.printf("%s: %s\n\n", objectName, classHelp.description());
            HelpScanner.printMethods(objectName, clazz);
            System.out.println();
        } else {
            System.out.println("Not found help for " + clazz);
        }
    }

    public static void printHelp(Class<?> clazz, String methodName) {
        ClassHelp classHelp = clazz.getAnnotation(ClassHelp.class);
        CliObject cliObject = clazz.getAnnotation(CliObject.class);
        if (classHelp != null) {
            String objectName = cliObject.name();
            for (Method method : clazz.getMethods()) {
                if (!method.getName().equals(methodName)) continue;
                HelpScanner.printMethod(objectName, method);
                HelpScanner.printMethodDetails(method);
                System.out.println();
            }
        }
    }

    private static void printMethodDetails(Method method) {
        MethodHelp methodHelp = method.getAnnotation(MethodHelp.class);
        if (methodHelp == null) {
            return;
        }
        System.out.println();
        if (!Strings.isNullOrEmpty((String)methodHelp.deprecated())) {
            System.out.printf("DEPRECATED - %s\n\n", methodHelp.deprecated());
        }
        System.out.printf("Description:\n%s\n\n", methodHelp.description());
        System.out.print("Parameters:\n");
        if (methodHelp.parameters().length != 0) {
            for (ParameterHelp parameterHelp : methodHelp.parameters()) {
                System.out.printf("  %s: %s\n", parameterHelp.name(), parameterHelp.description());
            }
        } else {
            System.out.print("None\n");
        }
        System.out.println();
        System.out.printf("Returns:\n%s - %s\n", method.getReturnType().getSimpleName(), methodHelp.returns());
    }

    private static void printMethods(String objectName, Class<?> clazz) {
        ArrayList availableMethods = Lists.newArrayList((Object[])clazz.getDeclaredMethods());
        availableMethods.sort((method, methodComparedTo) -> {
            if (method.getName().equals(methodComparedTo.getName())) {
                return 0;
            }
            return method.getName().compareTo(methodComparedTo.getName());
        });
        System.out.println("The methods available are:");
        for (Method method2 : availableMethods) {
            HelpScanner.printMethod(objectName, method2);
        }
    }

    private static void printMethod(String objectName, Method method) {
        String help = HelpScanner.loadMethodSignatureHelp(objectName, method);
        if (help != null) {
            System.out.printf("* %s", help);
        }
    }

    private static String loadMethodSignatureHelp(String objectName, Method method) {
        ParameterHelp[] parameterHelps;
        MethodHelp methodHelp = method.getAnnotation(MethodHelp.class);
        if (methodHelp == null) {
            return null;
        }
        String methodName = method.getName();
        StringBuilder params = new StringBuilder();
        Class<?>[] classes = method.getParameterTypes();
        if (classes.length != (parameterHelps = methodHelp.parameters()).length) {
            throw new IllegalArgumentException("Not all parameters are documented!");
        }
        for (int i = 0; i < classes.length; ++i) {
            params.append(classes[i].getSimpleName());
            params.append(" ").append(parameterHelps[i].name());
            if (i >= classes.length - 1) continue;
            params.append(", ");
        }
        String deprecationWarning = "";
        if (!Strings.isNullOrEmpty((String)methodHelp.deprecated())) {
            deprecationWarning = "- DEPRECATED";
        }
        return String.format("%s.%s(%s) : %s %s%n", objectName, methodName, params, method.getReturnType().getSimpleName(), deprecationWarning);
    }
}

