/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ldap.userdetails;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.naming.directory.SearchControls;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.log.LogMessage;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.ldap.SpringSecurityLdapTemplate;
import org.springframework.security.ldap.userdetails.LdapAuthoritiesPopulator;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class DefaultLdapAuthoritiesPopulator
implements LdapAuthoritiesPopulator {
    private static final Log logger = LogFactory.getLog(DefaultLdapAuthoritiesPopulator.class);
    private GrantedAuthority defaultRole;
    private final SpringSecurityLdapTemplate ldapTemplate;
    private final SearchControls searchControls = new SearchControls();
    private String groupRoleAttribute = "cn";
    private String groupSearchBase;
    private String groupSearchFilter = "(member={0})";
    private String rolePrefix = "ROLE_";
    private boolean convertToUpperCase = true;
    private Function<Map<String, List<String>>, GrantedAuthority> authorityMapper;

    public DefaultLdapAuthoritiesPopulator(ContextSource contextSource, String groupSearchBase) {
        Assert.notNull((Object)contextSource, (String)"contextSource must not be null");
        this.ldapTemplate = new SpringSecurityLdapTemplate(contextSource);
        this.getLdapTemplate().setSearchControls(this.getSearchControls());
        this.groupSearchBase = groupSearchBase;
        if (groupSearchBase == null) {
            logger.info((Object)"Will not perform group search since groupSearchBase is null.");
        } else if (groupSearchBase.length() == 0) {
            logger.info((Object)"Will perform group search from the context source base since groupSearchBase is empty.");
        }
        this.authorityMapper = record -> {
            List roles = (List)record.get(this.groupRoleAttribute);
            if (CollectionUtils.isEmpty((Collection)roles)) {
                return null;
            }
            String role = (String)roles.get(0);
            if (role == null) {
                return null;
            }
            if (this.convertToUpperCase) {
                role = role.toUpperCase(Locale.ROOT);
            }
            return new SimpleGrantedAuthority(this.rolePrefix + role);
        };
    }

    protected Set<GrantedAuthority> getAdditionalRoles(DirContextOperations user, String username) {
        return null;
    }

    public final Collection<GrantedAuthority> getGrantedAuthorities(DirContextOperations user, String username) {
        String userDn = user.getNameInNamespace();
        Set<GrantedAuthority> roles = this.getGroupMembershipRoles(userDn, username);
        Set<GrantedAuthority> extraRoles = this.getAdditionalRoles(user, username);
        if (extraRoles != null) {
            roles.addAll(extraRoles);
        }
        if (this.defaultRole != null) {
            roles.add(this.defaultRole);
        }
        ArrayList<GrantedAuthority> result = new ArrayList<GrantedAuthority>(roles.size());
        result.addAll(roles);
        logger.debug((Object)LogMessage.format((String)"Retrieved authorities for user %s", (Object)userDn));
        return result;
    }

    public Set<GrantedAuthority> getGroupMembershipRoles(String userDn, String username) {
        if (this.getGroupSearchBase() == null) {
            return new HashSet<GrantedAuthority>();
        }
        HashSet<GrantedAuthority> authorities = new HashSet<GrantedAuthority>();
        logger.trace((Object)LogMessage.of(() -> "Searching for roles for user " + username + " with DN " + userDn + " and filter " + this.groupSearchFilter + " in search base " + this.getGroupSearchBase()));
        Set<Map<String, List<String>>> userRoles = this.getLdapTemplate().searchForMultipleAttributeValues(this.getGroupSearchBase(), this.groupSearchFilter, new String[]{userDn, username}, new String[]{this.groupRoleAttribute});
        logger.debug((Object)LogMessage.of(() -> "Found roles from search " + userRoles));
        for (Map<String, List<String>> role : userRoles) {
            GrantedAuthority authority = this.authorityMapper.apply(role);
            if (authority == null) continue;
            authorities.add(authority);
        }
        return authorities;
    }

    protected ContextSource getContextSource() {
        return this.getLdapTemplate().getContextSource();
    }

    protected String getGroupSearchBase() {
        return this.groupSearchBase;
    }

    public void setConvertToUpperCase(boolean convertToUpperCase) {
        this.convertToUpperCase = convertToUpperCase;
    }

    public void setDefaultRole(String defaultRole) {
        Assert.notNull((Object)defaultRole, (String)"The defaultRole property cannot be set to null");
        this.defaultRole = new SimpleGrantedAuthority(defaultRole);
    }

    public void setGroupRoleAttribute(String groupRoleAttribute) {
        Assert.notNull((Object)groupRoleAttribute, (String)"groupRoleAttribute must not be null");
        this.groupRoleAttribute = groupRoleAttribute;
    }

    public void setGroupSearchFilter(String groupSearchFilter) {
        Assert.notNull((Object)groupSearchFilter, (String)"groupSearchFilter must not be null");
        this.groupSearchFilter = groupSearchFilter;
    }

    public void setRolePrefix(String rolePrefix) {
        Assert.notNull((Object)rolePrefix, (String)"rolePrefix must not be null");
        this.rolePrefix = rolePrefix;
    }

    public void setSearchSubtree(boolean searchSubtree) {
        int searchScope = searchSubtree ? 2 : 1;
        this.searchControls.setSearchScope(searchScope);
    }

    public void setIgnorePartialResultException(boolean ignore) {
        this.getLdapTemplate().setIgnorePartialResultException(ignore);
    }

    public void setAuthorityMapper(Function<Map<String, List<String>>, GrantedAuthority> authorityMapper) {
        Assert.notNull(authorityMapper, (String)"authorityMapper must not be null");
        this.authorityMapper = authorityMapper;
    }

    protected SpringSecurityLdapTemplate getLdapTemplate() {
        return this.ldapTemplate;
    }

    protected final String getGroupRoleAttribute() {
        return this.groupRoleAttribute;
    }

    protected final String getGroupSearchFilter() {
        return this.groupSearchFilter;
    }

    protected final String getRolePrefix() {
        return this.rolePrefix;
    }

    protected final boolean isConvertToUpperCase() {
        return this.convertToUpperCase;
    }

    private GrantedAuthority getDefaultRole() {
        return this.defaultRole;
    }

    private SearchControls getSearchControls() {
        return this.searchControls;
    }
}

