/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.event;

import com.xebialabs.deployit.engine.spi.event.AuditableDeployitEvent;
import com.xebialabs.deployit.engine.spi.event.DeployitEventListener;
import com.xebialabs.deployit.engine.spi.event.SpringInstantiatedListener;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import nl.javadude.scannit.Scannit;
import nl.javadude.t2bus.EventHandlerStrategy;
import nl.javadude.t2bus.T2Bus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component
public class EventBusHolder {
    private static final AtomicReference<T2Bus> EVENT_BUS = new AtomicReference<T2Bus>(new T2Bus());
    @Autowired(required=false)
    List<SpringInstantiatedListener> springlisteners = new ArrayList<SpringInstantiatedListener>();
    private static final Logger logger = LoggerFactory.getLogger(EventBusHolder.class);

    @PostConstruct
    public void registerListeners() throws InstantiationException, IllegalAccessException {
        logger.info("Finding all Listeners...");
        for (Class clazz : Scannit.getInstance().getTypesAnnotatedWith(DeployitEventListener.class)) {
            logger.info("Registering Listener: {}", (Object)clazz);
            EventBusHolder.register(clazz.newInstance());
        }
        for (SpringInstantiatedListener listener : this.springlisteners) {
            logger.info("Registering spring-instantiated object: {}", (Object)listener);
            EventBusHolder.register(listener);
        }
    }

    public static void register(Object listener) {
        EVENT_BUS.get().register(listener);
    }

    public static void deregister(Object listener) {
        EVENT_BUS.get().unregister(listener);
    }

    public static void publish(Object event) {
        EventBusHolder.fillUsername(event);
        EVENT_BUS.get().post(event);
    }

    public static void publish(Object event, EventHandlerStrategy strategy) {
        EventBusHolder.fillUsername(event);
        EVENT_BUS.get().post(event, strategy);
    }

    private static void fillUsername(Object event) {
        if (event instanceof AuditableDeployitEvent && !EventBusHolder.isUserNameAlreadyFilled((AuditableDeployitEvent)event)) {
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            String userName = authentication != null ? authentication.getName() : null;
            ((AuditableDeployitEvent)event).username = userName != null ? userName : "system";
        }
    }

    private static boolean isUserNameAlreadyFilled(AuditableDeployitEvent event) {
        return event.username != null && event.username != "unknown";
    }
}

