/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.parsing;

import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.http.impl.engine.parsing.NotEnoughDataException$;
import org.apache.pekko.http.scaladsl.model.ErrorInfo;
import org.apache.pekko.http.scaladsl.settings.ParserSettings;
import org.apache.pekko.http.scaladsl.settings.ParserSettings$ErrorLoggingVerbosity$Full$;
import org.apache.pekko.http.scaladsl.settings.ParserSettings$ErrorLoggingVerbosity$Off$;
import org.apache.pekko.http.scaladsl.settings.ParserSettings$ErrorLoggingVerbosity$Simple$;
import org.apache.pekko.util.ByteString;
import scala.MatchError;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class package$ {
    public static final package$ MODULE$ = new package$();

    public String escape(char c) {
        switch (c) {
            case '\t': {
                return "\\t";
            }
            case '\r': {
                return "\\r";
            }
            case '\n': {
                return "\\n";
            }
        }
        if (Character.isISOControl(c)) {
            return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\\u%04x"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)c)}));
        }
        return Character.toString(c);
    }

    public char byteChar(ByteString input, int ix) {
        return (char)(this.byteAt(input, ix) & 0xFF);
    }

    public byte byteAt(ByteString input, int ix) {
        if (ix < input.length()) {
            return input.apply(ix);
        }
        throw NotEnoughDataException$.MODULE$;
    }

    public String asciiString(ByteString input, int start, int end) {
        if (start == end) {
            return "";
        }
        return this.build$1(start, new StringBuilder(end - start), end, input);
    }

    public void logParsingError(ErrorInfo info, LoggingAdapter log, ParserSettings.ErrorLoggingVerbosity settings, Set<String> ignoreHeaderNames) {
        if (ParserSettings$ErrorLoggingVerbosity$Off$.MODULE$.equals(settings)) {
            return;
        }
        if (ParserSettings$ErrorLoggingVerbosity$Simple$.MODULE$.equals(settings)) {
            if (!ignoreHeaderNames.contains((Object)info.errorHeaderName())) {
                log.warning(info.summary());
                return;
            }
            return;
        }
        if (ParserSettings$ErrorLoggingVerbosity$Full$.MODULE$.equals(settings)) {
            if (!ignoreHeaderNames.contains((Object)info.errorHeaderName())) {
                log.warning(info.formatPretty());
                return;
            }
            return;
        }
        throw new MatchError((Object)settings);
    }

    public Set<String> logParsingError$default$4() {
        return Predef$.MODULE$.Set().empty();
    }

    private final String build$1(int ix, StringBuilder sb, int end$1, ByteString input$1) {
        while (ix != end$1) {
            sb = sb.append((char)input$1.apply(ix));
            ++ix;
        }
        return sb.toString();
    }

    private static final int build$default$1$1(int start$1) {
        return start$1;
    }

    private static final StringBuilder build$default$2$1(int end$1, int start$1) {
        return new StringBuilder(end$1 - start$1);
    }

    private package$() {
    }
}

