/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.multipart;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.MimeIOException;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.dom.Entity;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.field.DefaultFieldParser;
import org.apache.james.mime4j.field.LenientFieldParser;
import org.apache.james.mime4j.message.BodyFactory;
import org.apache.james.mime4j.message.DefaultBodyDescriptorBuilder;
import org.apache.james.mime4j.message.MessageImpl;
import org.apache.james.mime4j.parser.ContentHandler;
import org.apache.james.mime4j.parser.MimeStreamParser;
import org.apache.james.mime4j.storage.AbstractStorageProvider;
import org.apache.james.mime4j.storage.DefaultStorageProvider;
import org.apache.james.mime4j.storage.Storage;
import org.apache.james.mime4j.storage.StorageBodyFactory;
import org.apache.james.mime4j.storage.StorageOutputStream;
import org.apache.james.mime4j.storage.StorageProvider;
import org.apache.james.mime4j.storage.ThresholdStorageProvider;
import org.apache.james.mime4j.stream.BodyDescriptorBuilder;
import org.apache.james.mime4j.stream.MimeConfig;
import org.jboss.resteasy.plugins.providers.multipart.Mime4jWorkaroundBinaryEntityBuilder;
import org.jboss.resteasy.plugins.providers.multipart.i18n.LogMessages;
import org.jboss.resteasy.spi.config.ConfigurationFactory;
import org.jboss.resteasy.spi.config.Options;

public class Mime4JWorkaround {
    static final String MEM_THRESHOLD_PROPERTY = "org.jboss.resteasy.plugins.providers.multipart.memoryThreshold";
    static final int DEFAULT_MEM_THRESHOLD = 1024;

    public static Message parseMessage(InputStream is) throws IOException, MimeIOException {
        try {
            StorageProvider storageProvider;
            MessageImpl message = new MessageImpl();
            MimeConfig cfg = MimeConfig.DEFAULT;
            boolean strict = cfg.isStrictParsing();
            DecodeMonitor mon = strict ? DecodeMonitor.STRICT : DecodeMonitor.SILENT;
            DefaultBodyDescriptorBuilder bdb = new DefaultBodyDescriptorBuilder(null, strict ? DefaultFieldParser.getParser() : LenientFieldParser.getParser(), mon);
            Optional<String> value = Mime4JWorkaround.getProperty("org.apache.james.mime4j.defaultStorageProvider", String.class);
            if (value.isPresent()) {
                storageProvider = DefaultStorageProvider.getInstance();
            } else {
                CustomTempFileStorageProvider backend = new CustomTempFileStorageProvider();
                storageProvider = new ThresholdStorageProvider((StorageProvider)backend, Mime4JWorkaround.getMemThreshold());
            }
            StorageBodyFactory bf = new StorageBodyFactory(storageProvider, mon);
            MimeStreamParser parser = new MimeStreamParser(cfg, mon, (BodyDescriptorBuilder)bdb);
            parser.setContentHandler((ContentHandler)new Mime4jWorkaroundBinaryEntityBuilder((Entity)message, (BodyFactory)bf));
            parser.setContentDecoding(false);
            parser.setRecurse();
            parser.parse(is);
            return message;
        }
        catch (MimeException e) {
            throw new MimeIOException(e);
        }
    }

    static int getMemThreshold() {
        try {
            int threshold = Mime4JWorkaround.getProperty(MEM_THRESHOLD_PROPERTY, Integer.TYPE).orElse(1024);
            if (threshold > -1) {
                return threshold;
            }
            LogMessages.LOGGER.debugf("Negative threshold, %s, specified. Using default value", threshold);
        }
        catch (Exception e) {
            LogMessages.LOGGER.debug("Exception caught parsing memory threshold. Using default value.", e);
        }
        return 1024;
    }

    private static <T> Optional<T> getProperty(String name, Class<T> type) {
        if (System.getSecurityManager() == null) {
            return ConfigurationFactory.getInstance().getConfiguration().getOptionalValue(name, type);
        }
        return AccessController.doPrivileged(() -> ConfigurationFactory.getInstance().getConfiguration().getOptionalValue(name, type));
    }

    private static class CustomTempFileStorageProvider
    extends AbstractStorageProvider {
        private static final String DEFAULT_PREFIX = "m4j";
        private static final String suffix = ".tmp";
        private final Path directory = System.getSecurityManager() == null ? (Path)Options.ENTITY_TMP_DIR.getValue() : AccessController.doPrivileged(() -> ((Options)Options.ENTITY_TMP_DIR).getValue());

        CustomTempFileStorageProvider() {
        }

        public StorageOutputStream createStorageOutputStream() throws IOException {
            return new TempFileStorageOutputStream(CustomTempFileStorageProvider.createTempFile(this.directory));
        }

        private static Path createTempFile(Path directory) throws IOException {
            boolean java2SecurityEnabled;
            boolean bl = java2SecurityEnabled = System.getSecurityManager() != null;
            if (java2SecurityEnabled) {
                try {
                    return AccessController.doPrivileged(() -> {
                        if (directory == null) {
                            return Files.createTempFile(DEFAULT_PREFIX, suffix, new FileAttribute[0]);
                        }
                        return Files.createTempFile(directory, DEFAULT_PREFIX, suffix, new FileAttribute[0]);
                    });
                }
                catch (PrivilegedActionException pae) {
                    Throwable cause = pae.getCause();
                    if (cause instanceof IOException) {
                        throw (IOException)cause;
                    }
                    throw new RuntimeException(cause);
                }
            }
            if (directory == null) {
                return Files.createTempFile(DEFAULT_PREFIX, suffix, new FileAttribute[0]);
            }
            return Files.createTempFile(directory, DEFAULT_PREFIX, suffix, new FileAttribute[0]);
        }

        private static OutputStream createFileOutputStream(Path file) throws IOException {
            boolean java2SecurityEnabled;
            boolean bl = java2SecurityEnabled = System.getSecurityManager() != null;
            if (java2SecurityEnabled) {
                try {
                    return AccessController.doPrivileged(() -> Files.newOutputStream(file, new OpenOption[0]));
                }
                catch (PrivilegedActionException pae) {
                    Throwable cause = pae.getCause();
                    if (cause instanceof IOException) {
                        throw (IOException)cause;
                    }
                    throw new RuntimeException(cause);
                }
            }
            return Files.newOutputStream(file, new OpenOption[0]);
        }

        private static final class TempFileStorageOutputStream
        extends StorageOutputStream {
            private final Path file;
            private final OutputStream out;

            TempFileStorageOutputStream(Path file) throws IOException {
                this.file = file;
                this.out = CustomTempFileStorageProvider.createFileOutputStream(file);
            }

            public void close() throws IOException {
                super.close();
                this.out.close();
            }

            protected void write0(byte[] buffer, int offset, int length) throws IOException {
                this.out.write(buffer, offset, length);
            }

            protected Storage toStorage0() throws IOException {
                return new TempFileStorage(this.file);
            }
        }

        private static final class TempFileStorage
        implements Storage {
            private Path file;
            private static final Set<Path> filesToDelete = new HashSet<Path>();

            TempFileStorage(Path file) {
                this.file = file;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void delete() {
                Set<Path> set = filesToDelete;
                synchronized (set) {
                    if (this.file != null) {
                        filesToDelete.add(this.file);
                        this.file = null;
                    }
                    Iterator<Path> iterator = filesToDelete.iterator();
                    while (iterator.hasNext()) {
                        Path f = iterator.next();
                        try {
                            if (System.getSecurityManager() != null) {
                                AccessController.doPrivileged(() -> {
                                    Files.deleteIfExists(f);
                                    return null;
                                });
                            } else {
                                Files.deleteIfExists(f);
                            }
                            iterator.remove();
                        }
                        catch (IOException | PrivilegedActionException e) {
                            LogMessages.LOGGER.debugf(e, "Failed to delete file %s", f);
                        }
                    }
                }
            }

            public InputStream getInputStream() throws IOException {
                if (this.file == null) {
                    throw new IllegalStateException("storage has been deleted");
                }
                return new BufferedInputStream(Files.newInputStream(this.file, new OpenOption[0]));
            }
        }
    }
}

