/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.core.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.core.MethodClassKey;
import org.springframework.core.annotation.AnnotationConfigurationException;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.annotation.RepeatableContainers;
import org.springframework.security.core.annotation.AbstractSecurityAnnotationScanner;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

final class UniqueSecurityAnnotationScanner<A extends Annotation>
extends AbstractSecurityAnnotationScanner<A> {
    private final List<Class<A>> types;
    private final Map<Parameter, MergedAnnotation<A>> uniqueParameterAnnotationCache = new ConcurrentHashMap<Parameter, MergedAnnotation<A>>();
    private final Map<MethodClassKey, MergedAnnotation<A>> uniqueMethodAnnotationCache = new ConcurrentHashMap<MethodClassKey, MergedAnnotation<A>>();

    UniqueSecurityAnnotationScanner(Class<A> type) {
        Assert.notNull(type, (String)"type cannot be null");
        this.types = List.of(type);
    }

    UniqueSecurityAnnotationScanner(List<Class<A>> types) {
        Assert.notNull(types, (String)"types cannot be null");
        this.types = types;
    }

    @Override
    MergedAnnotation<A> merge(AnnotatedElement element, Class<?> targetClass) {
        if (element instanceof Parameter) {
            Parameter parameter = (Parameter)element;
            return this.uniqueParameterAnnotationCache.computeIfAbsent(parameter, p -> {
                List<MergedAnnotation<A>> annotations = this.findDirectAnnotations((AnnotatedElement)p);
                return this.requireUnique((AnnotatedElement)p, annotations);
            });
        }
        if (element instanceof Method) {
            Method method = (Method)element;
            return this.uniqueMethodAnnotationCache.computeIfAbsent(new MethodClassKey(method, targetClass), k -> {
                List<MergedAnnotation<A>> annotations = this.findMethodAnnotations(method, targetClass);
                return this.requireUnique(method, annotations);
            });
        }
        throw new AnnotationConfigurationException("Unsupported element of type " + String.valueOf(element.getClass()));
    }

    private MergedAnnotation<A> requireUnique(AnnotatedElement element, List<MergedAnnotation<A>> annotations) {
        return switch (annotations.size()) {
            case 0 -> null;
            case 1 -> annotations.get(0);
            default -> {
                ArrayList<Annotation> synthesized = new ArrayList<Annotation>();
                for (MergedAnnotation<A> annotation : annotations) {
                    synthesized.add(annotation.synthesize());
                }
                throw new AnnotationConfigurationException("Please ensure there is one unique annotation of type %s attributed to %s. Found %d competing annotations: %s".formatted(this.types, element, annotations.size(), synthesized));
            }
        };
    }

    private List<MergedAnnotation<A>> findMethodAnnotations(Method method, Class<?> targetClass) {
        Method specificMethod = ClassUtils.getMostSpecificMethod((Method)method, targetClass);
        List<MergedAnnotation<A>> annotations = this.findClosestMethodAnnotations(specificMethod, specificMethod.getDeclaringClass(), new HashSet());
        if (!annotations.isEmpty()) {
            return annotations;
        }
        if (specificMethod != method && !(annotations = this.findClosestMethodAnnotations(method, method.getDeclaringClass(), new HashSet())).isEmpty()) {
            return annotations;
        }
        annotations = this.findClosestClassAnnotations(specificMethod.getDeclaringClass(), new HashSet());
        if (!annotations.isEmpty()) {
            return annotations;
        }
        return Collections.emptyList();
    }

    private List<MergedAnnotation<A>> findClosestMethodAnnotations(Method method, Class<?> targetClass, Set<Class<?>> classesToSkip) {
        if (targetClass == null || classesToSkip.contains(targetClass) || targetClass == Object.class) {
            return Collections.emptyList();
        }
        classesToSkip.add(targetClass);
        try {
            Method methodToUse = targetClass.getDeclaredMethod(method.getName(), method.getParameterTypes());
            List<MergedAnnotation<A>> annotations = this.findDirectAnnotations(methodToUse);
            if (!annotations.isEmpty()) {
                return annotations;
            }
        }
        catch (NoSuchMethodException methodToUse) {
            // empty catch block
        }
        ArrayList<MergedAnnotation<A>> annotations = new ArrayList<MergedAnnotation<A>>();
        annotations.addAll(this.findClosestMethodAnnotations(method, targetClass.getSuperclass(), classesToSkip));
        for (Class<?> inter : targetClass.getInterfaces()) {
            annotations.addAll(this.findClosestMethodAnnotations(method, inter, classesToSkip));
        }
        return annotations;
    }

    private List<MergedAnnotation<A>> findClosestClassAnnotations(Class<?> targetClass, Set<Class<?>> classesToSkip) {
        if (targetClass == null || classesToSkip.contains(targetClass) || targetClass == Object.class) {
            return Collections.emptyList();
        }
        classesToSkip.add(targetClass);
        ArrayList<MergedAnnotation<A>> annotations = new ArrayList<MergedAnnotation<A>>(this.findDirectAnnotations(targetClass));
        if (!annotations.isEmpty()) {
            return annotations;
        }
        annotations.addAll(this.findClosestClassAnnotations(targetClass.getSuperclass(), classesToSkip));
        for (Class<?> inter : targetClass.getInterfaces()) {
            annotations.addAll(this.findClosestClassAnnotations(inter, classesToSkip));
        }
        return annotations;
    }

    private List<MergedAnnotation<A>> findDirectAnnotations(AnnotatedElement element) {
        MergedAnnotations mergedAnnotations = MergedAnnotations.from((AnnotatedElement)element, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.DIRECT, (RepeatableContainers)RepeatableContainers.none());
        return mergedAnnotations.stream().filter(annotation -> this.types.contains(annotation.getType())).map(annotation -> annotation).toList();
    }
}

