/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.oslogin.common;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class UserName
implements ResourceName {
    private static final PathTemplate USER = PathTemplate.createWithoutUrlEncoding((String)"users/{user}");
    private volatile Map<String, String> fieldValuesMap;
    private final String user;

    @Deprecated
    protected UserName() {
        this.user = null;
    }

    private UserName(Builder builder) {
        this.user = (String)Preconditions.checkNotNull((Object)builder.getUser());
    }

    public String getUser() {
        return this.user;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static UserName of(String user) {
        return UserName.newBuilder().setUser(user).build();
    }

    public static String format(String user) {
        return UserName.newBuilder().setUser(user).build().toString();
    }

    public static UserName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = USER.validatedMatch(formattedString, "UserName.parse: formattedString not in valid format");
        return UserName.of((String)matchMap.get("user"));
    }

    public static List<UserName> parseList(List<String> formattedStrings) {
        ArrayList<UserName> list = new ArrayList<UserName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(UserName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<UserName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (UserName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return USER.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            UserName userName = this;
            synchronized (userName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.user != null) {
                        fieldMapBuilder.put((Object)"user", (Object)this.user);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return USER.instantiate(new String[]{"user", this.user});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            UserName that = (UserName)o;
            return Objects.equals(this.user, that.user);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        return h ^= Objects.hashCode(this.user);
    }

    public static class Builder {
        private String user;

        protected Builder() {
        }

        public String getUser() {
            return this.user;
        }

        public Builder setUser(String user) {
            this.user = user;
            return this;
        }

        private Builder(UserName userName) {
            this.user = userName.user;
        }

        public UserName build() {
            return new UserName(this);
        }
    }
}

