/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authorization.method;

import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.authorization.AuthorizationResult;
import org.springframework.security.authorization.method.MethodAuthorizationDeniedHandler;
import org.springframework.security.authorization.method.MethodInvocationResult;

final class ReflectiveMethodAuthorizationDeniedHandler
implements MethodAuthorizationDeniedHandler {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final Class<?> targetClass;
    private final Class<?> managerClass;

    ReflectiveMethodAuthorizationDeniedHandler(Class<?> targetClass, Class<?> managerClass) {
        this.logger.debug((Object)("Will attempt to instantiate handlerClass attributes using reflection since no application context was supplied to " + managerClass));
        this.targetClass = targetClass;
        this.managerClass = managerClass;
    }

    @Override
    public Object handleDeniedInvocation(MethodInvocation methodInvocation, AuthorizationResult authorizationResult) {
        return this.constructMethodAuthorizationDeniedHandler().handleDeniedInvocation(methodInvocation, authorizationResult);
    }

    @Override
    public Object handleDeniedInvocationResult(MethodInvocationResult methodInvocationResult, AuthorizationResult authorizationResult) {
        return this.constructMethodAuthorizationDeniedHandler().handleDeniedInvocationResult(methodInvocationResult, authorizationResult);
    }

    private MethodAuthorizationDeniedHandler constructMethodAuthorizationDeniedHandler() {
        try {
            return (MethodAuthorizationDeniedHandler)this.targetClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Failed to construct instance of " + this.targetClass + ". Please either add a public default constructor to the class  or publish an instance of it as a Spring bean. If you publish it as a Spring bean,  either add `@EnableMethodSecurity` to your configuration or  provide the `ApplicationContext` directly to " + this.managerClass, ex);
        }
    }
}

