/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules._csv;

import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyInteger;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyType;
import org.python.core.PyUnicode;
import org.python.core.Untraversable;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;
import org.python.modules._csv.PyDialect$PyExposer;
import org.python.modules._csv.PyDialectDerived;
import org.python.modules._csv.QuoteStyle;
import org.python.modules._csv._csv;

@Untraversable
@ExposedType(name="_csv.Dialect", doc="CSV dialect\n\nThe Dialect type records CSV parsing and generation options.\n")
public class PyDialect
extends PyObject {
    public static final PyType TYPE;
    public static final String Dialect_doc = "CSV dialect\n\nThe Dialect type records CSV parsing and generation options.\n";
    public boolean doublequote;
    public char delimiter;
    public char quotechar;
    public char escapechar;
    public boolean skipinitialspace;
    public String lineterminator;
    public QuoteStyle quoting;
    public boolean strict;

    public PyDialect() {
        super(TYPE);
    }

    public PyDialect(PyType subType) {
        super(subType);
    }

    @ExposedNew
    static final PyObject Dialect___new__(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        ArgParser ap = new ArgParser("__new__", args, keywords, new String[]{"dialect", "delimiter", "doublequote", "escapechar", "lineterminator", "quotechar", "quoting", "skipinitialspace", "strict"});
        PyObject dialect = ap.getPyObject(0, null);
        PyObject delimiter = ap.getPyObject(1, null);
        PyObject doublequote = ap.getPyObject(2, null);
        PyObject escapechar = ap.getPyObject(3, null);
        PyObject lineterminator = ap.getPyObject(4, null);
        PyObject quotechar = ap.getPyObject(5, null);
        PyObject quoting = ap.getPyObject(6, null);
        PyObject skipinitialspace = ap.getPyObject(7, null);
        PyObject strict = ap.getPyObject(8, null);
        if (dialect instanceof PyString) {
            dialect = _csv.get_dialect_from_registry(dialect);
        }
        if (dialect instanceof PyDialect && delimiter == null && doublequote == null && escapechar == null && lineterminator == null && quotechar == null && quoting == null && skipinitialspace == null && strict == null) {
            return dialect;
        }
        if (dialect != null) {
            delimiter = delimiter != null ? delimiter : dialect.__findattr__("delimiter");
            doublequote = doublequote != null ? doublequote : dialect.__findattr__("doublequote");
            escapechar = escapechar != null ? escapechar : dialect.__findattr__("escapechar");
            lineterminator = lineterminator != null ? lineterminator : dialect.__findattr__("lineterminator");
            quotechar = quotechar != null ? quotechar : dialect.__findattr__("quotechar");
            quoting = quoting != null ? quoting : dialect.__findattr__("quoting");
            skipinitialspace = skipinitialspace != null ? skipinitialspace : dialect.__findattr__("skipinitialspace");
            strict = strict != null ? strict : dialect.__findattr__("strict");
        }
        PyDialect self = new_.for_type == subtype ? new PyDialect() : new PyDialectDerived(subtype);
        self.delimiter = PyDialect.toChar("delimiter", delimiter, ',');
        self.doublequote = PyDialect.toBool("doublequote", doublequote, true);
        self.escapechar = PyDialect.toChar("escapechar", escapechar, '\u0000');
        self.lineterminator = PyDialect.toStr("lineterminator", lineterminator, "\r\n");
        self.quotechar = PyDialect.toChar("quotechar", quotechar, '\"');
        int quotingOrdinal = PyDialect.toInt("quoting", quoting, QuoteStyle.QUOTE_MINIMAL.ordinal());
        self.skipinitialspace = PyDialect.toBool("skipinitialspace", skipinitialspace, false);
        self.strict = PyDialect.toBool("strict", strict, false);
        self.quoting = QuoteStyle.fromOrdinal(quotingOrdinal);
        if (self.quoting == null) {
            throw Py.TypeError("bad \"quoting\" value");
        }
        if (self.delimiter == '\u0000') {
            throw Py.TypeError("delimiter must be set");
        }
        if (quotechar == Py.None && quoting == null) {
            self.quoting = QuoteStyle.QUOTE_NONE;
        }
        if (self.quoting != QuoteStyle.QUOTE_NONE && self.quotechar == '\u0000') {
            throw Py.TypeError("quotechar must be set if quoting enabled");
        }
        if (self.lineterminator == null) {
            throw Py.TypeError("lineterminator must be set");
        }
        return self;
    }

    private static boolean toBool(String name, PyObject src, boolean dflt) {
        return src == null ? dflt : src.__nonzero__();
    }

    private static char toChar(String name, PyObject src, char dflt) {
        if (src == null) {
            return dflt;
        }
        if (src == Py.None) {
            return '\u0000';
        }
        if (src instanceof PyString) {
            String s;
            String string2 = s = src instanceof PyUnicode ? ((PyUnicode)src).encode() : src.toString();
            if (s.length() == 0) {
                return '\u0000';
            }
            if (s.length() == 1) {
                return s.charAt(0);
            }
        }
        throw Py.TypeError(String.format("\"%s\" must be a 1-character string", name));
    }

    private static int toInt(String name, PyObject src, int dflt) {
        if (src == null) {
            return dflt;
        }
        if (!(src instanceof PyInteger)) {
            throw Py.TypeError(String.format("\"%s\" must be an integer", name));
        }
        return src.asInt();
    }

    private static String toStr(String name, PyObject src, String dflt) {
        if (src == null) {
            return dflt;
        }
        if (src == Py.None) {
            return null;
        }
        if (src instanceof PyUnicode) {
            return ((PyUnicode)src).encode().toString();
        }
        if (src instanceof PyString) {
            return src.toString();
        }
        throw Py.TypeError(String.format("\"%s\" must be a string", name));
    }

    public PyObject getEscapechar() {
        return this.escapechar == '\u0000' ? Py.None : Py.newString(this.escapechar);
    }

    public PyObject getQuotechar() {
        return this.quotechar == '\u0000' ? Py.None : Py.newString(this.quotechar);
    }

    public PyObject getQuoting() {
        return Py.newInteger(this.quoting.ordinal());
    }

    public void setQuoting(PyObject obj) {
        throw Py.AttributeError(String.format("attribute '%s' of '%s' objects is not writable", "quoting", this.getType().fastGetName()));
    }

    public void delQuoting() {
        throw Py.AttributeError(String.format("attribute '%s' of '%s' objects is not writable", "quoting", this.getType().fastGetName()));
    }

    static {
        PyType.addBuilder(PyDialect.class, new PyDialect$PyExposer());
        TYPE = PyType.fromClass(PyDialect.class);
    }
}

