/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor;

import com.typesafe.config.Config;
import java.io.Closeable;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.Cancellable;
import org.apache.pekko.actor.Cancellable$;
import org.apache.pekko.actor.LightArrayRevolverScheduler$;
import org.apache.pekko.actor.Scheduler;
import org.apache.pekko.actor.Scheduler$;
import org.apache.pekko.actor.SchedulerException;
import org.apache.pekko.actor.SchedulerTask;
import org.apache.pekko.dispatch.AbstractNodeQueue;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.util.Helpers$;
import org.apache.pekko.util.Helpers$ConfigOps$;
import org.apache.pekko.util.Unsafe;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.concurrent.Await$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\t-g\u0001B\"E\u00015C\u0001\u0002\u0019\u0001\u0003\u0002\u0003\u0006I!\u0019\u0005\tU\u0002\u0011\t\u0011)A\u0005W\"A\u0011\u000f\u0001B\u0001B\u0003%!\u000fC\u0003{\u0001\u0011\u00051\u0010C\u0005\u0002\u0002\u0001\u0011\r\u0011\"\u0001\u0002\u0004!A\u00111\u0002\u0001!\u0002\u0013\t)\u0001C\u0005\u0002\u000e\u0001\u0011\r\u0011\"\u0001\u0002\u0010!A\u0011q\u0004\u0001!\u0002\u0013\t\t\u0002C\u0005\u0002\"\u0001\u0011\r\u0011\"\u0001\u0002\u0010!A\u00111\u0005\u0001!\u0002\u0013\t\t\u0002C\u0004\u0002&\u0001!I!a\n\t\u000f\u00055\u0002\u0001\"\u0005\u00020!9\u0011q\u0007\u0001\u0005\u0012\u0005\r\u0001bBA\u001d\u0001\u0011E\u0011q\u0002\u0005\b\u0003w\u0001A\u0011CA\u001f\u0011\u001d\tI\u0005\u0001C!\u0003\u0017Bq!a\u001f\u0001\t\u0003\ni\bC\u0004\u0002\n\u0002!\t%a#\t\u000f\u0005U\u0005\u0001\"\u0011\u0002\u0018\"I\u0011\u0011\u0014\u0001C\u0002\u0013\u0005\u00131\u0014\u0005\t\u0003G\u0003\u0001\u0015!\u0003\u0002\u001e\"I\u0011Q\u0015\u0001C\u0002\u0013%\u0011q\u0015\u0005\t\u0003S\u0003\u0001\u0015!\u0003\u00022!I\u00111\u0016\u0001C\u0002\u0013%\u0011q\u0015\u0005\t\u0003[\u0003\u0001\u0015!\u0003\u00022!I\u0011q\u0016\u0001C\u0002\u0013%\u00111\u0001\u0005\t\u0003c\u0003\u0001\u0015!\u0003\u0002\u0006!I\u00111\u0017\u0001C\u0002\u0013%\u0011Q\u0017\u0005\t\u0005O\u0002\u0001\u0015!\u0003\u00028\"9\u00111\u0010\u0001\u0005\n\t%\u0004b\u0002B<\u0001\u0011%!\u0011\u0010\u0005\b\u0005{\u0002A\u0011\u0002B@\u0011%\u0011)\t\u0001b\u0001\n\u0013\u00119\t\u0003\u0005\u0003,\u0002\u0001\u000b\u0011\u0002BE\u0011\u001d\u0011i\u000b\u0001C\u0005\u0005_C\u0011Ba.\u0001\u0001\u0004%IA!/\t\u0013\t\u0005\u0007\u00011A\u0005\n\t\r\u0007\u0002\u0003Bd\u0001\u0001\u0006KAa/\b\u000f\u0005mF\t#\u0001\u0002>\u001a11\t\u0012E\u0001\u0003\u007fCaA\u001f\u0015\u0005\u0002\u0005\u0005\u0007\u0002CAbQ\u0001\u0006I!!2\u0007\r\u0005\u001d\u0007\u0006BAe\u0011\u0019Q8\u0006\"\u0001\u0003J\u0019Q\u0011q\u001d\u0015\u0011\u0002GEA)!;\u0007\u000f\u0005m\u0007\u0006\u0003#\u0002^\"Q\u00111\u001e\u0018\u0003\u0002\u0004%\t!!<\t\u0015\u0005=hF!a\u0001\n\u0003\t\t\u0010\u0003\u0006\u0002x:\u0012\t\u0011)Q\u0005\u0003OB!B!\u0001/\u0005\u0003\u0007I\u0011AA\u0002\u0011)\u0011\u0019A\fBA\u0002\u0013\u0005!Q\u0001\u0005\u000b\u0005\u0013q#\u0011!Q!\n\u0005\u0015\u0001B\u0003B\u0006]\t\u0005\t\u0015!\u0003\u0002\\!1!P\fC\u0001\u0005\u001bAqA!\u0006/\t\u001b\u00119\u0002\u0003\u0005\u0003,9\")A\u0012B\u0017\u0011\u001d\u0011)D\fC!\u0003/CqAa\u000e/\t\u0003\u0012i\u0003C\u0004\u0003:9\"IAa\u000f\t\u000f\t\u0015c\u0006\"\u0011\u0003H!A!Q\n\u0015!\u0002\u0013\u0011y\u0005\u0003\u0005\u0003V!\u0002\u000b\u0011\u0002B,\u0011%\u0011Y\u0006\u000bb\u0001\n\u0013\u0011i\u0006\u0003\u0005\u0003`!\u0002\u000b\u0011BAs\u0011%\u0011\t\u0007\u000bb\u0001\n\u0013\u0011\u0019\u0007\u0003\u0005\u0003f!\u0002\u000b\u0011BA)\u0005ma\u0015n\u001a5u\u0003J\u0014\u0018-\u001f*fm>dg/\u001a:TG\",G-\u001e7fe*\u0011QIR\u0001\u0006C\u000e$xN\u001d\u0006\u0003\u000f\"\u000bQ\u0001]3lW>T!!\u0013&\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0015aA8sO\u000e\u00011\u0003\u0002\u0001O)b\u0003\"a\u0014*\u000e\u0003AS\u0011!U\u0001\u0006g\u000e\fG.Y\u0005\u0003'B\u0013a!\u00118z%\u00164\u0007CA+W\u001b\u0005!\u0015BA,E\u0005%\u00196\r[3ek2,'\u000f\u0005\u0002Z=6\t!L\u0003\u0002\\9\u0006\u0011\u0011n\u001c\u0006\u0002;\u0006!!.\u0019<b\u0013\ty&LA\u0005DY>\u001cX-\u00192mK\u000611m\u001c8gS\u001e\u0004\"A\u00195\u000e\u0003\rT!\u0001\u00193\u000b\u0005\u00154\u0017\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003\u001d\f1aY8n\u0013\tI7M\u0001\u0004D_:4\u0017nZ\u0001\u0004Y><\u0007C\u00017p\u001b\u0005i'B\u00018G\u0003\u0015)g/\u001a8u\u0013\t\u0001XN\u0001\bM_\u001e<\u0017N\\4BI\u0006\u0004H/\u001a:\u0002\u001bQD'/Z1e\r\u0006\u001cGo\u001c:z!\t\u0019\b0D\u0001u\u0015\t)h/\u0001\u0006d_:\u001cWO\u001d:f]RT!a\u001e/\u0002\tU$\u0018\u000e\\\u0005\u0003sR\u0014Q\u0002\u00165sK\u0006$g)Y2u_JL\u0018A\u0002\u001fj]&$h\b\u0006\u0003}{z|\bCA+\u0001\u0011\u0015\u0001G\u00011\u0001b\u0011\u0015QG\u00011\u0001l\u0011\u0015\tH\u00011\u0001s\u0003%9\u0006.Z3m'&TX-\u0006\u0002\u0002\u0006A\u0019q*a\u0002\n\u0007\u0005%\u0001KA\u0002J]R\f!b\u00165fK2\u001c\u0016N_3!\u00031!\u0016nY6EkJ\fG/[8o+\t\t\t\u0002\u0005\u0003\u0002\u0014\u0005mQBAA\u000b\u0015\u0011\t9\"!\u0007\u0002\u0011\u0011,(/\u0019;j_:T!!\u001e)\n\t\u0005u\u0011Q\u0003\u0002\u000f\r&t\u0017\u000e^3EkJ\fG/[8o\u00035!\u0016nY6EkJ\fG/[8oA\u0005y1\u000b[;uI><h\u000eV5nK>,H/\u0001\tTQV$Hm\\<o)&lWm\\;uA\u00059!o\\;oIV\u0003H\u0003BA\t\u0003SAq!a\u000b\f\u0001\u0004\t\t\"A\u0001e\u0003\u0015\u0019Gn\\2l)\t\t\t\u0004E\u0002P\u0003gI1!!\u000eQ\u0005\u0011auN\\4\u0002\u0013M$\u0018M\u001d;US\u000e\\\u0017AE4fiNCW\u000f\u001e3po:$\u0016.\\3pkR\f\u0011b^1ji:\u000bgn\\:\u0015\t\u0005}\u0012Q\t\t\u0004\u001f\u0006\u0005\u0013bAA\"!\n!QK\\5u\u0011\u001d\t9e\u0004a\u0001\u0003c\tQA\\1o_N\fac]2iK\u0012,H.Z,ji\"4\u0015\u000e_3e\t\u0016d\u0017-\u001f\u000b\u0007\u0003\u001b\n\u0019(a\u001e\u0015\t\u0005=\u00131\r\u000b\u0005\u0003#\n9\u0006E\u0002V\u0003'J1!!\u0016E\u0005-\u0019\u0015M\\2fY2\f'\r\\3\t\u000f\u0005e\u0003\u0003q\u0001\u0002\\\u0005AQ\r_3dkR|'\u000f\u0005\u0003\u0002^\u0005}SBAA\r\u0013\u0011\t\t'!\u0007\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\bbBA3!\u0001\u0007\u0011qM\u0001\teVtg.\u00192mKB!\u0011\u0011NA8\u001b\t\tYGC\u0002\u0002nq\u000bA\u0001\\1oO&!\u0011\u0011OA6\u0005!\u0011VO\u001c8bE2,\u0007bBA;!\u0001\u0007\u0011\u0011C\u0001\rS:LG/[1m\t\u0016d\u0017-\u001f\u0005\b\u0003s\u0002\u0002\u0019AA\t\u0003\u0015!W\r\\1z\u0003!\u00198\r[3ek2,G\u0003CA@\u0003\u0007\u000b))a\"\u0015\t\u0005E\u0013\u0011\u0011\u0005\b\u00033\n\u00029AA.\u0011\u001d\t)(\u0005a\u0001\u0003#Aq!!\u001f\u0012\u0001\u0004\t\t\u0002C\u0004\u0002fE\u0001\r!a\u001a\u0002\u0019M\u001c\u0007.\u001a3vY\u0016|enY3\u0015\r\u00055\u0015\u0011SAJ)\u0011\t\t&a$\t\u000f\u0005e#\u0003q\u0001\u0002\\!9\u0011\u0011\u0010\nA\u0002\u0005E\u0001bBA3%\u0001\u0007\u0011qM\u0001\u0006G2|7/\u001a\u000b\u0003\u0003\u007f\tA\"\\1y\rJ,\u0017/^3oGf,\"!!(\u0011\u0007=\u000by*C\u0002\u0002\"B\u0013a\u0001R8vE2,\u0017!D7bq\u001a\u0013X-];f]\u000eL\b%A\u0003ti\u0006\u0014H/\u0006\u0002\u00022\u000511\u000f^1si\u0002\n\u0011\u0002^5dW:\u000bgn\\:\u0002\u0015QL7m\u001b(b]>\u001c\b%A\u0005xQ\u0016,G.T1tW\u0006Qq\u000f[3fY6\u000b7o\u001b\u0011\u0002\u000bE,X-^3\u0016\u0005\u0005]\u0006cAA]W9\u0011QkJ\u0001\u001c\u0019&<\u0007\u000e^!se\u0006L(+\u001a<pYZ,'oU2iK\u0012,H.\u001a:\u0011\u0005UC3C\u0001\u0015O)\t\ti,\u0001\u0006uCN\\wJ\u001a4tKR\u00042aTA\u001a\u0005%!\u0016m]6Rk\u0016,XmE\u0002,\u0003\u0017\u0004b!!4\u0002T\u0006]WBAAh\u0015\r\t\tNR\u0001\tI&\u001c\b/\u0019;dQ&!\u0011Q[Ah\u0005E\t%m\u001d;sC\u000e$hj\u001c3f#V,W/\u001a\t\u0004\u00033tS\"\u0001\u0015\u0003\u0015Q\u000b7o\u001b%pY\u0012,'oE\u0003/\u0003?\f)\u000f\u0005\u0003\u0002j\u0005\u0005\u0018\u0002BAr\u0003W\u0012aa\u00142kK\u000e$\bcAAm[\tIA+[7feR\u000b7o[\n\b[\u0005}\u0017qMA)\u0003\u0011!\u0018m]6\u0016\u0005\u0005\u001d\u0014\u0001\u0003;bg.|F%Z9\u0015\t\u0005}\u00121\u001f\u0005\n\u0003k\u0004\u0014\u0011!a\u0001\u0003O\n1\u0001\u001f\u00132\u0003\u0015!\u0018m]6!Q\r\t\u00141 \t\u0004\u001f\u0006u\u0018bAA\u0000!\nAao\u001c7bi&dW-A\u0003uS\u000e\\7/A\u0005uS\u000e\\7o\u0018\u0013fcR!\u0011q\bB\u0004\u0011%\t)pMA\u0001\u0002\u0004\t)!\u0001\u0004uS\u000e\\7\u000fI\u0001\u0011Kb,7-\u001e;j_:\u001cuN\u001c;fqR$\u0002\"a6\u0003\u0010\tE!1\u0003\u0005\b\u0003W4\u0004\u0019AA4\u0011\u001d\u0011\tA\u000ea\u0001\u0003\u000bAqAa\u00037\u0001\u0004\tY&A\u0006fqR\u0014\u0018m\u0019;UCN\\G\u0003BA4\u00053AqAa\u00078\u0001\u0004\t9'A\u0006sKBd\u0017mY3XSRD\u0007fA\u001c\u0003 A!!\u0011\u0005B\u0014\u001b\t\u0011\u0019CC\u0002\u0003&A\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0011ICa\t\u0003\u000fQ\f\u0017\u000e\u001c:fG\u0006YQ\r_3dkR,G+Y:l)\t\u0011y\u0003E\u0002P\u0005cI1Aa\rQ\u0005\u001d\u0011un\u001c7fC:\f1A];o\u0003\u0019\u0019\u0017M\\2fY\u0006\u0011bn\u001c;jMf\u001c\u0015M\\2fY2\fG/[8o)\u0011\tyD!\u0010\t\u000f\u0005-8\b1\u0001\u0003@A\u0019QK!\u0011\n\u0007\t\rCIA\u0007TG\",G-\u001e7feR\u000b7o[\u0001\fSN\u001c\u0015M\\2fY2,G-\u0006\u0002\u00030Q\u0011!1\n\t\u0004\u00033\\\u0013!D\"b]\u000e,G\u000e\\3e)\u0006\u001c8N\u0005\u0004\u0003R\u0005}\u0017q\r\u0004\u0007\u0005'j\u0004Aa\u0014\u0003\u0019q\u0012XMZ5oK6,g\u000e\u001e \u0002\u0019\u0015CXmY;uK\u0012$\u0016m]6\u0013\r\te\u0013q\\A4\r\u0019\u0011\u0019F\u0010\u0001\u0003X\u0005qaj\u001c;DC:\u001cW\r\u001c7bE2,WCAAs\u0003=qu\u000e^\"b]\u000e,G\u000e\\1cY\u0016\u0004\u0013aE%oSRL\u0017\r\u001c*fa\u0016\fG/T1sW\u0016\u0014XCAA)\u0003QIe.\u001b;jC2\u0014V\r]3bi6\u000b'o[3sA\u00051\u0011/^3vK\u0002\"\u0002Ba\u001b\u0003n\tE$Q\u000f\t\u0004\u0003sk\u0003b\u0002B8=\u0001\u0007\u00111L\u0001\u0003K\u000eDqAa\u001d\u001f\u0001\u0004\t9'A\u0001s\u0011\u001d\tIH\ba\u0001\u0003#\t1b\u00195fG.\u0004VM]5pIR!\u0011q\bB>\u0011\u001d\tIh\ba\u0001\u0003#\tQb\u00195fG.l\u0015\r\u001f#fY\u0006LH\u0003BA \u0005\u0003CqAa!!\u0001\u0004\t\t$\u0001\u0006eK2\f\u0017PT1o_N\fqa\u001d;paB,G-\u0006\u0002\u0003\nB1!1\u0012BI\u0005+k!A!$\u000b\u0007\t=E/\u0001\u0004bi>l\u0017nY\u0005\u0005\u0005'\u0013iIA\bBi>l\u0017n\u0019*fM\u0016\u0014XM\\2f!\u0019\tiFa&\u0003\u001c&!!\u0011TA\r\u0005\u001d\u0001&o\\7jg\u0016\u0004bA!(\u0003(\n-TB\u0001BP\u0015\u0011\u0011\tKa)\u0002\u0013%lW.\u001e;bE2,'b\u0001BS!\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t%&q\u0014\u0002\u0004'\u0016\f\u0018\u0001C:u_B\u0004X\r\u001a\u0011\u0002\tM$x\u000e\u001d\u000b\u0003\u0005c\u0003b!!\u0018\u00034\nm\u0015\u0002\u0002B[\u00033\u0011aAR;ukJ,\u0017a\u0003;j[\u0016\u0014H\u000b\u001b:fC\u0012,\"Aa/\u0011\t\u0005%$QX\u0005\u0005\u0005\u007f\u000bYG\u0001\u0004UQJ,\u0017\rZ\u0001\u0010i&lWM\u001d+ie\u0016\fGm\u0018\u0013fcR!\u0011q\bBc\u0011%\t)0JA\u0001\u0002\u0004\u0011Y,\u0001\u0007uS6,'\u000f\u00165sK\u0006$\u0007\u0005K\u0002'\u0003w\u0004")
public class LightArrayRevolverScheduler
implements Scheduler,
Closeable {
    public final LoggingAdapter org$apache$pekko$actor$LightArrayRevolverScheduler$$log;
    public final ThreadFactory org$apache$pekko$actor$LightArrayRevolverScheduler$$threadFactory;
    private final int WheelSize;
    private final FiniteDuration TickDuration;
    private final FiniteDuration ShutdownTimeout;
    private final double maxFrequency;
    private final long org$apache$pekko$actor$LightArrayRevolverScheduler$$start;
    private final long org$apache$pekko$actor$LightArrayRevolverScheduler$$tickNanos;
    private final int org$apache$pekko$actor$LightArrayRevolverScheduler$$wheelMask;
    private final TaskQueue org$apache$pekko$actor$LightArrayRevolverScheduler$$queue;
    private final AtomicReference<Promise<Seq<TimerTask>>> org$apache$pekko$actor$LightArrayRevolverScheduler$$stopped;
    private volatile Thread org$apache$pekko$actor$LightArrayRevolverScheduler$$timerThread;

    @Override
    public final Cancellable scheduleWithFixedDelay(java.time.Duration initialDelay, java.time.Duration delay, Runnable runnable, ExecutionContext executor) {
        return Scheduler.scheduleWithFixedDelay$((Scheduler)this, initialDelay, delay, runnable, executor);
    }

    @Override
    public final Cancellable scheduleWithFixedDelay(FiniteDuration initialDelay, FiniteDuration delay, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
        return Scheduler.scheduleWithFixedDelay$((Scheduler)this, initialDelay, delay, receiver, message, executor, sender);
    }

    @Override
    public final ActorRef scheduleWithFixedDelay$default$6(FiniteDuration initialDelay, FiniteDuration delay, ActorRef receiver, Object message) {
        return Scheduler.scheduleWithFixedDelay$default$6$(this, initialDelay, delay, receiver, message);
    }

    @Override
    public final Cancellable scheduleWithFixedDelay(java.time.Duration initialDelay, java.time.Duration delay, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
        return Scheduler.scheduleWithFixedDelay$((Scheduler)this, initialDelay, delay, receiver, message, executor, sender);
    }

    @Override
    public final Cancellable scheduleAtFixedRate(FiniteDuration initialDelay, FiniteDuration interval, Runnable runnable, ExecutionContext executor) {
        return Scheduler.scheduleAtFixedRate$((Scheduler)this, initialDelay, interval, runnable, executor);
    }

    @Override
    public final Cancellable scheduleAtFixedRate(java.time.Duration initialDelay, java.time.Duration interval, Runnable runnable, ExecutionContext executor) {
        return Scheduler.scheduleAtFixedRate$((Scheduler)this, initialDelay, interval, runnable, executor);
    }

    @Override
    public final Cancellable scheduleAtFixedRate(FiniteDuration initialDelay, FiniteDuration interval, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
        return Scheduler.scheduleAtFixedRate$((Scheduler)this, initialDelay, interval, receiver, message, executor, sender);
    }

    @Override
    public final ActorRef scheduleAtFixedRate$default$6(FiniteDuration initialDelay, FiniteDuration interval, ActorRef receiver, Object message) {
        return Scheduler.scheduleAtFixedRate$default$6$(this, initialDelay, interval, receiver, message);
    }

    @Override
    public final Cancellable scheduleAtFixedRate(java.time.Duration initialDelay, java.time.Duration interval, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
        return Scheduler.scheduleAtFixedRate$((Scheduler)this, initialDelay, interval, receiver, message, executor, sender);
    }

    @Override
    public final Cancellable schedule(FiniteDuration initialDelay, FiniteDuration interval, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
        return Scheduler.schedule$((Scheduler)this, initialDelay, interval, receiver, message, executor, sender);
    }

    @Override
    public final ActorRef schedule$default$6(FiniteDuration initialDelay, FiniteDuration interval, ActorRef receiver, Object message) {
        return Scheduler.schedule$default$6$(this, initialDelay, interval, receiver, message);
    }

    @Override
    public final Cancellable schedule(java.time.Duration initialDelay, java.time.Duration interval, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
        return Scheduler.schedule$((Scheduler)this, initialDelay, interval, receiver, message, executor, sender);
    }

    @Override
    public final Cancellable schedule(FiniteDuration initialDelay, FiniteDuration interval, Function0<BoxedUnit> f, ExecutionContext executor) {
        return Scheduler.schedule$((Scheduler)this, initialDelay, interval, f, executor);
    }

    @Override
    public Cancellable schedule(java.time.Duration initialDelay, java.time.Duration interval, Runnable runnable, ExecutionContext executor) {
        return Scheduler.schedule$((Scheduler)this, initialDelay, interval, runnable, executor);
    }

    @Override
    public final Cancellable scheduleOnce(FiniteDuration delay, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
        return Scheduler.scheduleOnce$((Scheduler)this, delay, receiver, message, executor, sender);
    }

    @Override
    public final ActorRef scheduleOnce$default$5(FiniteDuration delay, ActorRef receiver, Object message) {
        return Scheduler.scheduleOnce$default$5$(this, delay, receiver, message);
    }

    @Override
    public final Cancellable scheduleOnce(java.time.Duration delay, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
        return Scheduler.scheduleOnce$((Scheduler)this, delay, receiver, message, executor, sender);
    }

    @Override
    public final Cancellable scheduleOnce(FiniteDuration delay, Function0<BoxedUnit> f, ExecutionContext executor) {
        return Scheduler.scheduleOnce$((Scheduler)this, delay, f, executor);
    }

    @Override
    public Cancellable scheduleOnce(java.time.Duration delay, Runnable runnable, ExecutionContext executor) {
        return Scheduler.scheduleOnce$((Scheduler)this, delay, runnable, executor);
    }

    public int WheelSize() {
        return this.WheelSize;
    }

    public FiniteDuration TickDuration() {
        return this.TickDuration;
    }

    public FiniteDuration ShutdownTimeout() {
        return this.ShutdownTimeout;
    }

    public FiniteDuration org$apache$pekko$actor$LightArrayRevolverScheduler$$roundUp(FiniteDuration d) {
        long dn = d.toNanos();
        long r = ((dn - 1L) / this.org$apache$pekko$actor$LightArrayRevolverScheduler$$tickNanos() + 1L) * this.org$apache$pekko$actor$LightArrayRevolverScheduler$$tickNanos();
        if (r != dn && r > 0L && dn > 0L) {
            return new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(r)).nanos();
        }
        return d;
    }

    public long clock() {
        return System.nanoTime();
    }

    public int startTick() {
        return 0;
    }

    public FiniteDuration getShutdownTimeout() {
        return this.ShutdownTimeout();
    }

    public void waitNanos(long nanos) {
        try {
            Thread.sleep(Helpers$.MODULE$.isWindows() ? (nanos + 4999999L) / 10000000L * 10L : (nanos + 999999L) / 1000000L);
            return;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return;
        }
    }

    @Override
    public Cancellable scheduleWithFixedDelay(FiniteDuration initialDelay, FiniteDuration delay, Runnable runnable, ExecutionContext executor) {
        this.checkPeriod(delay);
        this.checkMaxDelay(this.org$apache$pekko$actor$LightArrayRevolverScheduler$$roundUp(delay).toNanos());
        return new Scheduler.AtomicCancellable(this, initialDelay, runnable, delay, executor){
            private final /* synthetic */ Scheduler $outer;
            private final FiniteDuration initialDelay$1;
            public final Runnable runnable$1;
            public final FiniteDuration delay$1;
            public final ExecutionContext executor$1;

            public final Cancellable scheduledFirst() {
                return this.$outer.scheduleOnce(this.initialDelay$1, (Runnable)new SchedulerTask(this){
                    private final /* synthetic */ Scheduler$.anon.1 $outer;

                    public void run() {
                        try {
                            this.$outer.runnable$1.run();
                            if (this.$outer.get() != null) {
                                this.$outer.swap(this.$outer.org$apache$pekko$actor$Scheduler$$anon$$$outer().scheduleOnce(this.$outer.delay$1, (Runnable)this, this.$outer.executor$1));
                            }
                        }
                        catch (Throwable throwable) {
                            IllegalStateException illegalStateException;
                            if (throwable instanceof SchedulerException) {
                                return;
                            }
                            if (throwable instanceof IllegalStateException && (illegalStateException = (IllegalStateException)throwable).getCause() != null && illegalStateException.getCause() instanceof SchedulerException) {
                                return;
                            }
                            throw throwable;
                        }
                    }

                    public void cancelled() {
                        Runnable runnable = this.$outer.runnable$1;
                        if (runnable instanceof SchedulerTask) {
                            ((SchedulerTask)runnable).cancelled();
                            return;
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, this.executor$1);
            }

            public /* synthetic */ Scheduler org$apache$pekko$actor$Scheduler$$anon$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.initialDelay$1 = initialDelay$1;
                this.runnable$1 = runnable$1;
                this.delay$1 = delay$1;
                this.executor$1 = executor$1;
                super(Cancellable$.MODULE$.initialNotCancelled());
            }
        };
    }

    @Override
    public Cancellable schedule(FiniteDuration initialDelay, FiniteDuration delay, Runnable runnable, ExecutionContext executor) {
        this.checkPeriod(delay);
        this.checkMaxDelay(this.org$apache$pekko$actor$LightArrayRevolverScheduler$$roundUp(delay).toNanos());
        return new Scheduler.AtomicCancellable(this, executor, initialDelay, runnable, delay){
            private final /* synthetic */ LightArrayRevolverScheduler $outer;
            public final ExecutionContext executor$1;
            public final FiniteDuration initialDelay$1;
            public final Runnable runnable$1;
            public final FiniteDuration delay$1;

            public final Cancellable scheduledFirst() {
                return this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$schedule(this.executor$1, new SchedulerTask(this){
                    private final /* synthetic */ $anon$1 $outer;

                    public void run() {
                        try {
                            this.$outer.runnable$1.run();
                            long driftNanos = this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$anon$$$outer().clock() - this.getAndAdd(this.$outer.delay$1.toNanos());
                            if (this.$outer.get() != null) {
                                this.$outer.swap(this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$anon$$$outer().org$apache$pekko$actor$LightArrayRevolverScheduler$$schedule(this.$outer.executor$1, this, Duration$.MODULE$.fromNanos(Math.max(this.$outer.delay$1.toNanos() - driftNanos, 1L))));
                            }
                        }
                        catch (SchedulerException schedulerException) {}
                    }

                    public void cancelled() {
                        Runnable runnable = this.$outer.runnable$1;
                        if (runnable instanceof SchedulerTask) {
                            ((SchedulerTask)runnable).cancelled();
                            return;
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        super($outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$anon$$$outer().clock() + $outer.initialDelay$1.toNanos());
                    }
                }, this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$roundUp(this.initialDelay$1));
            }

            public /* synthetic */ LightArrayRevolverScheduler org$apache$pekko$actor$LightArrayRevolverScheduler$$anon$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.executor$1 = executor$1;
                this.initialDelay$1 = initialDelay$1;
                this.runnable$1 = runnable$1;
                this.delay$1 = delay$1;
                super(LightArrayRevolverScheduler$.MODULE$.org$apache$pekko$actor$LightArrayRevolverScheduler$$InitialRepeatMarker());
            }
        };
    }

    @Override
    public Cancellable scheduleOnce(FiniteDuration delay, Runnable runnable, ExecutionContext executor) {
        try {
            return this.org$apache$pekko$actor$LightArrayRevolverScheduler$$schedule(executor, runnable, this.org$apache$pekko$actor$LightArrayRevolverScheduler$$roundUp(delay));
        }
        catch (Throwable throwable) {
            if (throwable instanceof SchedulerException) {
                SchedulerException schedulerException = (SchedulerException)throwable;
                String msg = schedulerException.msg();
                throw new IllegalStateException(msg, schedulerException);
            }
            throw throwable;
        }
    }

    @Override
    public void close() {
        ((IterableOnceOps)Await$.MODULE$.result(this.stop(), (Duration)this.getShutdownTimeout())).foreach((Function1 & Serializable)x0$1 -> {
            LightArrayRevolverScheduler.$anonfun$close$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public double maxFrequency() {
        return this.maxFrequency;
    }

    public long org$apache$pekko$actor$LightArrayRevolverScheduler$$start() {
        return this.org$apache$pekko$actor$LightArrayRevolverScheduler$$start;
    }

    public long org$apache$pekko$actor$LightArrayRevolverScheduler$$tickNanos() {
        return this.org$apache$pekko$actor$LightArrayRevolverScheduler$$tickNanos;
    }

    public int org$apache$pekko$actor$LightArrayRevolverScheduler$$wheelMask() {
        return this.org$apache$pekko$actor$LightArrayRevolverScheduler$$wheelMask;
    }

    public TaskQueue org$apache$pekko$actor$LightArrayRevolverScheduler$$queue() {
        return this.org$apache$pekko$actor$LightArrayRevolverScheduler$$queue;
    }

    public TimerTask org$apache$pekko$actor$LightArrayRevolverScheduler$$schedule(ExecutionContext ec, Runnable r, FiniteDuration delay) {
        if (delay.length() <= 0L) {
            if (this.org$apache$pekko$actor$LightArrayRevolverScheduler$$stopped().get() != null) {
                throw new SchedulerException("cannot enqueue after timer shutdown");
            }
            ec.execute(r);
            return LightArrayRevolverScheduler$.MODULE$.org$apache$pekko$actor$LightArrayRevolverScheduler$$NotCancellable();
        }
        if (this.org$apache$pekko$actor$LightArrayRevolverScheduler$$stopped().get() != null) {
            throw new SchedulerException("cannot enqueue after timer shutdown");
        }
        long delayNanos = delay.toNanos();
        this.checkMaxDelay(delayNanos);
        int ticks = (int)(delayNanos / this.org$apache$pekko$actor$LightArrayRevolverScheduler$$tickNanos());
        TaskHolder task = new TaskHolder(r, ticks, ec);
        this.org$apache$pekko$actor$LightArrayRevolverScheduler$$queue().add(task);
        if (this.org$apache$pekko$actor$LightArrayRevolverScheduler$$stopped().get() != null && task.cancel()) {
            throw new SchedulerException("cannot enqueue after timer shutdown");
        }
        return task;
    }

    private void checkPeriod(FiniteDuration delay) {
        if (delay.length() <= 0L) {
            throw new IllegalArgumentException(new StringBuilder(119).append("Task scheduled with [").append(delay.toSeconds()).append("] seconds delay, which means creating an infinite loop. ").append("The expected delay must be greater than 0.").toString());
        }
    }

    private void checkMaxDelay(long delayNanos) {
        if (delayNanos / this.org$apache$pekko$actor$LightArrayRevolverScheduler$$tickNanos() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(new StringBuilder(93).append("Task scheduled with [").append(new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(delayNanos)).nanos().toSeconds()).append("] seconds delay, ").append("which is too far in future, maximum delay is [").append(new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(this.org$apache$pekko$actor$LightArrayRevolverScheduler$$tickNanos() * Integer.MAX_VALUE)).nanos().toSeconds() - 1L).append("] seconds").toString());
        }
    }

    public AtomicReference<Promise<Seq<TimerTask>>> org$apache$pekko$actor$LightArrayRevolverScheduler$$stopped() {
        return this.org$apache$pekko$actor$LightArrayRevolverScheduler$$stopped;
    }

    private Future<Seq<TimerTask>> stop() {
        Promise p = Promise$.MODULE$.apply();
        if (this.org$apache$pekko$actor$LightArrayRevolverScheduler$$stopped().compareAndSet(null, (Promise<Seq<TimerTask>>)p)) {
            return p.future();
        }
        return Future$.MODULE$.successful((Object)Nil$.MODULE$);
    }

    private Thread timerThread() {
        return this.org$apache$pekko$actor$LightArrayRevolverScheduler$$timerThread;
    }

    public void org$apache$pekko$actor$LightArrayRevolverScheduler$$timerThread_$eq(Thread x$1) {
        this.org$apache$pekko$actor$LightArrayRevolverScheduler$$timerThread = x$1;
    }

    public static final /* synthetic */ boolean $anonfun$WheelSize$1(int ticks) {
        return (ticks & ticks - 1) == 0;
    }

    private final void runTask$1(Runnable task) {
        try {
            task.run();
            return;
        }
        catch (Throwable throwable) {
            if (throwable instanceof InterruptedException) {
                throw (InterruptedException)throwable;
            }
            if (throwable instanceof SchedulerException) {
                return;
            }
            if (throwable != null && NonFatal$.MODULE$.apply(throwable)) {
                this.org$apache$pekko$actor$LightArrayRevolverScheduler$$log.error(throwable, "exception while executing timer task");
                return;
            }
            throw throwable;
        }
    }

    public static final /* synthetic */ void $anonfun$close$1(LightArrayRevolverScheduler $this, TimerTask x0$1) {
        if (x0$1 instanceof Scheduler.TaskRunOnClose) {
            try {
                x0$1.run();
                return;
            }
            catch (Throwable throwable) {
                if (throwable instanceof InterruptedException) {
                    throw (InterruptedException)throwable;
                }
                if (throwable instanceof SchedulerException) {
                    return;
                }
                if (throwable != null && NonFatal$.MODULE$.apply(throwable)) {
                    $this.org$apache$pekko$actor$LightArrayRevolverScheduler$$log.error(throwable, "exception while executing timer task");
                    return;
                }
                throw throwable;
            }
        }
        if (x0$1 instanceof TaskHolder) {
            Runnable runnable = ((TaskHolder)x0$1).task();
            if (runnable instanceof Scheduler.TaskRunOnClose) {
                Scheduler.TaskRunOnClose taskRunOnClose = (Scheduler.TaskRunOnClose)runnable;
                $this.runTask$1(taskRunOnClose);
                return;
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public LightArrayRevolverScheduler(Config config, LoggingAdapter log, ThreadFactory threadFactory) {
        FiniteDuration finiteDuration;
        void getMillisDuration$extension_path;
        void requiring$extension_msg;
        this.org$apache$pekko$actor$LightArrayRevolverScheduler$$log = log;
        this.org$apache$pekko$actor$LightArrayRevolverScheduler$$threadFactory = threadFactory;
        Function0 & Serializable intersect = (Function0 & Serializable)() -> "ticks-per-wheel must be a power of 2";
        int requiring$extension_$this = config.getInt("pekko.scheduler.ticks-per-wheel");
        Predef$.MODULE$.require(LightArrayRevolverScheduler.$anonfun$WheelSize$1(requiring$extension_$this), (Function0)requiring$extension_msg);
        intersect = null;
        this.WheelSize = requiring$extension_$this;
        String string = "pekko.scheduler.tick-duration";
        Helpers$ConfigOps$ getMillisDuration$extension_this = Helpers$ConfigOps$.MODULE$;
        Object var8_7 = null;
        string = null;
        FiniteDuration durationFromConfig = getMillisDuration$extension_this.getDuration$extension(config, (String)getMillisDuration$extension_path, TimeUnit.MILLISECONDS);
        boolean errorOnVerificationFailed = config.getBoolean("pekko.scheduler.error-on-tick-duration-verification-failed");
        if (durationFromConfig.$less((Object)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).millis())) {
            if (Helpers$.MODULE$.isWindows()) {
                if (errorOnVerificationFailed) {
                    throw new IllegalArgumentException("requirement failed: minimum supported pekko.scheduler.tick-duration on Windows is 10ms");
                }
                log.warning("requirement failed: minimum supported pekko.scheduler.tick-duration on Windows is 10ms, adjusted to 10ms now.");
                finiteDuration = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).millis();
            } else if (durationFromConfig.$less((Object)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).millis())) {
                if (errorOnVerificationFailed) {
                    throw new IllegalArgumentException("requirement failed: minimum supported pekko.scheduler.tick-duration is 1ms");
                }
                log.warning("requirement failed: minimum supported pekko.scheduler.tick-duration is 1ms, adjusted to 1ms now.");
                finiteDuration = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).millis();
            } else {
                finiteDuration = durationFromConfig;
            }
        } else {
            finiteDuration = durationFromConfig;
        }
        this.TickDuration = finiteDuration;
        String getMillisDuration$extension_path2 = "pekko.scheduler.shutdown-timeout";
        Object var10_10 = null;
        this.ShutdownTimeout = Helpers$ConfigOps$.MODULE$.getDuration$extension(config, getMillisDuration$extension_path2, TimeUnit.MILLISECONDS);
        this.maxFrequency = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).second().$div((Duration)this.TickDuration());
        this.org$apache$pekko$actor$LightArrayRevolverScheduler$$start = this.clock();
        this.org$apache$pekko$actor$LightArrayRevolverScheduler$$tickNanos = this.TickDuration().toNanos();
        this.org$apache$pekko$actor$LightArrayRevolverScheduler$$wheelMask = this.WheelSize() - 1;
        this.org$apache$pekko$actor$LightArrayRevolverScheduler$$queue = new TaskQueue();
        this.org$apache$pekko$actor$LightArrayRevolverScheduler$$stopped = new AtomicReference();
        this.org$apache$pekko$actor$LightArrayRevolverScheduler$$timerThread = threadFactory.newThread(new Runnable(this){
            private int tick;
            private long totalTick;
            private final TaskQueue[] wheel;
            private TaskQueue spareTaskQueue;
            private final /* synthetic */ LightArrayRevolverScheduler $outer;

            private int tick() {
                return this.tick;
            }

            private void tick_$eq(int x$1) {
                this.tick = x$1;
            }

            private long totalTick() {
                return this.totalTick;
            }

            private void totalTick_$eq(long x$1) {
                this.totalTick = x$1;
            }

            private TaskQueue[] wheel() {
                return this.wheel;
            }

            private TaskQueue spareTaskQueue() {
                return this.spareTaskQueue;
            }

            private void spareTaskQueue_$eq(TaskQueue x$1) {
                this.spareTaskQueue = x$1;
            }

            private Seq<TimerTask> clearAll() {
                return (Seq)((IterableOps)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.$outer.WheelSize()).flatMap((Function1 & Serializable)i -> $anon$3.$anonfun$clearAll$1(this, BoxesRunTime.unboxToInt((Object)i)))).$plus$plus((IterableOnce)this.collect$1(this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$queue(), package$.MODULE$.Vector().empty()));
            }

            private void checkQueue(long time) {
                AbstractNodeQueue.Node<T> node;
                while ((node = this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$queue().pollNode()) != null) {
                    int n = ((TaskHolder)node.value).ticks();
                    switch (n) {
                        case 0: {
                            ((TaskHolder)node.value).executeTask();
                            break;
                        }
                        default: {
                            int futureTick = (int)((time - this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$start() + (long)n * this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$tickNanos() + this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$tickNanos() - 1L) / this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$tickNanos());
                            int offset = futureTick - this.tick();
                            int bucket = futureTick & this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$wheelMask();
                            ((TaskHolder)node.value).ticks_$eq(offset);
                            this.wheel()[bucket].addNode(node);
                        }
                    }
                }
                return;
            }

            public final void run() {
                try {
                    this.nextTick();
                    return;
                }
                catch (Throwable t) {
                    this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$log.error(t, "exception on LARS\u2019 timer thread");
                    Promise<Seq<TimerTask>> promise = this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$stopped().get();
                    if (promise == null) {
                        Thread thread = this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$threadFactory.newThread(this);
                        this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$log.info("starting new LARS thread");
                        try {
                            thread.start();
                        }
                        catch (Throwable e) {
                            this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$log.error(e, "LARS cannot start new thread, ship\u2019s going down!");
                            this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$stopped().set((Promise<Seq<TimerTask>>)Promise$.MODULE$.successful((Object)Nil$.MODULE$));
                            this.clearAll();
                        }
                        this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$timerThread_$eq(thread);
                    } else {
                        Predef$.MODULE$.assert(this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$stopped().compareAndSet(promise, (Promise<Seq<TimerTask>>)Promise$.MODULE$.successful((Object)Nil$.MODULE$)), (Function0 & Serializable)() -> "Stop signal violated in LARS");
                        promise.success(this.clearAll());
                    }
                    throw t;
                }
            }

            private final void nextTick() {
                Promise<Seq<TimerTask>> promise;
                do {
                    long time = this.$outer.clock();
                    long sleepTime = this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$start() + this.totalTick() * this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$tickNanos() - time;
                    if (sleepTime > 0L) {
                        this.checkQueue(time);
                        this.$outer.waitNanos(sleepTime);
                        continue;
                    }
                    int bucket = this.tick() & this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$wheelMask();
                    TaskQueue tasks2 = this.wheel()[bucket];
                    TaskQueue putBack = this.spareTaskQueue();
                    this.executeBucket$1(tasks2, putBack);
                    this.wheel()[bucket] = putBack;
                    this.spareTaskQueue_$eq(tasks2);
                    this.tick_$eq(this.tick() + 1);
                    this.totalTick_$eq(this.totalTick() + 1L);
                } while ((promise = this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$stopped().get()) == null);
                Predef$.MODULE$.assert(this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$stopped().compareAndSet(promise, (Promise<Seq<TimerTask>>)Promise$.MODULE$.successful((Object)Nil$.MODULE$)), (Function0 & Serializable)() -> "Stop signal violated in LARS");
                promise.success(this.clearAll());
            }

            private final Vector collect$1(TaskQueue q, Vector acc) {
                TaskHolder taskHolder;
                while ((taskHolder = (TaskHolder)q.poll()) != null) {
                    acc = (Vector)acc.$colon$plus((Object)taskHolder);
                }
                return acc;
            }

            public static final /* synthetic */ Vector $anonfun$clearAll$1($anon$3 $this, int i) {
                return $this.collect$1($this.wheel()[i], package$.MODULE$.Vector().empty());
            }

            private final void executeBucket$1(TaskQueue tasks$1, TaskQueue putBack$1) {
                AbstractNodeQueue.Node<T> node;
                while ((node = tasks$1.pollNode()) != null) {
                    TaskHolder task = (TaskHolder)node.value;
                    if (task.isCancelled()) continue;
                    if (task.ticks() >= this.$outer.WheelSize()) {
                        task.ticks_$eq(task.ticks() - this.$outer.WheelSize());
                        putBack$1.addNode(node);
                        continue;
                    }
                    task.executeTask();
                }
                return;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tick = $outer.startTick();
                this.totalTick = this.tick();
                this.wheel = (TaskQueue[])Array$.MODULE$.fill($outer.WheelSize(), (Function0 & Serializable)() -> new TaskQueue(), ClassTag$.MODULE$.apply(TaskQueue.class));
                this.spareTaskQueue = new TaskQueue();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$clearAll$1$adapted(org.apache.pekko.actor.LightArrayRevolverScheduler$$anon$3 java.lang.Object ), $anonfun$nextTick$1(), $anonfun$run$1(), $anonfun$wheel$1()}, serializedLambda);
            }
        });
        this.timerThread().start();
    }

    public static class TaskHolder
    implements TimerTask {
        private volatile Runnable task;
        private int ticks;
        private final ExecutionContext executionContext;

        public Runnable task() {
            return this.task;
        }

        public void task_$eq(Runnable x$1) {
            this.task = x$1;
        }

        public int ticks() {
            return this.ticks;
        }

        public void ticks_$eq(int x$1) {
            this.ticks = x$1;
        }

        private final Runnable extractTask(Runnable replaceWith) {
            while (true) {
                boolean bl;
                Runnable runnable = this.task();
                Runnable runnable2 = LightArrayRevolverScheduler$.org$apache$pekko$actor$LightArrayRevolverScheduler$$ExecutedTask;
                if (!(runnable2 != null ? !runnable2.equals(runnable) : runnable != null)) {
                    bl = true;
                } else {
                    Runnable runnable3 = LightArrayRevolverScheduler$.org$apache$pekko$actor$LightArrayRevolverScheduler$$CancelledTask;
                    bl = !(runnable3 != null ? !runnable3.equals(runnable) : runnable != null);
                }
                if (bl) {
                    return runnable;
                }
                if (!Unsafe.instance.compareAndSwapObject(this, LightArrayRevolverScheduler$.org$apache$pekko$actor$LightArrayRevolverScheduler$$taskOffset, runnable, replaceWith)) continue;
                return runnable;
            }
        }

        public final boolean executeTask() {
            boolean bl;
            Runnable runnable = this.extractTask(LightArrayRevolverScheduler$.org$apache$pekko$actor$LightArrayRevolverScheduler$$ExecutedTask);
            Runnable runnable2 = LightArrayRevolverScheduler$.org$apache$pekko$actor$LightArrayRevolverScheduler$$ExecutedTask;
            if (!(runnable2 != null ? !runnable2.equals(runnable) : runnable != null)) {
                bl = true;
            } else {
                Runnable runnable3 = LightArrayRevolverScheduler$.org$apache$pekko$actor$LightArrayRevolverScheduler$$CancelledTask;
                bl = !(runnable3 != null ? !runnable3.equals(runnable) : runnable != null);
            }
            if (bl) {
                return false;
            }
            try {
                this.executionContext.execute(runnable);
                return true;
            }
            catch (Throwable throwable) {
                if (throwable instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                    return false;
                }
                if (throwable != null && NonFatal$.MODULE$.apply(throwable)) {
                    this.executionContext.reportFailure(throwable);
                    return false;
                }
                throw throwable;
            }
        }

        @Override
        public void run() {
            this.extractTask(LightArrayRevolverScheduler$.org$apache$pekko$actor$LightArrayRevolverScheduler$$ExecutedTask).run();
        }

        @Override
        public boolean cancel() {
            boolean bl;
            Runnable runnable = this.extractTask(LightArrayRevolverScheduler$.org$apache$pekko$actor$LightArrayRevolverScheduler$$CancelledTask);
            Runnable runnable2 = LightArrayRevolverScheduler$.org$apache$pekko$actor$LightArrayRevolverScheduler$$ExecutedTask;
            if (!(runnable2 != null ? !runnable2.equals(runnable) : runnable != null)) {
                bl = true;
            } else {
                Runnable runnable3 = LightArrayRevolverScheduler$.org$apache$pekko$actor$LightArrayRevolverScheduler$$CancelledTask;
                bl = !(runnable3 != null ? !runnable3.equals(runnable) : runnable != null);
            }
            if (bl) {
                return false;
            }
            if (runnable instanceof SchedulerTask) {
                SchedulerTask schedulerTask = (SchedulerTask)runnable;
                this.notifyCancellation(schedulerTask);
                return true;
            }
            return true;
        }

        private void notifyCancellation(SchedulerTask task) {
            try {
                this.executionContext.execute(() -> task.cancelled());
                return;
            }
            catch (Throwable throwable) {
                if (throwable != null && NonFatal$.MODULE$.apply(throwable)) {
                    this.executionContext.reportFailure(throwable);
                    return;
                }
                throw throwable;
            }
        }

        @Override
        public boolean isCancelled() {
            return this.task() == LightArrayRevolverScheduler$.org$apache$pekko$actor$LightArrayRevolverScheduler$$CancelledTask;
        }

        public TaskHolder(Runnable task, int ticks, ExecutionContext executionContext) {
            this.task = task;
            this.ticks = ticks;
            this.executionContext = executionContext;
        }
    }

    private static class TaskQueue
    extends AbstractNodeQueue<TaskHolder> {
    }

    public static interface TimerTask
    extends Runnable,
    Cancellable {
    }
}

