/*
 * Decompiled with CFR 0.152.
 */
package org.python.icu.util;

import java.io.ObjectStreamException;
import java.lang.ref.SoftReference;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import org.python.icu.impl.CacheBase;
import org.python.icu.impl.ICUCache;
import org.python.icu.impl.ICUDebug;
import org.python.icu.impl.ICUResourceBundle;
import org.python.icu.impl.SimpleCache;
import org.python.icu.impl.SoftCache;
import org.python.icu.impl.StaticUnicodeSets;
import org.python.icu.impl.TextTrieMap;
import org.python.icu.text.CurrencyDisplayNames;
import org.python.icu.text.CurrencyMetaInfo;
import org.python.icu.text.UnicodeSet;
import org.python.icu.util.MeasureUnit;
import org.python.icu.util.ULocale;
import org.python.icu.util.UResourceBundle;

public class Currency
extends MeasureUnit {
    private static final long serialVersionUID = -5839973855554750484L;
    private static final boolean DEBUG = ICUDebug.enabled("currency");
    private static ICUCache<ULocale, List<TextTrieMap<CurrencyStringInfo>>> CURRENCY_NAME_CACHE = new SimpleCache<ULocale, List<TextTrieMap<CurrencyStringInfo>>>();
    public static final int SYMBOL_NAME = 0;
    public static final int LONG_NAME = 1;
    public static final int PLURAL_LONG_NAME = 2;
    public static final int NARROW_SYMBOL_NAME = 3;
    public static final int FORMAL_SYMBOL_NAME = 4;
    public static final int VARIANT_SYMBOL_NAME = 5;
    private static ServiceShim shim;
    private static final CacheBase<String, Currency, Void> regionCurrencyCache;
    private static final ULocale UND;
    private static final String[] EMPTY_STRING_ARRAY;
    private static final int[] POW10;
    private static SoftReference<List<String>> ALL_TENDER_CODES;
    private static SoftReference<Set<String>> ALL_CODES_AS_SET;
    private final String isoCode;

    private static ServiceShim getShim() {
        if (shim == null) {
            try {
                Class<?> cls = Class.forName("org.python.icu.util.CurrencyServiceShim");
                shim = (ServiceShim)cls.newInstance();
            }
            catch (Exception e) {
                if (DEBUG) {
                    e.printStackTrace();
                }
                throw new RuntimeException(e.getMessage());
            }
        }
        return shim;
    }

    public static Currency getInstance(Locale locale2) {
        return Currency.getInstance(ULocale.forLocale(locale2));
    }

    public static Currency getInstance(ULocale locale2) {
        String currency = locale2.getKeywordValue("currency");
        if (currency != null) {
            return Currency.getInstance(currency);
        }
        if (shim == null) {
            return Currency.createCurrency(locale2);
        }
        return shim.createInstance(locale2);
    }

    public static String[] getAvailableCurrencyCodes(ULocale loc, Date d) {
        String region = ULocale.getRegionForSupplementalData(loc, false);
        CurrencyMetaInfo.CurrencyFilter filter = CurrencyMetaInfo.CurrencyFilter.onDate(d).withRegion(region);
        List<String> list = Currency.getTenderCurrencies(filter);
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    public static String[] getAvailableCurrencyCodes(Locale loc, Date d) {
        return Currency.getAvailableCurrencyCodes(ULocale.forLocale(loc), d);
    }

    public static Set<Currency> getAvailableCurrencies() {
        CurrencyMetaInfo info = CurrencyMetaInfo.getInstance();
        List<String> list = info.currencies(CurrencyMetaInfo.CurrencyFilter.all());
        HashSet<Currency> resultSet = new HashSet<Currency>(list.size());
        for (String code2 : list) {
            resultSet.add(Currency.getInstance(code2));
        }
        return resultSet;
    }

    static Currency createCurrency(ULocale loc) {
        String key = ULocale.getRegionForSupplementalData(loc, false);
        return regionCurrencyCache.getInstance(key, null);
    }

    private static Currency loadCurrency(String key) {
        String region = key;
        CurrencyMetaInfo info = CurrencyMetaInfo.getInstance();
        List<String> list = info.currencies(CurrencyMetaInfo.CurrencyFilter.onRegion(region).withTender());
        if (list.isEmpty()) {
            list = info.currencies(CurrencyMetaInfo.CurrencyFilter.onRegion(region));
        }
        if (!list.isEmpty()) {
            String code2 = list.get(0);
            return Currency.getInstance(code2);
        }
        return null;
    }

    public static Currency getInstance(String theISOCode) {
        if (theISOCode == null) {
            throw new NullPointerException("The input currency code is null.");
        }
        if (!Currency.isAlpha3Code(theISOCode)) {
            throw new IllegalArgumentException("The input currency code is not 3-letter alphabetic code.");
        }
        return (Currency)MeasureUnit.internalGetInstance("currency", theISOCode.toUpperCase(Locale.ENGLISH));
    }

    private static boolean isAlpha3Code(String code2) {
        if (code2.length() != 3) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            char ch = code2.charAt(i);
            if (ch >= 'A' && (ch <= 'Z' || ch >= 'a') && ch <= 'z') continue;
            return false;
        }
        return true;
    }

    public static Currency fromJavaCurrency(java.util.Currency currency) {
        return Currency.getInstance(currency.getCurrencyCode());
    }

    public java.util.Currency toJavaCurrency() {
        return java.util.Currency.getInstance(this.getCurrencyCode());
    }

    public static Object registerInstance(Currency currency, ULocale locale2) {
        return Currency.getShim().registerInstance(currency, locale2);
    }

    public static boolean unregister(Object registryKey) {
        if (registryKey == null) {
            throw new IllegalArgumentException("registryKey must not be null");
        }
        if (shim == null) {
            return false;
        }
        return shim.unregister(registryKey);
    }

    public static Locale[] getAvailableLocales() {
        if (shim == null) {
            return ICUResourceBundle.getAvailableLocales();
        }
        return shim.getAvailableLocales();
    }

    public static ULocale[] getAvailableULocales() {
        if (shim == null) {
            return ICUResourceBundle.getAvailableULocales();
        }
        return shim.getAvailableULocales();
    }

    public static final String[] getKeywordValuesForLocale(String key, ULocale locale2, boolean commonlyUsed) {
        if (!"currency".equals(key)) {
            return EMPTY_STRING_ARRAY;
        }
        if (!commonlyUsed) {
            return Currency.getAllTenderCurrencies().toArray(new String[0]);
        }
        if (UND.equals(locale2)) {
            return EMPTY_STRING_ARRAY;
        }
        String prefRegion = ULocale.getRegionForSupplementalData(locale2, true);
        CurrencyMetaInfo.CurrencyFilter filter = CurrencyMetaInfo.CurrencyFilter.now().withRegion(prefRegion);
        List<String> result2 = Currency.getTenderCurrencies(filter);
        if (result2.size() == 0) {
            return EMPTY_STRING_ARRAY;
        }
        return result2.toArray(new String[result2.size()]);
    }

    public String getCurrencyCode() {
        return this.subType;
    }

    public int getNumericCode() {
        int result2 = 0;
        try {
            UResourceBundle bundle = UResourceBundle.getBundleInstance("org/python/icu/impl/data/icudt75b", "currencyNumericCodes", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
            UResourceBundle codeMap = bundle.get("codeMap");
            UResourceBundle numCode = codeMap.get(this.subType);
            result2 = numCode.getInt();
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return result2;
    }

    public String getSymbol() {
        return this.getSymbol(ULocale.getDefault(ULocale.Category.DISPLAY));
    }

    public String getSymbol(Locale loc) {
        return this.getSymbol(ULocale.forLocale(loc));
    }

    public String getSymbol(ULocale uloc) {
        return this.getName(uloc, 0, null);
    }

    public String getName(Locale locale2, int nameStyle, boolean[] isChoiceFormat) {
        return this.getName(ULocale.forLocale(locale2), nameStyle, isChoiceFormat);
    }

    public String getName(ULocale locale2, int nameStyle, boolean[] isChoiceFormat) {
        if (isChoiceFormat != null) {
            isChoiceFormat[0] = false;
        }
        CurrencyDisplayNames names = CurrencyDisplayNames.getInstance(locale2);
        switch (nameStyle) {
            case 0: {
                return names.getSymbol(this.subType);
            }
            case 3: {
                return names.getNarrowSymbol(this.subType);
            }
            case 4: {
                return names.getFormalSymbol(this.subType);
            }
            case 5: {
                return names.getVariantSymbol(this.subType);
            }
            case 1: {
                return names.getName(this.subType);
            }
        }
        throw new IllegalArgumentException("bad name style: " + nameStyle);
    }

    public String getName(Locale locale2, int nameStyle, String pluralCount, boolean[] isChoiceFormat) {
        return this.getName(ULocale.forLocale(locale2), nameStyle, pluralCount, isChoiceFormat);
    }

    public String getName(ULocale locale2, int nameStyle, String pluralCount, boolean[] isChoiceFormat) {
        if (nameStyle != 2) {
            return this.getName(locale2, nameStyle, isChoiceFormat);
        }
        if (isChoiceFormat != null) {
            isChoiceFormat[0] = false;
        }
        CurrencyDisplayNames names = CurrencyDisplayNames.getInstance(locale2);
        return names.getPluralName(this.subType, pluralCount);
    }

    public String getDisplayName() {
        return this.getName(Locale.getDefault(), 1, null);
    }

    public String getDisplayName(Locale locale2) {
        return this.getName(locale2, 1, null);
    }

    @Deprecated
    public static String parse(ULocale locale2, String text2, int type, ParsePosition pos) {
        List<TextTrieMap<CurrencyStringInfo>> currencyTrieVec = Currency.getCurrencyTrieVec(locale2);
        int maxLength = 0;
        String isoResult = null;
        TextTrieMap<CurrencyStringInfo> currencyNameTrie = currencyTrieVec.get(1);
        CurrencyNameResultHandler handler2 = new CurrencyNameResultHandler();
        currencyNameTrie.find(text2, pos.getIndex(), handler2);
        isoResult = handler2.getBestCurrencyISOCode();
        maxLength = handler2.getBestMatchLength();
        if (type != 1) {
            TextTrieMap<CurrencyStringInfo> currencySymbolTrie = currencyTrieVec.get(0);
            handler2 = new CurrencyNameResultHandler();
            currencySymbolTrie.find(text2, pos.getIndex(), handler2);
            if (handler2.getBestMatchLength() > maxLength) {
                isoResult = handler2.getBestCurrencyISOCode();
                maxLength = handler2.getBestMatchLength();
            }
        }
        int start = pos.getIndex();
        pos.setIndex(start + maxLength);
        return isoResult;
    }

    @Deprecated
    public static TextTrieMap<CurrencyStringInfo> getParsingTrie(ULocale locale2, int type) {
        List<TextTrieMap<CurrencyStringInfo>> currencyTrieVec = Currency.getCurrencyTrieVec(locale2);
        if (type == 1) {
            return currencyTrieVec.get(1);
        }
        return currencyTrieVec.get(0);
    }

    private static List<TextTrieMap<CurrencyStringInfo>> getCurrencyTrieVec(ULocale locale2) {
        List<TextTrieMap<CurrencyStringInfo>> currencyTrieVec = CURRENCY_NAME_CACHE.get(locale2);
        if (currencyTrieVec == null) {
            TextTrieMap currencyNameTrie = new TextTrieMap(true);
            TextTrieMap currencySymbolTrie = new TextTrieMap(false);
            currencyTrieVec = new ArrayList<TextTrieMap<CurrencyStringInfo>>();
            currencyTrieVec.add(currencySymbolTrie);
            currencyTrieVec.add(currencyNameTrie);
            Currency.setupCurrencyTrieVec(locale2, currencyTrieVec);
            CURRENCY_NAME_CACHE.put(locale2, currencyTrieVec);
        }
        return currencyTrieVec;
    }

    private static void setupCurrencyTrieVec(ULocale locale2, List<TextTrieMap<CurrencyStringInfo>> trieVec) {
        String isoCode;
        TextTrieMap<CurrencyStringInfo> symTrie = trieVec.get(0);
        TextTrieMap<CurrencyStringInfo> trie = trieVec.get(1);
        CurrencyDisplayNames names = CurrencyDisplayNames.getInstance(locale2);
        for (Map.Entry<String, String> e : names.symbolMap().entrySet()) {
            String symbol2 = e.getKey();
            isoCode = e.getValue();
            StaticUnicodeSets.Key key = StaticUnicodeSets.chooseCurrency(symbol2);
            CurrencyStringInfo value = new CurrencyStringInfo(isoCode, symbol2);
            if (key != null) {
                UnicodeSet equivalents = StaticUnicodeSets.get(key);
                for (String equivalentSymbol : equivalents) {
                    symTrie.put(equivalentSymbol, value);
                }
                continue;
            }
            symTrie.put(symbol2, value);
        }
        for (Map.Entry<String, String> e : names.nameMap().entrySet()) {
            String name = e.getKey();
            isoCode = e.getValue();
            trie.put(name, new CurrencyStringInfo(isoCode, name));
        }
    }

    public int getDefaultFractionDigits() {
        return this.getDefaultFractionDigits(CurrencyUsage.STANDARD);
    }

    public int getDefaultFractionDigits(CurrencyUsage Usage2) {
        CurrencyMetaInfo info = CurrencyMetaInfo.getInstance();
        CurrencyMetaInfo.CurrencyDigits digits = info.currencyDigits(this.subType, Usage2);
        return digits.fractionDigits;
    }

    public double getRoundingIncrement() {
        return this.getRoundingIncrement(CurrencyUsage.STANDARD);
    }

    public double getRoundingIncrement(CurrencyUsage Usage2) {
        CurrencyMetaInfo info = CurrencyMetaInfo.getInstance();
        CurrencyMetaInfo.CurrencyDigits digits = info.currencyDigits(this.subType, Usage2);
        int data1 = digits.roundingIncrement;
        if (data1 == 0) {
            return 0.0;
        }
        int data0 = digits.fractionDigits;
        if (data0 < 0 || data0 >= POW10.length) {
            return 0.0;
        }
        return (double)data1 / (double)POW10[data0];
    }

    @Override
    public String toString() {
        return this.subType;
    }

    protected Currency(String theISOCode) {
        super("currency", theISOCode);
        this.isoCode = theISOCode;
    }

    private static synchronized List<String> getAllTenderCurrencies() {
        List<String> all;
        List<String> list = all = ALL_TENDER_CODES == null ? null : ALL_TENDER_CODES.get();
        if (all == null) {
            CurrencyMetaInfo.CurrencyFilter filter = CurrencyMetaInfo.CurrencyFilter.all();
            all = Collections.unmodifiableList(Currency.getTenderCurrencies(filter));
            ALL_TENDER_CODES = new SoftReference<List<String>>(all);
        }
        return all;
    }

    private static synchronized Set<String> getAllCurrenciesAsSet() {
        Set<String> all;
        Set<String> set = all = ALL_CODES_AS_SET == null ? null : ALL_CODES_AS_SET.get();
        if (all == null) {
            CurrencyMetaInfo info = CurrencyMetaInfo.getInstance();
            all = Collections.unmodifiableSet(new HashSet<String>(info.currencies(CurrencyMetaInfo.CurrencyFilter.all())));
            ALL_CODES_AS_SET = new SoftReference<Set<String>>(all);
        }
        return all;
    }

    public static boolean isAvailable(String code2, Date from, Date to) {
        if (!Currency.isAlpha3Code(code2)) {
            return false;
        }
        if (from != null && to != null && from.after(to)) {
            throw new IllegalArgumentException("To is before from");
        }
        code2 = code2.toUpperCase(Locale.ENGLISH);
        boolean isKnown = Currency.getAllCurrenciesAsSet().contains(code2);
        if (!isKnown) {
            return false;
        }
        if (from == null && to == null) {
            return true;
        }
        CurrencyMetaInfo info = CurrencyMetaInfo.getInstance();
        List<String> allActive = info.currencies(CurrencyMetaInfo.CurrencyFilter.onDateRange(from, to).withCurrency(code2));
        return allActive.contains(code2);
    }

    private static List<String> getTenderCurrencies(CurrencyMetaInfo.CurrencyFilter filter) {
        CurrencyMetaInfo info = CurrencyMetaInfo.getInstance();
        return info.currencies(filter.withTender());
    }

    private Object writeReplace() throws ObjectStreamException {
        return new MeasureUnit.MeasureUnitProxy(this.type, this.subType);
    }

    private Object readResolve() throws ObjectStreamException {
        return Currency.getInstance(this.isoCode);
    }

    static {
        regionCurrencyCache = new SoftCache<String, Currency, Void>(){

            @Override
            protected Currency createInstance(String key, Void unused) {
                return Currency.loadCurrency(key);
            }
        };
        UND = new ULocale("und");
        EMPTY_STRING_ARRAY = new String[0];
        POW10 = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
    }

    private static class CurrencyNameResultHandler
    implements TextTrieMap.ResultHandler<CurrencyStringInfo> {
        private int bestMatchLength;
        private String bestCurrencyISOCode;

        private CurrencyNameResultHandler() {
        }

        @Override
        public boolean handlePrefixMatch(int matchLength, Iterator<CurrencyStringInfo> values) {
            if (values.hasNext()) {
                this.bestCurrencyISOCode = values.next().getISOCode();
                this.bestMatchLength = matchLength;
            }
            return true;
        }

        public String getBestCurrencyISOCode() {
            return this.bestCurrencyISOCode;
        }

        public int getBestMatchLength() {
            return this.bestMatchLength;
        }
    }

    @Deprecated
    public static final class CurrencyStringInfo {
        private String isoCode;
        private String currencyString;

        @Deprecated
        public CurrencyStringInfo(String isoCode, String currencyString) {
            this.isoCode = isoCode;
            this.currencyString = currencyString;
        }

        @Deprecated
        public String getISOCode() {
            return this.isoCode;
        }

        @Deprecated
        public String getCurrencyString() {
            return this.currencyString;
        }
    }

    static abstract class ServiceShim {
        ServiceShim() {
        }

        abstract ULocale[] getAvailableULocales();

        abstract Locale[] getAvailableLocales();

        abstract Currency createInstance(ULocale var1);

        abstract Object registerInstance(Currency var1, ULocale var2);

        abstract boolean unregister(Object var1);
    }

    public static enum CurrencyUsage {
        STANDARD,
        CASH;

    }
}

