/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli;

import com.xebialabs.deployit.cli.help.HelpScanner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jline.console.ConsoleReader;
import jline.console.completer.Completer;
import jline.internal.Preconditions;

public class CliCompleter
implements Completer {
    private final ConsoleReader consoleReader;

    public CliCompleter(ConsoleReader consoleReader) {
        this.consoleReader = consoleReader;
    }

    private List<CharSequence> filterStringsByBuffer(List<String> strings, String buffer) {
        ArrayList<CharSequence> candidates = new ArrayList<CharSequence>();
        if (buffer == null) {
            candidates.addAll(strings);
        } else {
            for (String match : strings) {
                if (!match.startsWith(buffer)) continue;
                candidates.add(match);
            }
        }
        return candidates;
    }

    public int complete(String buffer, int cursor, List<CharSequence> candidates) {
        Preconditions.checkNotNull(candidates);
        if (buffer == null) {
            return -1;
        }
        String phrase = buffer.substring(0, cursor);
        String[] parts = phrase.split("\\.");
        boolean completeCliObjects = parts.length == 1 && !buffer.endsWith(".");
        boolean completeCliObjectMethods = parts.length == 2 || parts.length == 1 && buffer.endsWith(".");
        boolean completeCliObjectMethodSignature = parts.length == 2 && buffer.endsWith("(");
        List<Object> completionStrings = new ArrayList<String>();
        if (completeCliObjects) {
            completionStrings.addAll(HelpScanner.loadCliObjectCompletions());
            completionStrings.addAll(Arrays.asList("help", "quit", "exit"));
            List<CharSequence> filteredStrings = this.filterStringsByBuffer(completionStrings, buffer);
            candidates.addAll(filteredStrings);
        } else if (completeCliObjectMethods) {
            String cliObjectName = parts[0];
            if (completeCliObjectMethodSignature) {
                String cliMethodName = parts[1].substring(0, parts[1].length() - 1);
                List<String> helpSuggestions = HelpScanner.loadMethodSignatureSuggestions(cliObjectName, cliMethodName);
                this.printPossibleMethodSignatures(buffer, cursor, helpSuggestions);
            } else {
                completionStrings = HelpScanner.loadObjectMethodCompletions(cliObjectName);
                if (!completionStrings.isEmpty()) {
                    completionStrings.add(cliObjectName + ".help()");
                }
            }
            List<CharSequence> filteredStrings = this.filterStringsByBuffer(completionStrings, buffer);
            candidates.addAll(filteredStrings);
            this.addOpeningBracketIfMethodFound(candidates);
        }
        return candidates.isEmpty() ? -1 : 0;
    }

    private void printPossibleMethodSignatures(String buffer, int cursor, List<String> helpSuggestions) {
        System.out.printf("\n", new Object[0]);
        for (String help : helpSuggestions) {
            System.out.printf(help, new Object[0]);
        }
        try {
            this.consoleReader.resetPromptLine(this.consoleReader.getPrompt(), buffer, cursor);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void addOpeningBracketIfMethodFound(List<CharSequence> candidates) {
        String method;
        if (candidates.size() == 1 && !(method = candidates.get(0).toString()).endsWith(")")) {
            String methodWithOpenParenthesis = String.valueOf(candidates.get(0)) + "(";
            candidates.remove(0);
            candidates.add(methodWithOpenParenthesis);
        }
    }
}

