/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.rof;

import de.schlichtherle.truezip.rof.DecoratingReadOnlyFile;
import de.schlichtherle.truezip.rof.DefaultReadOnlyFile;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class BufferedReadOnlyFile
extends DecoratingReadOnlyFile {
    private static final long INVALID = Long.MIN_VALUE;
    public static final int WINDOW_LEN = 8192;
    private long pos;
    private long bufferStart = Long.MIN_VALUE;
    private final byte[] buffer;

    protected static long min(long a, long b) {
        return a < b ? a : b;
    }

    protected static long max(long a, long b) {
        return a < b ? b : a;
    }

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public BufferedReadOnlyFile(File file) throws IOException {
        this(null, file, 8192);
    }

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public BufferedReadOnlyFile(File file, int bufferSize) throws IOException {
        this(null, file, bufferSize);
    }

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public BufferedReadOnlyFile(@WillCloseWhenClosed ReadOnlyFile rof) throws IOException {
        this(rof, null, 8192);
    }

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public BufferedReadOnlyFile(@WillCloseWhenClosed ReadOnlyFile rof, int bufferSize) throws IOException {
        this(rof, null, bufferSize);
    }

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    private BufferedReadOnlyFile(@CheckForNull @WillCloseWhenClosed ReadOnlyFile rof, @CheckForNull File file, int bufferSize) throws IOException {
        super(BufferedReadOnlyFile.check(rof, file, bufferSize));
        this.buffer = new byte[bufferSize];
    }

    private static ReadOnlyFile check(@CheckForNull @WillCloseWhenClosed ReadOnlyFile rof, @CheckForNull File file, int windowLen) throws FileNotFoundException {
        if (0 >= windowLen) {
            throw new IllegalArgumentException();
        }
        if (null != rof) {
            assert (null == file);
            return rof;
        }
        return new DefaultReadOnlyFile(file);
    }

    protected final void assertOpen() throws IOException {
        if (null == this.delegate) {
            throw new IOException("File is closed!");
        }
    }

    @Override
    public int read() throws IOException {
        this.assertOpen();
        if (this.pos >= this.delegate.length()) {
            return -1;
        }
        this.positionBuffer();
        return this.buffer[(int)(this.pos++ % (long)this.buffer.length)] & 0xFF;
    }

    @Override
    public int read(byte[] dst, int offset, int remaining) throws IOException {
        if (remaining <= 0) {
            return 0;
        }
        long length = this.length();
        if (this.getFilePointer() >= length) {
            return -1;
        }
        if (0 > (offset | remaining | dst.length - offset - remaining)) {
            throw new IndexOutOfBoundsException();
        }
        int total = 0;
        int bufferSize = this.buffer.length;
        while (total < remaining && this.pos < length) {
            this.positionBuffer();
            int bufferPos = (int)(this.pos - this.bufferStart);
            int bufferLimit = Math.min(remaining - total, bufferSize - bufferPos);
            bufferLimit = (int)Math.min((long)bufferLimit, length - this.pos);
            assert (bufferLimit > 0);
            System.arraycopy(this.buffer, bufferPos, dst, offset + total, bufferLimit);
            total += bufferLimit;
            this.pos += (long)bufferLimit;
        }
        return total;
    }

    @Override
    public long getFilePointer() throws IOException {
        this.assertOpen();
        return this.pos;
    }

    @Override
    public void seek(long pos) throws IOException {
        this.assertOpen();
        if (pos < 0L) {
            throw new IOException("File pointer must not be negative!");
        }
        long length = this.delegate.length();
        if (pos > length) {
            throw new IOException("File pointer (" + pos + ") is larger than file length (" + length + ")!");
        }
        this.pos = pos;
    }

    @Override
    public long length() throws IOException {
        this.assertOpen();
        return this.delegate.length();
    }

    @Override
    public void close() throws IOException {
        if (null == this.delegate) {
            return;
        }
        this.delegate.close();
        this.delegate = null;
    }

    private void positionBuffer() throws IOException {
        byte[] buffer = this.buffer;
        int bufferSize = buffer.length;
        long pos = this.pos;
        long bufferStart = this.bufferStart;
        long nextBufferStart = bufferStart + (long)bufferSize;
        if (bufferStart <= pos && pos < nextBufferStart) {
            return;
        }
        try {
            int read;
            ReadOnlyFile delegate = this.delegate;
            this.bufferStart = bufferStart = pos / (long)bufferSize * (long)bufferSize;
            if (bufferStart != nextBufferStart) {
                delegate.seek(bufferStart);
            }
            int total = 0;
            while ((read = delegate.read(buffer, total, bufferSize - total)) >= 0 && (total += read) < bufferSize) {
            }
        }
        catch (IOException ex) {
            this.bufferStart = Long.MIN_VALUE;
            throw ex;
        }
    }
}

