/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.spi.config;

import java.nio.file.Path;
import java.security.AccessController;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.spi.ResteasyConfiguration;
import org.jboss.resteasy.spi.config.ConfigurationFactory;
import org.jboss.resteasy.spi.config.SizeUnit;
import org.jboss.resteasy.spi.config.Threshold;
import org.jboss.resteasy.spi.util.Functions;

public class Options<T> {
    public static final Options<Boolean> ENABLE_DEFAULT_EXCEPTION_MAPPER = new Options<Boolean>("dev.resteasy.exception.mapper", Boolean.class, Functions.singleton(() -> true));
    public static final Options<Threshold> ENTITY_MEMORY_THRESHOLD = new Options<Threshold>("dev.resteasy.entity.memory.threshold", Threshold.class, Functions.singleton(() -> Threshold.of(5L, SizeUnit.MEGABYTE)));
    public static final Options<Threshold> ENTITY_FILE_THRESHOLD = new Options<Threshold>("dev.resteasy.entity.file.threshold", Threshold.class, Functions.singleton(() -> Threshold.of(50L, SizeUnit.MEGABYTE)));
    public static final Options<Path> ENTITY_TMP_DIR = new Options<Path>("dev.resteasy.entity.tmpdir", Path.class, Functions.singleton(() -> Path.of(Options.defaultTmpDir(), new String[0]).toAbsolutePath()));
    public static final Options<String> CLIENT_SSL_CONTEXT_ALGORITHM = new Options<String>("dev.resteasy.client.ssl.context.algorithm", String.class, () -> "TLS");
    public static final Options<Integer> SSE_CLOSED_RESPONSE_CODE = new Options<Integer>("dev.resteasy.sse.closed.response.code", Integer.class, Functions.singleton(() -> 204));
    private final String key;
    private final Class<T> name;
    private final Supplier<T> dftValue;

    protected Options(String key, Class<T> name, Supplier<T> dftValue) {
        this.key = key;
        this.name = name;
        this.dftValue = dftValue;
    }

    public T getValue() {
        return Options.getProperty(this.key, this.name, this.dftValue);
    }

    public T getValue(ResteasyConfiguration configuration) {
        return Options.getProperty(configuration, this.key, this.name, this.dftValue);
    }

    public String name() {
        return this.key;
    }

    public int hashCode() {
        return Objects.hash(this.key);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Options)) {
            return false;
        }
        Options other = (Options)obj;
        return Objects.equals(this.key, other.key);
    }

    public String toString() {
        return "Option[name=" + this.key + ", type=" + this.name.getName() + "]";
    }

    protected static <T> T getProperty(String name, Class<T> returnType, Supplier<T> dft) {
        return Options.getProperty(name, returnType).orElseGet(dft);
    }

    private static <T> T getProperty(ResteasyConfiguration configuration, String name, Class<T> returnType, Supplier<T> dft) {
        return Options.getProperty(configuration, name, returnType).orElseGet(dft);
    }

    private static <T> Optional<T> getProperty(String name, Class<T> returnType) {
        return Options.getProperty(null, name, returnType);
    }

    private static <T> Optional<T> getProperty(ResteasyConfiguration configuration, String name, Class<T> returnType) {
        try {
            return ConfigurationFactory.getInstance().getConfiguration(configuration).getOptionalValue(name, returnType);
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception e) {
            LogMessages.LOGGER.tracef(e, "Failed to get property for %s of type %s.", name, returnType);
            return Optional.empty();
        }
    }

    private static String defaultTmpDir() {
        if (System.getSecurityManager() == null) {
            return System.getProperty("java.io.tmpdir");
        }
        return AccessController.doPrivileged(() -> System.getProperty("java.io.tmpdir"));
    }
}

