/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.pekko.Done;
import org.apache.pekko.Done$;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Cancellable;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.CoordinatedShutdown;
import org.apache.pekko.actor.CoordinatedShutdown$ActorSystemTerminateReason$;
import org.apache.pekko.actor.CoordinatedShutdown$ClusterDowningReason$;
import org.apache.pekko.actor.CoordinatedShutdown$ClusterJoinUnsuccessfulReason$;
import org.apache.pekko.actor.CoordinatedShutdown$ClusterLeavingReason$;
import org.apache.pekko.actor.CoordinatedShutdown$IncompatibleConfigurationDetectedReason$;
import org.apache.pekko.actor.CoordinatedShutdown$JvmExitReason$;
import org.apache.pekko.actor.CoordinatedShutdown$UnknownReason$;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.Extension;
import org.apache.pekko.actor.ExtensionId;
import org.apache.pekko.actor.ExtensionIdProvider;
import org.apache.pekko.actor.JVMShutdownHooks;
import org.apache.pekko.actor.JVMShutdownHooks$;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.dispatch.ExecutionContexts$;
import org.apache.pekko.util.OptionVal$;
import org.apache.pekko.util.ccompat.package$JavaConverters$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.convert.AsScalaExtensions;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.concurrent.Await$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public final class CoordinatedShutdown$
implements ExtensionId<CoordinatedShutdown>,
ExtensionIdProvider {
    public static final CoordinatedShutdown$ MODULE$ = new CoordinatedShutdown$();
    private static final String PhaseBeforeServiceUnbind = "before-service-unbind";
    private static final String PhaseServiceUnbind = "service-unbind";
    private static final String PhaseServiceRequestsDone = "service-requests-done";
    private static final String PhaseServiceStop = "service-stop";
    private static final String PhaseBeforeClusterShutdown = "before-cluster-shutdown";
    private static final String PhaseClusterShardingShutdownRegion = "cluster-sharding-shutdown-region";
    private static final String PhaseClusterLeave = "cluster-leave";
    private static final String PhaseClusterExiting = "cluster-exiting";
    private static final String PhaseClusterExitingDone = "cluster-exiting-done";
    private static final String PhaseClusterShutdown = "cluster-shutdown";
    private static final String PhaseBeforeActorSystemTerminate = "before-actor-system-terminate";
    private static final String PhaseActorSystemTerminate = "actor-system-terminate";
    private static volatile boolean org$apache$pekko$actor$CoordinatedShutdown$$runningJvmHook = false;

    @Override
    public Extension apply(ActorSystem system) {
        return ExtensionId.apply$((ExtensionId)this, system);
    }

    @Override
    public Extension apply(ClassicActorSystemProvider system) {
        return ExtensionId.apply$((ExtensionId)this, system);
    }

    @Override
    public final int hashCode() {
        return ExtensionId.hashCode$(this);
    }

    @Override
    public final boolean equals(Object other) {
        return ExtensionId.equals$(this, other);
    }

    public JVMShutdownHooks $lessinit$greater$default$3() {
        return JVMShutdownHooks$.MODULE$;
    }

    public String PhaseBeforeServiceUnbind() {
        return PhaseBeforeServiceUnbind;
    }

    public String PhaseServiceUnbind() {
        return PhaseServiceUnbind;
    }

    public String PhaseServiceRequestsDone() {
        return PhaseServiceRequestsDone;
    }

    public String PhaseServiceStop() {
        return PhaseServiceStop;
    }

    public String PhaseBeforeClusterShutdown() {
        return PhaseBeforeClusterShutdown;
    }

    public String PhaseClusterShardingShutdownRegion() {
        return PhaseClusterShardingShutdownRegion;
    }

    public String PhaseClusterLeave() {
        return PhaseClusterLeave;
    }

    public String PhaseClusterExiting() {
        return PhaseClusterExiting;
    }

    public String PhaseClusterExitingDone() {
        return PhaseClusterExitingDone;
    }

    public String PhaseClusterShutdown() {
        return PhaseClusterShutdown;
    }

    public String PhaseBeforeActorSystemTerminate() {
        return PhaseBeforeActorSystemTerminate;
    }

    public String PhaseActorSystemTerminate() {
        return PhaseActorSystemTerminate;
    }

    public CoordinatedShutdown.Reason unknownReason() {
        return CoordinatedShutdown$UnknownReason$.MODULE$;
    }

    public CoordinatedShutdown.Reason actorSystemTerminateReason() {
        return CoordinatedShutdown$ActorSystemTerminateReason$.MODULE$;
    }

    public CoordinatedShutdown.Reason jvmExitReason() {
        return CoordinatedShutdown$JvmExitReason$.MODULE$;
    }

    public CoordinatedShutdown.Reason clusterDowningReason() {
        return CoordinatedShutdown$ClusterDowningReason$.MODULE$;
    }

    public CoordinatedShutdown.Reason clusterJoinUnsuccessfulReason() {
        return CoordinatedShutdown$ClusterJoinUnsuccessfulReason$.MODULE$;
    }

    public CoordinatedShutdown.Reason incompatibleConfigurationDetectedReason() {
        return CoordinatedShutdown$IncompatibleConfigurationDetectedReason$.MODULE$;
    }

    public CoordinatedShutdown.Reason clusterLeavingReason() {
        return CoordinatedShutdown$ClusterLeavingReason$.MODULE$;
    }

    public boolean org$apache$pekko$actor$CoordinatedShutdown$$runningJvmHook() {
        return org$apache$pekko$actor$CoordinatedShutdown$$runningJvmHook;
    }

    private void runningJvmHook_$eq(boolean x$1) {
        org$apache$pekko$actor$CoordinatedShutdown$$runningJvmHook = x$1;
    }

    @Override
    public CoordinatedShutdown get(ActorSystem system) {
        return (CoordinatedShutdown)ExtensionId.get$((ExtensionId)this, system);
    }

    @Override
    public CoordinatedShutdown get(ClassicActorSystemProvider system) {
        return (CoordinatedShutdown)ExtensionId.get$((ExtensionId)this, system);
    }

    public CoordinatedShutdown$ lookup() {
        return this;
    }

    @Override
    public CoordinatedShutdown createExtension(ExtendedActorSystem system) {
        Config conf = system.settings().config().getConfig("pekko.coordinated-shutdown");
        scala.collection.immutable.Map<String, CoordinatedShutdown.Phase> phases = this.phasesFromConfig(conf);
        CoordinatedShutdown coord = new CoordinatedShutdown(system, phases, JVMShutdownHooks$.MODULE$);
        this.init(system, conf, coord);
        return coord;
    }

    @InternalApi
    public Config confWithOverrides(Config conf, Option<CoordinatedShutdown.Reason> reason) {
        return (Config)reason.flatMap((Function1 & Serializable)r -> {
            String basePath = new StringBuilder(19).append("reason-overrides.\"").append(r.getClass().getName()).append("\"").toString();
            if (conf.hasPath(basePath)) {
                return new Some((Object)conf.getConfig(basePath).withFallback((ConfigMergeable)conf));
            }
            return None$.MODULE$;
        }).getOrElse((Function0 & Serializable)() -> conf);
    }

    @InternalApi
    public void init(ExtendedActorSystem system, Config conf, CoordinatedShutdown coord) {
        this.initPhaseActorSystemTerminate(system, conf, coord);
        this.initJvmHook(system, conf, coord);
        try {
            system.registerOnTermination((JFunction0.mcV.sp & Serializable)() -> this.cleanupActorSystemJvmHook$1(coord));
            return;
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            this.cleanupActorSystemJvmHook$1(coord);
            return;
        }
    }

    private void initPhaseActorSystemTerminate(ExtendedActorSystem system, Config conf, CoordinatedShutdown coord) {
        coord.addTask(this.PhaseActorSystemTerminate(), "terminate-system", (Function0<Future<Done>>)(Function0 & Serializable)() -> {
            Config confForReason = MODULE$.confWithOverrides(conf, coord.shutdownReason());
            boolean terminateActorSystem = confForReason.getBoolean("terminate-actor-system");
            boolean exitJvm = confForReason.getBoolean("exit-jvm");
            int exitCode = confForReason.getInt("exit-code");
            if (exitJvm && terminateActorSystem) {
                FiniteDuration timeout = coord.timeout(MODULE$.PhaseActorSystemTerminate());
                Thread t = new Thread(system, timeout, exitCode){
                    private final ExtendedActorSystem system$1;
                    private final FiniteDuration timeout$1;
                    private final int exitCode$1;

                    public void run() {
                        if (Try$.MODULE$.apply((Function0 & Serializable)() -> (Future)Await$.MODULE$.ready($this.system$1.whenTerminated(), (Duration)$this.timeout$1)).isFailure() && !CoordinatedShutdown$.MODULE$.org$apache$pekko$actor$CoordinatedShutdown$$runningJvmHook()) {
                            System.exit(this.exitCode$1);
                            return;
                        }
                    }
                    {
                        this.system$1 = system$1;
                        this.timeout$1 = timeout$1;
                        this.exitCode$1 = exitCode$1;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(org.apache.pekko.actor.CoordinatedShutdown$$anon$1 )}, serializedLambda);
                    }
                };
                t.setName("CoordinatedShutdown-exit");
                t.start();
            }
            if (terminateActorSystem) {
                system.finalTerminate();
                return system.whenTerminated().map((Function1 & Serializable)x$1 -> {
                    if (exitJvm && !MODULE$.org$apache$pekko$actor$CoordinatedShutdown$$runningJvmHook()) {
                        System.exit(exitCode);
                    }
                    return Done$.MODULE$;
                }, ExecutionContexts$.MODULE$.parasitic());
            }
            if (exitJvm) {
                System.exit(exitCode);
                return Future$.MODULE$.successful((Object)Done$.MODULE$);
            }
            return Future$.MODULE$.successful((Object)Done$.MODULE$);
        });
    }

    private void initJvmHook(ActorSystem system, Config conf, CoordinatedShutdown coord) {
        if (system.settings().JvmShutdownHooks() && conf.getBoolean("run-by-jvm-shutdown-hook")) {
            coord.org$apache$pekko$actor$CoordinatedShutdown$$actorSystemJvmHook_$eq(coord.addCancellableJvmShutdownHook((Function0 & Serializable)() -> {
                MODULE$.runningJvmHook_$eq(true);
                if (!system.whenTerminated().isCompleted()) {
                    coord.log().debug("Starting coordinated shutdown from JVM shutdown hook");
                    try {
                        FiniteDuration totalTimeout = coord.totalTimeout().max(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(3)).seconds());
                        CoordinatedShutdown$JvmExitReason$ run_reason = CoordinatedShutdown$JvmExitReason$.MODULE$;
                        Object var4_3 = null;
                        return Await$.MODULE$.ready(coord.run((CoordinatedShutdown.Reason)run_reason, (Option<String>)None$.MODULE$), (Duration)totalTimeout);
                    }
                    catch (Throwable throwable) {
                        if (throwable != null && NonFatal$.MODULE$.apply(throwable)) {
                            coord.log().warning("CoordinatedShutdown from JVM shutdown failed: {}", (Object)throwable.getMessage());
                            return BoxedUnit.UNIT;
                        }
                        throw throwable;
                    }
                }
                return BoxedUnit.UNIT;
            }));
            return;
        }
    }

    public scala.collection.immutable.Map<String, CoordinatedShutdown.Phase> phasesFromConfig(Config conf) {
        String defaultPhaseTimeout = conf.getString("default-phase-timeout");
        Config phasesConf = conf.getConfig("phases");
        Config defaultPhaseConfig = ConfigFactory.parseString((String)new StringBuilder(86).append("\n      timeout = ").append(defaultPhaseTimeout).append("\n      recover = true\n      enabled = true\n      depends-on = []\n    ").toString());
        return (scala.collection.immutable.Map)AsScalaExtensions.MapHasAsScala$((AsScalaExtensions)package$JavaConverters$.MODULE$, (Map)phasesConf.root().unwrapped()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String k = (String)x0$1._1();
                if (x0$1._2() instanceof Map) {
                    Config c = phasesConf.getConfig(k).withFallback((ConfigMergeable)defaultPhaseConfig);
                    Set dependsOn = AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)package$JavaConverters$.MODULE$, (java.util.List)c.getStringList("depends-on")).asScala().toSet();
                    FiniteDuration timeout = new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(c.getDuration("timeout", TimeUnit.MILLISECONDS))).millis();
                    boolean recover = c.getBoolean("recover");
                    boolean enabled = c.getBoolean("enabled");
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)new CoordinatedShutdown.Phase((Set<String>)dependsOn, timeout, recover, enabled));
                }
            }
            if (x0$1 != null) {
                String k = (String)x0$1._1();
                Object v = x0$1._2();
                throw new IllegalArgumentException(new StringBuilder(36).append("Expected object value for [").append(k).append("], got [").append(v).append("]").toString());
            }
            throw new MatchError(null);
        });
    }

    public List<String> topologicalSort(scala.collection.immutable.Map<String, CoordinatedShutdown.Phase> phases) {
        ObjectRef result = ObjectRef.create((Object)package$.MODULE$.List().empty());
        ObjectRef unmarked = ObjectRef.create((Object)((Set)phases.keySet().$plus$plus((IterableOnce)phases.values().flatMap((Function1 & Serializable)x$2 -> x$2.dependsOn()))));
        ObjectRef tempMark = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
        while (((Set)unmarked.elem).nonEmpty()) {
            Option option;
            String depthFirstSearch$1_u = (String)((Set)unmarked.elem).head();
            if (((Set)tempMark.elem).apply((Object)depthFirstSearch$1_u)) {
                throw new IllegalArgumentException(new StringBuilder(112).append("Cycle detected in graph of phases. It must be a DAG. ").append("phase [").append(depthFirstSearch$1_u).append("] depends transitively on itself. All dependencies: ").append(phases).toString());
            }
            if (((Set)unmarked.elem).apply((Object)depthFirstSearch$1_u)) {
                tempMark.elem = (Set)((Set)tempMark.elem).$plus((Object)depthFirstSearch$1_u);
                option = phases.get((Object)depthFirstSearch$1_u);
                if (option instanceof Some) {
                    ((CoordinatedShutdown.Phase)((Some)option).value()).dependsOn().foreach((Function1 & Serializable)u -> {
                        CoordinatedShutdown$.depthFirstSearch$1(u, tempMark, phases, unmarked, result);
                        return BoxedUnit.UNIT;
                    });
                } else if (!None$.MODULE$.equals(option)) {
                    throw new MatchError((Object)option);
                }
                unmarked.elem = (Set)((Set)unmarked.elem).$minus((Object)depthFirstSearch$1_u);
                tempMark.elem = (Set)((Set)tempMark.elem).$minus((Object)depthFirstSearch$1_u);
                result.elem = ((List)result.elem).$colon$colon((Object)depthFirstSearch$1_u);
            }
            Object var5_5 = null;
            option = null;
        }
        return ((List)result.elem).reverse();
    }

    private final void cleanupActorSystemJvmHook$1(CoordinatedShutdown coord$1) {
        Cancellable cancellable = coord$1.org$apache$pekko$actor$CoordinatedShutdown$$actorSystemJvmHook();
        if (!OptionVal$.MODULE$.isEmpty$extension(cancellable)) {
            Cancellable cancellable2 = OptionVal$.MODULE$.get$extension(cancellable);
            if (!this.org$apache$pekko$actor$CoordinatedShutdown$$runningJvmHook() && !cancellable2.isCancelled()) {
                cancellable2.cancel();
                OptionVal$.MODULE$.None();
                coord$1.org$apache$pekko$actor$CoordinatedShutdown$$actorSystemJvmHook_$eq(null);
                return;
            }
        }
    }

    private static final void depthFirstSearch$1(String u2, ObjectRef tempMark$1, scala.collection.immutable.Map phases$1, ObjectRef unmarked$1, ObjectRef result$1) {
        if (((Set)tempMark$1.elem).apply((Object)u2)) {
            throw new IllegalArgumentException(new StringBuilder(112).append("Cycle detected in graph of phases. It must be a DAG. ").append("phase [").append(u2).append("] depends transitively on itself. All dependencies: ").append(phases$1).toString());
        }
        if (((Set)unmarked$1.elem).apply((Object)u2)) {
            tempMark$1.elem = (Set)((Set)tempMark$1.elem).$plus((Object)u2);
            Option option = phases$1.get((Object)u2);
            if (option instanceof Some) {
                ((CoordinatedShutdown.Phase)((Some)option).value()).dependsOn().foreach((Function1 & Serializable)u -> {
                    CoordinatedShutdown$.depthFirstSearch$1(u, tempMark, phases, unmarked, result);
                    return BoxedUnit.UNIT;
                });
            } else if (!None$.MODULE$.equals(option)) {
                throw new MatchError((Object)option);
            }
            unmarked$1.elem = (Set)((Set)unmarked$1.elem).$minus((Object)u2);
            tempMark$1.elem = (Set)((Set)tempMark$1.elem).$minus((Object)u2);
            result$1.elem = ((List)result$1.elem).$colon$colon((Object)u2);
            return;
        }
    }

    private CoordinatedShutdown$() {
    }
}

