/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.util;

import jakarta.ws.rs.core.MultivaluedMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class HeaderHelper {
    private static final Pattern DEFAULT_PATTERN = Pattern.compile(",");
    private static final Cache PATTERN_CACHE = new Cache(10);

    public static boolean containsHeaderString(String value, String valueSeparatorRegex, Predicate<String> valuePredicate) {
        if (value == null) {
            return false;
        }
        Stream<String> parts = valueSeparatorRegex == null ? Stream.of(value) : (",".equals(valueSeparatorRegex) ? DEFAULT_PATTERN.splitAsStream(value) : PATTERN_CACHE.computeIfAbsent(valueSeparatorRegex, v -> Pattern.compile(valueSeparatorRegex)).splitAsStream(value));
        return parts.map(String::trim).anyMatch(Objects.requireNonNull(valuePredicate));
    }

    public static void setAllow(MultivaluedMap<String, Object> headers, String[] methods) {
        if (methods == null) {
            headers.remove((Object)"Allow");
            return;
        }
        StringBuilder builder = new StringBuilder();
        boolean isFirst = true;
        for (String l : methods) {
            if (isFirst) {
                isFirst = false;
            } else {
                builder.append(", ");
            }
            builder.append(l);
        }
        headers.putSingle((Object)"Allow", (Object)builder.toString());
    }

    public static void setAllow(MultivaluedMap<String, Object> headers, Set<String> methods) {
        if (methods == null) {
            headers.remove((Object)"Allow");
            return;
        }
        StringBuilder builder = new StringBuilder();
        boolean isFirst = true;
        for (String l : methods) {
            if (isFirst) {
                isFirst = false;
            } else {
                builder.append(", ");
            }
            builder.append(l);
        }
        headers.putSingle((Object)"Allow", (Object)builder.toString());
    }

    private static class Cache
    extends LinkedHashMap<String, Pattern> {
        private final int limit;
        private final ReadWriteLock lock;

        Cache(int limit) {
            super(limit + 1);
            this.limit = limit;
            this.lock = new ReentrantReadWriteLock();
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Pattern> eldest) {
            return this.size() > this.limit;
        }

        @Override
        public Pattern get(Object key) {
            this.lock.readLock().lock();
            try {
                Pattern pattern = (Pattern)super.get(key);
                return pattern;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Pattern put(String key, Pattern value) {
            this.lock.writeLock().lock();
            try {
                Pattern pattern = super.put(key, value);
                return pattern;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }
}

