/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.io;

import com.xebialabs.deployit.io.ArtifactAwareFile;
import com.xebialabs.deployit.io.ArtifactFile;
import com.xebialabs.deployit.io.copy.ArchiveOptions;
import com.xebialabs.deployit.io.copy.ArtifactCopier;
import com.xebialabs.deployit.io.copy.CopyUtil;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.DerivedArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.FolderArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployableFolderArtifact;
import com.xebialabs.deployit.util.StreamFactoryUtil;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.local.LocalFile;
import com.xebialabs.xldeploy.packager.io.StreamerFactory;
import com.xebialabs.xldeploy.packager.placeholders.DerivedArtifactEnricher;
import com.xebialabs.xldeploy.packager.placeholders.PlaceholdersUtil;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DerivedArtifactFile
extends ArtifactFile
implements ArtifactAwareFile,
Serializable {
    private static final Logger logger = LoggerFactory.getLogger(DerivedArtifactFile.class);
    private final DerivedArtifact<? extends SourceArtifact> derivedArtifact;
    private transient OverthereFile resolvedFile;

    public DerivedArtifactFile(DerivedArtifact<? extends SourceArtifact> derivedArtifact) {
        this.derivedArtifact = derivedArtifact;
    }

    @Override
    public boolean isResolvable() {
        return this.derivedArtifact.getSourceArtifact() != null && this.derivedArtifact.getSourceArtifact().getFile() != null;
    }

    @Override
    public InputStream getRawStream() {
        throw new UnsupportedOperationException("Raw stream is not available on derived artifact. Use source artifact or use input stream");
    }

    @Override
    protected synchronized OverthereFile getLazyFile() {
        if (this.resolvedFile == null) {
            if (this.derivedArtifact.getPlaceholders().isEmpty()) {
                this.resolvedFile = LocalFile.valueOf((File)new PlaceholdersUtil.SourceArtifactUtil(this.derivedArtifact.getSourceArtifact()).toLocalFile());
                logger.debug("Placeholders does not exist using file {} from artifact {}", this.derivedArtifact, (Object)this.resolvedFile);
            } else {
                logger.debug("Creating derived file for {}", this.derivedArtifact);
                StreamerFactory streamFactory = StreamFactoryUtil.fetchStreamFactory();
                DerivedArtifactEnricher dae = DerivedArtifactEnricher.apply(this.derivedArtifact, (StreamerFactory)streamFactory);
                this.resolvedFile = dae.createDerivedFile();
                logger.debug("Derived file for {} created: {}", this.derivedArtifact, (Object)this.resolvedFile);
            }
        }
        return this.resolvedFile;
    }

    protected synchronized OverthereFile getLazyFileForZos(DerivedArtifactEnricher dae) {
        if (this.resolvedFile == null) {
            logger.debug("Creating zos derived enrich file for {}", this.derivedArtifact);
            this.resolvedFile = dae.createDerivedFile();
            logger.debug("Derived zos derived enrich for {} created: {}", this.derivedArtifact, (Object)this.resolvedFile);
        }
        return this.resolvedFile;
    }

    @Override
    public Artifact underlyingArtifact() {
        return this.derivedArtifact;
    }

    @Override
    public String getName() {
        if (this.isResolvable()) {
            return this.derivedArtifact.getSourceArtifact().getFile().getName();
        }
        throw new RuntimeException("File name is not available because source artifact is not set");
    }

    @Override
    public boolean isFile() {
        return !this.isDirectory();
    }

    @Override
    public boolean isDirectory() {
        return this.derivedArtifact.getSourceArtifact() instanceof FolderArtifact;
    }

    @Override
    public boolean isResolved() {
        return this.resolvedFile != null;
    }

    @Override
    public void copyTo(OverthereFile dest) {
        DerivedArtifactEnricher dae = DerivedArtifactEnricher.apply(this.derivedArtifact, (StreamerFactory)StreamFactoryUtil.fetchStreamFactory(), (OverthereFile)dest);
        if (dae.getTranscodeSpec().isDestinationHostRequireTranscodeToEbcdic()) {
            ArtifactCopier.copyWithConfig((LocalFile)this.getLazyFileForZos(dae), dest, new HashMap<String, String>(), this.newArchiveOptionsFromDerivedSourceArtifact());
        } else {
            ArtifactCopier.copyWithConfig((LocalFile)this.getLazyFile(), dest, new HashMap<String, String>(), this.newArchiveOptionsFromDerivedSourceArtifact());
        }
    }

    @Override
    public void copyToWithConfig(OverthereFile dest, Map<String, String> config) {
        ArchiveOptions archiveOptions = this.newArchiveOptionsFromDerivedSourceArtifact();
        DerivedArtifactEnricher dae = DerivedArtifactEnricher.apply(this.derivedArtifact, (StreamerFactory)StreamFactoryUtil.fetchStreamFactory(), (OverthereFile)dest);
        LocalFile lazyFile = dae.getTranscodeSpec().isDestinationHostRequireTranscodeToEbcdic() ? (LocalFile)this.getLazyFileForZos(dae) : (LocalFile)this.getLazyFile();
        ArtifactCopier.copyWithConfig(lazyFile, dest, config, archiveOptions);
    }

    public ArchiveOptions newArchiveOptionsFromDerivedSourceArtifact() {
        logger.debug("getArchiveOptions() - derivedArtifact: {}", (Object)this.derivedArtifact.getId());
        SourceArtifact sa = this.derivedArtifact.getSourceArtifact();
        ArchiveOptions archiveOptions = ArchiveOptions.newDefaultInstance();
        if (sa instanceof BaseDeployableFolderArtifact) {
            BaseDeployableFolderArtifact bfa = (BaseDeployableFolderArtifact)sa;
            if (this.isDeployableFileFolder(bfa)) {
                archiveOptions = CopyUtil.newArchiveOptionsForFolder(bfa, this.getStripComponentsDerived(), this.getMembersDerived());
            } else {
                archiveOptions = CopyUtil.newArchiveOptionsFromDefaultCopyStrategy(bfa);
                logger.debug("getArchiveOptions() - not BaseDeployableFolderArtifact, using default ArchiveOptions: {}", (Object)archiveOptions);
            }
        }
        return archiveOptions;
    }

    protected boolean isDeployableFileFolder(BaseDeployableFolderArtifact bfa) {
        return CopyUtil.isDeployableFileFolder(bfa);
    }

    private Set<String> getMembersDerived() {
        return this.derivedArtifact.hasProperty("members") ? (Set)this.derivedArtifact.getProperty("members") : Collections.emptySet();
    }

    private Integer getStripComponentsDerived() {
        return this.derivedArtifact.hasProperty("stripComponents") ? Integer.parseInt(this.derivedArtifact.getProperty("stripComponents").toString()) : 0;
    }
}

