/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.io;

import com.xebialabs.deployit.exception.RuntimeIOException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OneShotFileBackedOutputStream
extends OutputStream {
    private final int fileThreshold;
    private final boolean resetOnFinalize;
    private final Supplier<InputStream> supplier;
    private OutputStream out;
    private MemoryOutput memory;
    private File file;
    private static final Logger logger = LoggerFactory.getLogger(OneShotFileBackedOutputStream.class);

    synchronized File getFile() {
        return this.file;
    }

    public OneShotFileBackedOutputStream(int fileThreshold) {
        this(fileThreshold, false);
    }

    public OneShotFileBackedOutputStream(int fileThreshold, boolean resetOnFinalize) {
        this.fileThreshold = fileThreshold;
        this.resetOnFinalize = resetOnFinalize;
        this.memory = new MemoryOutput();
        this.out = this.memory;
        this.supplier = resetOnFinalize ? () -> {
            try {
                return this._openStream();
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        } : () -> {
            try {
                return this._openStream();
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        };
    }

    public Supplier<InputStream> getSupplier() {
        return this.supplier;
    }

    private synchronized InputStream _openStream() throws IOException {
        if (this.file != null) {
            return new FileInputStream(this.file){

                @Override
                public void close() throws IOException {
                    super.close();
                    if (OneShotFileBackedOutputStream.this.file.exists()) {
                        logger.debug("Deleting temporary file [{}]", (Object)OneShotFileBackedOutputStream.this.file);
                        if (!OneShotFileBackedOutputStream.this.file.delete()) {
                            logger.debug("Couldn't delete temporary file [{}] will be deleted on exit", (Object)OneShotFileBackedOutputStream.this.file);
                        }
                    }
                }
            };
        }
        return new ByteArrayInputStream(this.memory.getBuffer(), 0, this.memory.getCount());
    }

    public synchronized void reset() throws IOException {
        try {
            this.close();
        }
        finally {
            if (this.memory == null) {
                this.memory = new MemoryOutput();
            } else {
                this.memory.reset();
            }
            this.out = this.memory;
            if (this.file != null) {
                File deleteMe = this.file;
                this.file = null;
                if (!deleteMe.delete()) {
                    throw new IOException("Could not delete: " + String.valueOf(deleteMe));
                }
            }
        }
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.update(1);
        this.out.write(b);
    }

    @Override
    public synchronized void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        this.update(len);
        this.out.write(b, off, len);
    }

    @Override
    public synchronized void close() throws IOException {
        this.out.close();
    }

    @Override
    public synchronized void flush() throws IOException {
        this.out.flush();
    }

    private void update(int len) throws IOException {
        if (this.file == null && this.memory.getCount() + len > this.fileThreshold) {
            File temp = File.createTempFile("FileBackedOutputStream", null);
            logger.debug("Creating temporary file [{}]", (Object)temp);
            if (this.resetOnFinalize) {
                temp.deleteOnExit();
            }
            FileOutputStream transfer = new FileOutputStream(temp);
            transfer.write(this.memory.getBuffer(), 0, this.memory.getCount());
            transfer.flush();
            this.out = transfer;
            this.file = temp;
            this.memory = null;
        }
    }

    private static class MemoryOutput
    extends ByteArrayOutputStream {
        private MemoryOutput() {
        }

        byte[] getBuffer() {
            return this.buf;
        }

        int getCount() {
            return this.count;
        }
    }
}

