/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.access.expression;

import org.jspecify.annotations.Nullable;
import org.springframework.security.access.expression.AbstractSecurityExpressionHandler;
import org.springframework.security.access.expression.SecurityExpressionHandler;
import org.springframework.security.access.expression.SecurityExpressionOperations;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.expression.FilterInvocationExpressionRoot;

public class DefaultWebSecurityExpressionHandler
extends AbstractSecurityExpressionHandler<FilterInvocation>
implements SecurityExpressionHandler<FilterInvocation> {
    private static final String DEFAULT_ROLE_PREFIX = "ROLE_";
    private String defaultRolePrefix = "ROLE_";

    protected SecurityExpressionOperations createSecurityExpressionRoot(@Nullable Authentication authentication, FilterInvocation fi) {
        FilterInvocationExpressionRoot root = new FilterInvocationExpressionRoot(() -> authentication, fi);
        root.setAuthorizationManagerFactory(this.getAuthorizationManagerFactory());
        root.setPermissionEvaluator(this.getPermissionEvaluator());
        if (!DEFAULT_ROLE_PREFIX.equals(this.defaultRolePrefix)) {
            root.setDefaultRolePrefix(this.defaultRolePrefix);
        }
        return root;
    }

    @Deprecated(since="7.0")
    public void setTrustResolver(AuthenticationTrustResolver trustResolver) {
        this.getDefaultAuthorizationManagerFactory().setTrustResolver(trustResolver);
    }

    @Deprecated(since="7.0")
    public void setDefaultRolePrefix(@Nullable String defaultRolePrefix) {
        if (defaultRolePrefix == null) {
            defaultRolePrefix = "";
        }
        this.getDefaultAuthorizationManagerFactory().setRolePrefix(defaultRolePrefix);
        this.defaultRolePrefix = defaultRolePrefix;
    }
}

