/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.udm.base;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.artifact.FolderArtifact;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployableArtifact;
import com.xebialabs.deployit.plugin.file.FileCopyStrategy;
import com.xebialabs.deployit.plugin.overthere.DefaultCopyStrategyName;
import com.xebialabs.overthere.OverthereFile;
import java.util.ArrayList;
import java.util.List;

@Metadata(virtual=true, description="A folder artifact that can be deployed")
public class BaseDeployableFolderArtifact
extends BaseDeployableArtifact
implements FolderArtifact {
    @Property(required=false, label="Default Copy Strategy", description="Default copy strategy for this folder artifact.")
    private FileCopyStrategy defaultCopyStrategy;
    @Property(required=false, description="Force Archive", defaultValue="true", hidden=true)
    private boolean isForceArchive;
    @Property(hidden=true, category="Deployment", description="Regular expression that matches file names of executable files. Matching files receive 0755 permissions when permissions are not available in the source archive entry stream.", defaultValue=".+\\.(sh | bat | exe | bin | py | app | cmd | pkg | run | bash | ps1)")
    private String executableFileNamesRegex;

    public List<OverthereFile> getFiles() {
        List allFiles;
        ArrayList<OverthereFile> files = new ArrayList<OverthereFile>();
        OverthereFile folderLocation = this.getFile();
        if (folderLocation.exists() && folderLocation.isDirectory() && folderLocation.canRead() && (allFiles = folderLocation.listFiles()) != null) {
            files.addAll(allFiles);
        }
        return files;
    }

    public FileCopyStrategy getDefaultCopyStrategy() {
        return this.defaultCopyStrategy;
    }

    public void setDefaultCopyStrategy(FileCopyStrategy defaultCopyStrategy) {
        this.defaultCopyStrategy = defaultCopyStrategy;
    }

    public DefaultCopyStrategyName getDefaultCopyStrategyName() {
        return this.defaultCopyStrategy != null ? (DefaultCopyStrategyName)((Object)this.defaultCopyStrategy.getProperty("defaultCopyStrategy")) : null;
    }

    public String getDefaultCopyStrategyNameAsValue() {
        DefaultCopyStrategyName defaultCopyStrategyName = this.getDefaultCopyStrategyName();
        return defaultCopyStrategyName != null ? defaultCopyStrategyName.toString() : "";
    }

    public boolean isForceArchive() {
        return this.isForceArchive;
    }

    public void setForceArchive(boolean forceArchive) {
        this.isForceArchive = forceArchive;
    }

    public String getExecutableFileNamesRegex() {
        return this.executableFileNamesRegex;
    }

    public void setExecutableFileNamesRegex(String executableFileNamesRegex) {
        this.executableFileNamesRegex = executableFileNamesRegex;
    }
}

