/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.concurrent.CompletionStage;
import org.jboss.resteasy.plugins.providers.AbstractDiskIoProvider;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.spi.AsyncOutputStream;
import org.jboss.resteasy.util.MediaTypeHelper;

@Provider
@Produces(value={"*/*"})
@Consumes(value={"*/*"})
public class PathProvider
extends AbstractDiskIoProvider<Path> {
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Path.class.isAssignableFrom(type);
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Path.class.isAssignableFrom(type) && !MediaTypeHelper.isBlacklisted(mediaType);
    }

    public long getSize(Path path, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.getPathSize(path);
    }

    public Path readFrom(Class<Path> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        LogMessages.LOGGER.debugf("Provider : %s,  Method : readFrom", (Object)this.getClass().getName());
        return this.readFromStream(httpHeaders, entityStream);
    }

    public CompletionStage<Void> asyncWriteTo(Path path, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, AsyncOutputStream entityStream) {
        return this.asyncWriteToStream(path, mediaType, httpHeaders, entityStream);
    }

    public void writeTo(Path path, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        this.writeToStream(path, mediaType, httpHeaders, entityStream);
    }
}

