/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.servlet;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.ws.rs.core.Application;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.jboss.resteasy.core.ApplicationDescription;
import org.jboss.resteasy.plugins.server.servlet.ListenerBootstrap;
import org.jboss.resteasy.spi.ResteasyDeployment;

public class ServletBootstrap
extends ListenerBootstrap {
    private final ServletConfig config;

    public ServletBootstrap(ServletConfig config) {
        super(config.getServletContext());
        this.config = config;
    }

    @Override
    public ResteasyDeployment createDeployment() {
        ResteasyDeployment deployment = super.createDeployment();
        deployment.getDefaultContextObjects().put(ServletConfig.class, this.config);
        deployment.getDefaultContextObjects().put(ServletContext.class, this.config.getServletContext());
        String application = this.getParameter(Application.class.getName());
        if (application == null) {
            application = this.getParameter("jakarta.ws.rs.Application");
        }
        if (application == null && Application.class.getName().equals(this.config.getServletName())) {
            String servletMappingPrefix = this.getParameter("resteasy.servlet.mapping.prefix");
            if (servletMappingPrefix == null) {
                servletMappingPrefix = "";
            }
            ApplicationDescription description = ApplicationDescription.Builder.of(new Application()).path(servletMappingPrefix.trim()).build();
            deployment.getDefaultContextObjects().put(ApplicationDescription.class, description);
        }
        return deployment;
    }

    @Override
    public String getInitParameter(String name) {
        String value = this.config.getInitParameter(name);
        if (value == null) {
            value = super.getInitParameter(name);
        }
        return value;
    }

    @Override
    public Set<String> getParameterNames() {
        Set<String> set = super.getServletContextNames();
        Enumeration en = this.config.getInitParameterNames();
        while (en.hasMoreElements()) {
            set.add((String)en.nextElement());
        }
        return set;
    }

    @Override
    public String getParameter(String name) {
        String value = super.getParameter(name);
        if (value == null) {
            value = this.config.getServletContext().getInitParameter(name);
        }
        return value;
    }

    @Override
    public Set<String> getInitParameterNames() {
        HashSet<String> set = new HashSet<String>();
        Enumeration en = this.config.getInitParameterNames();
        while (en.hasMoreElements()) {
            set.add((String)en.nextElement());
        }
        return set;
    }
}

