/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.engines;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.function.Supplier;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.jboss.resteasy.client.jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.EntityOutputStream;
import org.jboss.resteasy.spi.config.Threshold;

class ClientEntityOutputStream
extends EntityOutputStream {
    ClientEntityOutputStream(Threshold threshold, Path tmpDir, Supplier<String> filePrefix) {
        super(threshold, tmpDir, filePrefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AbstractHttpEntity toEntity() {
        if (!this.isClosed()) {
            throw Messages.MESSAGES.streamNotClosed((OutputStream)((Object)this));
        }
        this.checkExported(Messages.MESSAGES.alreadyExported());
        Object object = this.lock;
        synchronized (object) {
            Path path = this.getFile();
            if (path != null) {
                return new PathHttpEntity(path);
            }
            return new ByteArrayEntity(this.getAndClearMemory());
        }
    }

    private static class PathHttpEntity
    extends AbstractHttpEntity {
        private final Path file;
        private final InputStream content;

        private PathHttpEntity(Path file) {
            this.file = file;
            this.content = new EntityOutputStream.EntityInputStream(file);
        }

        public boolean isRepeatable() {
            return false;
        }

        public long getContentLength() {
            if (Files.exists(this.file, new LinkOption[0])) {
                try {
                    return Files.size(this.file);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return -1L;
        }

        public InputStream getContent() throws IOException, UnsupportedOperationException {
            return this.content;
        }

        public void writeTo(OutputStream outStream) throws IOException {
            try (InputStream in = this.getContent();){
                in.transferTo(outStream);
                outStream.flush();
            }
        }

        public boolean isStreaming() {
            return false;
        }
    }
}

