/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authentication.dao;

import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.InternalAuthenticationServiceException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.dao.AbstractUserDetailsAuthenticationProvider;
import org.springframework.security.authentication.password.CompromisedPasswordChecker;
import org.springframework.security.authentication.password.CompromisedPasswordException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsPasswordService;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.factory.PasswordEncoderFactories;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.util.Assert;
import org.springframework.util.function.SingletonSupplier;

public class DaoAuthenticationProvider
extends AbstractUserDetailsAuthenticationProvider {
    private static final String USER_NOT_FOUND_PASSWORD = "userNotFoundPassword";
    private Supplier<PasswordEncoder> passwordEncoder = SingletonSupplier.of(PasswordEncoderFactories::createDelegatingPasswordEncoder);
    private volatile @Nullable String userNotFoundEncodedPassword;
    private final UserDetailsService userDetailsService;
    private UserDetailsPasswordService userDetailsPasswordService = UserDetailsPasswordService.NOOP;
    private @Nullable CompromisedPasswordChecker compromisedPasswordChecker;

    public DaoAuthenticationProvider(UserDetailsService userDetailsService) {
        Assert.notNull((Object)userDetailsService, (String)"userDetailsService cannot be null");
        this.userDetailsService = userDetailsService;
    }

    @Override
    protected void additionalAuthenticationChecks(UserDetails userDetails, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        if (authentication.getCredentials() == null) {
            this.logger.debug((Object)"Failed to authenticate since no credentials provided");
            throw new BadCredentialsException(this.messages.getMessage("AbstractUserDetailsAuthenticationProvider.badCredentials", "Bad credentials"));
        }
        String presentedPassword = authentication.getCredentials().toString();
        if (!this.passwordEncoder.get().matches((CharSequence)presentedPassword, userDetails.getPassword())) {
            this.logger.debug((Object)"Failed to authenticate since password does not match stored value");
            throw new BadCredentialsException(this.messages.getMessage("AbstractUserDetailsAuthenticationProvider.badCredentials", "Bad credentials"));
        }
    }

    @Override
    protected void doAfterPropertiesSet() {
        Assert.notNull((Object)this.userDetailsService, (String)"A UserDetailsService must be set");
    }

    @Override
    protected final UserDetails retrieveUser(String username, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        this.prepareTimingAttackProtection();
        try {
            UserDetails loadedUser = this.getUserDetailsService().loadUserByUsername(username);
            if (loadedUser == null) {
                throw new InternalAuthenticationServiceException("UserDetailsService returned null, which is an interface contract violation");
            }
            return loadedUser;
        }
        catch (UsernameNotFoundException ex) {
            this.mitigateAgainstTimingAttack(authentication);
            throw ex;
        }
        catch (InternalAuthenticationServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new InternalAuthenticationServiceException(ex.getMessage(), ex);
        }
    }

    @Override
    protected Authentication createSuccessAuthentication(Object principal, Authentication authentication, UserDetails user) {
        boolean upgradeEncoding;
        boolean isPasswordCompromised;
        Assert.notNull((Object)authentication.getCredentials(), (String)"Authentication.getCredentials() cannot be null");
        String presentedPassword = authentication.getCredentials().toString();
        boolean bl = isPasswordCompromised = this.compromisedPasswordChecker != null && this.compromisedPasswordChecker.check(presentedPassword).isCompromised();
        if (isPasswordCompromised) {
            throw new CompromisedPasswordException("The provided password is compromised, please change your password");
        }
        String existingEncodedPassword = user.getPassword();
        boolean bl2 = upgradeEncoding = existingEncodedPassword != null && this.userDetailsPasswordService != null && this.passwordEncoder.get().upgradeEncoding(existingEncodedPassword);
        if (upgradeEncoding) {
            String newPassword = this.passwordEncoder.get().encode((CharSequence)presentedPassword);
            user = this.userDetailsPasswordService.updatePassword(user, newPassword);
        }
        return super.createSuccessAuthentication(principal, authentication, user);
    }

    private void prepareTimingAttackProtection() {
        if (this.userNotFoundEncodedPassword == null) {
            this.userNotFoundEncodedPassword = this.passwordEncoder.get().encode((CharSequence)USER_NOT_FOUND_PASSWORD);
        }
    }

    private void mitigateAgainstTimingAttack(UsernamePasswordAuthenticationToken authentication) {
        if (authentication.getCredentials() != null) {
            Assert.notNull((Object)this.userNotFoundEncodedPassword, (String)"userNotFoundEncodedPassword cannot be null");
            String presentedPassword = authentication.getCredentials().toString();
            this.passwordEncoder.get().matches((CharSequence)presentedPassword, this.userNotFoundEncodedPassword);
        }
    }

    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        Assert.notNull((Object)passwordEncoder, (String)"passwordEncoder cannot be null");
        this.passwordEncoder = () -> passwordEncoder;
        this.userNotFoundEncodedPassword = null;
    }

    protected PasswordEncoder getPasswordEncoder() {
        return this.passwordEncoder.get();
    }

    protected UserDetailsService getUserDetailsService() {
        return this.userDetailsService;
    }

    public void setUserDetailsPasswordService(UserDetailsPasswordService userDetailsPasswordService) {
        Assert.notNull((Object)userDetailsPasswordService, (String)"userDetailsPasswordService cannot be null");
        this.userDetailsPasswordService = userDetailsPasswordService;
    }

    public void setCompromisedPasswordChecker(CompromisedPasswordChecker compromisedPasswordChecker) {
        Assert.notNull((Object)compromisedPasswordChecker, (String)"compromisedPasswordChecker cannot be null");
        this.compromisedPasswordChecker = compromisedPasswordChecker;
    }
}

