/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.core.context;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import org.jspecify.annotations.Nullable;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextChangedEvent;
import org.springframework.security.core.context.SecurityContextChangedListener;

public final class ObservationSecurityContextChangedListener
implements SecurityContextChangedListener {
    static final String SECURITY_CONTEXT_CREATED = "spring.security.context.created";
    static final String SECURITY_CONTEXT_CHANGED = "spring.security.context.changed";
    static final String SECURITY_CONTEXT_CLEARED = "spring.security.context.cleared";
    private final ObservationRegistry registry;

    public ObservationSecurityContextChangedListener(ObservationRegistry registry) {
        this.registry = registry;
    }

    @Override
    public void securityContextChanged(SecurityContextChangedEvent event) {
        Observation observation = this.registry.getCurrentObservation();
        if (observation == null) {
            return;
        }
        if (event.isCleared()) {
            observation.event(Observation.Event.of((String)SECURITY_CONTEXT_CLEARED));
            return;
        }
        Authentication oldAuthentication = ObservationSecurityContextChangedListener.getAuthentication(event.getOldContext());
        Authentication newAuthentication = ObservationSecurityContextChangedListener.getAuthentication(event.getNewContext());
        if (oldAuthentication == null && newAuthentication == null) {
            return;
        }
        if (oldAuthentication == null) {
            observation.event(Observation.Event.of((String)SECURITY_CONTEXT_CREATED, (String)"%s [%s]").format(new Object[]{SECURITY_CONTEXT_CREATED, newAuthentication.getClass().getSimpleName()}));
            return;
        }
        if (newAuthentication == null) {
            observation.event(Observation.Event.of((String)SECURITY_CONTEXT_CLEARED, (String)"%s [%s]").format(new Object[]{SECURITY_CONTEXT_CLEARED, oldAuthentication.getClass().getSimpleName()}));
            return;
        }
        if (oldAuthentication.equals(newAuthentication)) {
            return;
        }
        observation.event(Observation.Event.of((String)SECURITY_CONTEXT_CHANGED, (String)"%s [%s] -> [%s]").format(new Object[]{SECURITY_CONTEXT_CHANGED, oldAuthentication.getClass().getSimpleName(), newAuthentication.getClass().getSimpleName()}));
    }

    private static @Nullable Authentication getAuthentication(SecurityContext context) {
        if (context == null) {
            return null;
        }
        return context.getAuthentication();
    }
}

