/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.mime.smime;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.python.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.python.bouncycastle.mime.CanonicalOutputStream;
import org.python.bouncycastle.mime.Headers;
import org.python.bouncycastle.mime.MimeContext;
import org.python.bouncycastle.mime.MimeMultipartContext;
import org.python.bouncycastle.mime.MimeParserContext;
import org.python.bouncycastle.mime.smime.SMimeParserContext;
import org.python.bouncycastle.mime.smime.SMimeUtils;
import org.python.bouncycastle.operator.DigestCalculator;
import org.python.bouncycastle.operator.OperatorCreationException;
import org.python.bouncycastle.util.io.TeeInputStream;
import org.python.bouncycastle.util.io.TeeOutputStream;

public class SMimeMultipartContext
implements MimeMultipartContext {
    private final SMimeParserContext parserContext;
    private DigestCalculator[] calculators;

    public SMimeMultipartContext(MimeParserContext mimeParserContext, Headers headers2) {
        this.parserContext = (SMimeParserContext)mimeParserContext;
        this.calculators = this.createDigestCalculators(headers2);
    }

    DigestCalculator[] getDigestCalculators() {
        return this.calculators;
    }

    OutputStream getDigestOutputStream() {
        if (this.calculators.length == 1) {
            return this.calculators[0].getOutputStream();
        }
        OutputStream outputStream = this.calculators[0].getOutputStream();
        for (int i = 1; i < this.calculators.length; ++i) {
            outputStream = new TeeOutputStream(this.calculators[i].getOutputStream(), outputStream);
        }
        return outputStream;
    }

    private DigestCalculator[] createDigestCalculators(Headers headers2) {
        try {
            Map<String, String> map = headers2.getContentTypeAttributes();
            String string2 = map.get("micalg");
            if (string2 == null) {
                throw new IllegalStateException("No micalg field on content-type header");
            }
            String[] stringArray = string2.substring(string2.indexOf(61) + 1).split(",");
            DigestCalculator[] digestCalculatorArray = new DigestCalculator[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = SMimeUtils.lessQuotes(stringArray[i]).trim();
                digestCalculatorArray[i] = this.parserContext.getDigestCalculatorProvider().get(new AlgorithmIdentifier(SMimeUtils.getDigestOID(string3)));
            }
            return digestCalculatorArray;
        }
        catch (OperatorCreationException operatorCreationException) {
            return null;
        }
    }

    @Override
    public MimeContext createContext(final int n) throws IOException {
        return new MimeContext(){

            @Override
            public InputStream applyContext(Headers headers2, InputStream inputStream) throws IOException {
                if (n == 0) {
                    OutputStream outputStream = SMimeMultipartContext.this.getDigestOutputStream();
                    headers2.dumpHeaders(outputStream);
                    outputStream.write(13);
                    outputStream.write(10);
                    return new TeeInputStream(inputStream, new CanonicalOutputStream(SMimeMultipartContext.this.parserContext, headers2, outputStream));
                }
                return inputStream;
            }
        };
    }

    @Override
    public InputStream applyContext(Headers headers2, InputStream inputStream) throws IOException {
        return inputStream;
    }
}

