/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl.model;

import java.io.Serializable;
import org.apache.pekko.http.scaladsl.model.DateTime;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple9;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class DateTime$
implements Serializable {
    public static final DateTime$ MODULE$ = new DateTime$();
    private static final String[] WEEKDAYS = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    private static final String[] MONTHS = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static final DateTime MinValue = MODULE$.apply(1800, 1, 1, 0, 0, 0);
    private static final DateTime MaxValue = MODULE$.apply(2199, 12, 31, 23, 59, 59);

    public String weekday(int index) {
        return WEEKDAYS[index];
    }

    public String month(int index) {
        return MONTHS[index];
    }

    public DateTime MinValue() {
        return MinValue;
    }

    public DateTime MaxValue() {
        return MaxValue;
    }

    public DateTime apply(int year, int month, int day, int hour, int minute, int second) {
        Predef$.MODULE$.require(1800 <= year && year <= 9999, (Function0 & Serializable)() -> "year must be >= 1800 and <= 9999");
        Predef$.MODULE$.require(1 <= month && month <= 12, (Function0 & Serializable)() -> "month must be >= 1 and <= 12");
        Predef$.MODULE$.require(1 <= day && day <= 31, (Function0 & Serializable)() -> "day must be >= 1 and <= 31");
        Predef$.MODULE$.require(0 <= hour && hour <= 23, (Function0 & Serializable)() -> "hour must be >= 0 and <= 23");
        Predef$.MODULE$.require(0 <= minute && minute <= 59, (Function0 & Serializable)() -> "minute_ must be >= 0 and <= 59");
        Predef$.MODULE$.require(0 <= second && second <= 59, (Function0 & Serializable)() -> "second must be >= 0 and <= 59");
        int m = month - 1;
        int m7 = m % 7;
        int d = m7 * 30 + (m7 + 1 >> 1) + day;
        boolean isLeap = this.isLeapYear(year);
        if (m >= 7) {
            d += 214;
        }
        if (d >= 61) {
            --d;
        }
        if (!isLeap && d >= 60) {
            --d;
        }
        int y = year - 1;
        int yd = y / 100;
        long c = (long)((d += y * 365 + (y >> 2) - yd + (yd >> 2)) - 719162 - 1) * 86400L + (long)hour * 3600L + (long)minute * 60L + (long)second;
        return new DateTime(year, month, day, hour, minute, second, d % 7, c * 1000L, isLeap);
    }

    public DateTime apply(long clicks) {
        Predef$.MODULE$.require(this.MinValue().clicks() <= clicks && clicks <= this.MaxValue().clicks(), (Function0 & Serializable)() -> new StringBuilder(34).append("DateTime value must be >= ").append(MODULE$.MinValue()).append(" and <= ").append(MODULE$.MaxValue()).toString());
        long c = clicks - clicks % 1000L;
        long s2 = c >= 0L ? c / 1000L : (c - 999L) / 1000L;
        int dn = (int)(s2 / 86400L);
        if ((s2 %= 86400L) < 0L) {
            s2 += 86400L;
            --dn;
        }
        int y = 400 * ((dn += 719162) / 146097) + 1;
        int d = dn % 146097;
        if (d == 146096) {
            y += 399;
            d = 365;
        } else {
            y += 100 * (d / 36524);
            y += (d %= 36524) / 1461 << 2;
            if ((d %= 1461) == 1460) {
                y += 3;
                d = 365;
            } else {
                y += d / 365;
                d %= 365;
            }
        }
        boolean isLeap = this.isLeapYear(y);
        if (!isLeap && d >= 59) {
            ++d;
        }
        if (d >= 60) {
            ++d;
        }
        int d214 = d % 214;
        int d214_61 = d214 % 61;
        int mon = (d214 / 61 << 1) + d214_61 / 31;
        if (d > 213) {
            mon += 7;
        }
        d = d214_61 % 31 + 1;
        int m = (int)(s2 / 60L);
        int h = m / 60;
        int w = (dn + 1) % 7;
        return new DateTime(y, mon + 1, d, h, m %= 60, (int)(s2 %= 60L), w, c, isLeap);
    }

    public int apply$default$4() {
        return 0;
    }

    public int apply$default$5() {
        return 0;
    }

    public int apply$default$6() {
        return 0;
    }

    private boolean isLeapYear(int year) {
        if ((year & 3) == 0) {
            int q = year / 100;
            if (year % 100 != 0 || (q & 3) == 0) {
                return true;
            }
        }
        return false;
    }

    public DateTime now() {
        return this.apply(System.currentTimeMillis());
    }

    public Option<DateTime> fromIsoDateTimeString(String string) {
        if (DateTime$.check$1(string.length(), string)) {
            try {
                int mul10$1_i = DateTime$.i$1(2, string);
                int year = DateTime$.i$1(0, string) * 1000 + DateTime$.i$1(1, string) * 100 + ((mul10$1_i << 3) + (mul10$1_i << 1)) + DateTime$.i$1(3, string);
                int mul10$1_i2 = DateTime$.i$1(5, string);
                int month = (mul10$1_i2 << 3) + (mul10$1_i2 << 1) + DateTime$.i$1(6, string);
                int mul10$1_i3 = DateTime$.i$1(8, string);
                int day = (mul10$1_i3 << 3) + (mul10$1_i3 << 1) + DateTime$.i$1(9, string);
                int mul10$1_i4 = DateTime$.i$1(11, string);
                int hour = (mul10$1_i4 << 3) + (mul10$1_i4 << 1) + DateTime$.i$1(12, string);
                int mul10$1_i5 = DateTime$.i$1(14, string);
                int min2 = (mul10$1_i5 << 3) + (mul10$1_i5 << 1) + DateTime$.i$1(15, string);
                int mul10$1_i6 = DateTime$.i$1(17, string);
                int sec = (mul10$1_i6 << 3) + (mul10$1_i6 << 1) + DateTime$.i$1(18, string);
                return new Some((Object)this.apply(year, month, day, hour, min2, sec));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return None$.MODULE$;
            }
        }
        return None$.MODULE$;
    }

    public DateTime apply(int year, int month, int day, int hour, int minute, int second, int weekday, long clicks, boolean isLeapYear) {
        return new DateTime(year, month, day, hour, minute, second, weekday, clicks, isLeapYear);
    }

    public Option<Tuple9<Object, Object, Object, Object, Object, Object, Object, Object, Object>> unapply(DateTime x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple9((Object)BoxesRunTime.boxToInteger((int)x$0.year()), (Object)BoxesRunTime.boxToInteger((int)x$0.month()), (Object)BoxesRunTime.boxToInteger((int)x$0.day()), (Object)BoxesRunTime.boxToInteger((int)x$0.hour()), (Object)BoxesRunTime.boxToInteger((int)x$0.minute()), (Object)BoxesRunTime.boxToInteger((int)x$0.second()), (Object)BoxesRunTime.boxToInteger((int)x$0.weekday()), (Object)BoxesRunTime.boxToLong((long)x$0.clicks()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.isLeapYear())));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DateTime$.class);
    }

    private static final char c$1(int ix, String string$1) {
        return string$1.charAt(ix);
    }

    private static final boolean isDigit$1(char c) {
        return '0' <= c && c <= '9';
    }

    private static final int i$1(int ix, String string$1) {
        char x = string$1.charAt(ix);
        Predef$.MODULE$.require(DateTime$.isDigit$1(x));
        return x - 48;
    }

    private static final boolean check$1(int len, String string$1) {
        switch (len) {
            case 19: {
                int c$1_ix;
                int c$1_ix2;
                int c$1_ix3;
                int c$1_ix4;
                int c$1_ix5 = 4;
                return string$1.charAt(c$1_ix5) == '-' && string$1.charAt(c$1_ix4 = 7) == '-' && string$1.charAt(c$1_ix3 = 10) == 'T' && string$1.charAt(c$1_ix2 = 13) == ':' && string$1.charAt(c$1_ix = 16) == ':';
            }
            case 24: {
                int c$1_ix;
                int c$1_ix6;
                int c$1_ix7;
                int c$1_ix8;
                int c$1_ix9;
                return DateTime$.check$1(19, string$1) && string$1.charAt(c$1_ix9 = 19) == '.' && DateTime$.isDigit$1(string$1.charAt(c$1_ix8 = 20)) && DateTime$.isDigit$1(string$1.charAt(c$1_ix7 = 21)) && DateTime$.isDigit$1(string$1.charAt(c$1_ix6 = 22)) && string$1.charAt(c$1_ix = 23) == 'Z';
            }
        }
        return false;
    }

    private static final int mul10$1(int i) {
        return (i << 3) + (i << 1);
    }

    private DateTime$() {
    }
}

