/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.stitch.service.engine.context;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JacksonJsonNodeJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.xebialabs.deployit.plugin.stitch.service.engine.context.InputContext;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class JsonInputContext
implements InputContext {
    private final DocumentContext document;
    private static final Configuration conf = Configuration.builder().jsonProvider((JsonProvider)new JacksonJsonNodeJsonProvider()).options(new Option[]{Option.ALWAYS_RETURN_LIST, Option.SUPPRESS_EXCEPTIONS}).build();

    public JsonInputContext(JsonNode json) {
        this.document = JsonPath.parse((String)json.toPrettyString(), (Configuration)conf);
    }

    @Override
    public boolean pathExistsWithValue(String jsonPathExpression) {
        ArrayNode result = (ArrayNode)this.document.read(jsonPathExpression, new Predicate[0]);
        return result != null && !result.isEmpty();
    }

    private <T> T getFirstElement(String jsonPathExpression, Function<JsonNode, T> transform) {
        ArrayNode result = (ArrayNode)this.document.read(jsonPathExpression, new Predicate[0]);
        if (result != null && result.size() == 1) {
            return transform.apply(result.get(0));
        }
        return null;
    }

    @Override
    public String getStringValue(String jsonPathExpression) {
        return this.getFirstElement(jsonPathExpression, JsonNode::asText);
    }

    @Override
    public Boolean getBooleanValue(String jsonPathExpression) {
        return this.getFirstElement(jsonPathExpression, JsonNode::asBoolean);
    }

    @Override
    public Integer getIntegerValue(String jsonPathExpression) {
        return this.getFirstElement(jsonPathExpression, JsonNode::asInt);
    }

    @Override
    public Long getLongValue(String jsonPathExpression) {
        return this.getFirstElement(jsonPathExpression, JsonNode::asLong);
    }

    @Override
    public Double getDoubleValue(String jsonPathExpression) {
        return this.getFirstElement(jsonPathExpression, JsonNode::asDouble);
    }

    @Override
    public JsonNode getJsonNode(String jsonPathExpression) {
        return (JsonNode)this.getFirstElement(jsonPathExpression, Function.identity());
    }

    private <T> List<T> getList(String jsonPathExpression, Function<JsonNode, T> transform) {
        ArrayNode result = (ArrayNode)this.document.read(jsonPathExpression, new Predicate[0]);
        if (result != null) {
            ArrayList objects = new ArrayList();
            result.forEach(node -> objects.add(transform.apply((JsonNode)node)));
            return objects;
        }
        return null;
    }

    @Override
    public List<String> getStringList(String jsonPathExpression) {
        return this.getList(jsonPathExpression, JsonNode::asText);
    }

    @Override
    public List<Boolean> getBooleanList(String jsonPathExpression) {
        return this.getList(jsonPathExpression, JsonNode::asBoolean);
    }

    @Override
    public List<Long> getLongList(String jsonPathExpression) {
        return this.getList(jsonPathExpression, JsonNode::asLong);
    }

    @Override
    public List<Integer> getIntegerList(String jsonPathExpression) {
        return this.getList(jsonPathExpression, JsonNode::asInt);
    }

    @Override
    public List<Double> getDoubleList(String jsonPathExpression) {
        return this.getList(jsonPathExpression, JsonNode::asDouble);
    }

    @Override
    public List<JsonNode> getJsonNodeList(String jsonPathExpression) {
        return this.getList(jsonPathExpression, Function.identity());
    }
}

