/*
 * Decompiled with CFR 0.152.
 */
package nl.javadude.scannit.scanner;

import java.util.List;
import javassist.bytecode.ClassFile;
import javassist.bytecode.MethodInfo;
import nl.javadude.scannit.metadata.DescriptorHelper;
import nl.javadude.scannit.metadata.JavassistHelper;
import nl.javadude.scannit.registry.Registry;
import nl.javadude.scannit.scanner.AbstractScanner;

public class MethodAnnotationScanner
extends AbstractScanner {
    @Override
    public void doScan(ClassFile file, Registry registry) {
        List methods = file.getMethods();
        for (MethodInfo method : methods) {
            List<String> methodAnnotations = JavassistHelper.getMethodAnnotations(method);
            this.registerAnnotations(methodAnnotations, file, method, registry);
        }
    }

    private void registerAnnotations(List<String> methodAnnotations, ClassFile file, MethodInfo method, Registry registry) {
        for (String methodAnnotation : methodAnnotations) {
            this.addToRegistry(registry, methodAnnotation, DescriptorHelper.toMethodDescriptor(file, method));
        }
    }
}

