/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.spi;

import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereExecutionOutputHandler;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.OverthereProcess;
import com.xebialabs.overthere.OverthereProcessOutputHandler;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.spi.AddressPortMapper;
import com.xebialabs.overthere.util.ConsoleOverthereExecutionOutputHandler;
import com.xebialabs.overthere.util.OverthereProcessOutputHandlerWrapper;
import com.xebialabs.overthere.util.OverthereUtils;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public abstract class BaseOverthereConnection
implements OverthereConnection {
    private static Logger logger = LoggerFactory.getLogger(BaseOverthereConnection.class);
    protected final String protocol;
    protected final ConnectionOptions options;
    protected final AddressPortMapper mapper;
    protected final OperatingSystemFamily os;
    protected final int connectionTimeoutMillis;
    protected final int socketTimeoutMillis;
    protected final boolean canStartProcess;
    protected final String temporaryDirectoryPath;
    protected final boolean deleteTemporaryDirectoryOnDisconnect;
    protected final int temporaryFileCreationRetries;
    protected final String temporaryFileHolderDirectoryNamePrefix;
    protected final List<OverthereFile> temporaryFileHolderDirectories = new ArrayList<OverthereFile>();
    protected final int streamBufferSize;
    protected int temporaryFileHolderDirectoryNameSuffix = 0;
    protected OverthereFile workingDirectory;
    private volatile boolean isConnected;
    private Throwable openStack;

    protected BaseOverthereConnection(String protocol, ConnectionOptions options, AddressPortMapper mapper, boolean canStartProcess) {
        this.protocol = OverthereUtils.checkNotNull(protocol, "Cannot create OverthereConnection with null protocol", new Object[0]);
        this.options = OverthereUtils.checkNotNull(options, "Cannot create OverthereConnection with null options", new Object[0]);
        this.mapper = OverthereUtils.checkNotNull(mapper, "Cannot create OverthereConnection with null address-port mapper", new Object[0]);
        this.os = options.getEnum("os", OperatingSystemFamily.class);
        this.connectionTimeoutMillis = options.getInteger("connectionTimeoutMillis", 120000);
        this.socketTimeoutMillis = options.getInteger("socketTimeoutMillis", 0);
        this.canStartProcess = canStartProcess;
        this.temporaryDirectoryPath = options.get("tmp", this.os.getDefaultTemporaryDirectoryPath());
        this.deleteTemporaryDirectoryOnDisconnect = options.getBoolean("tmpDeleteOnDisconnect", true);
        this.temporaryFileCreationRetries = options.getInteger("tmpFileCreationRetries", 100);
        this.temporaryFileHolderDirectoryNamePrefix = "ot-" + new SimpleDateFormat("yyyyMMdd'T'HHmmssSSS").format(new Date());
        this.streamBufferSize = options.getInteger("remoteCopyBufferSize", 65536);
    }

    protected void connected() {
        this.isConnected = true;
        this.openStack = new Throwable("Opened here...");
    }

    @Override
    public OperatingSystemFamily getHostOperatingSystem() {
        return this.os;
    }

    @Override
    public final void close() {
        if (!this.isConnected) {
            return;
        }
        try {
            if (this.deleteTemporaryDirectoryOnDisconnect) {
                this.deleteConnectionTemporaryDirectory();
            }
            this.doClose();
            OverthereUtils.closeQuietly(this.mapper);
        }
        finally {
            this.logDisconnect();
            this.isConnected = false;
        }
    }

    protected void logDisconnect() {
        logger.info("Disconnected from {}", (Object)this);
    }

    protected abstract void doClose();

    @Override
    public final OverthereFile getTempFile(String prefix, String suffix) throws RuntimeIOException {
        OverthereUtils.checkNotNull(prefix, "prefix is null", new Object[0]);
        if (suffix == null) {
            suffix = ".tmp";
        }
        return this.getTempFile(prefix + suffix);
    }

    @Override
    public final synchronized OverthereFile getTempFile(String name) {
        if (name == null || name.trim().isEmpty()) {
            name = "tmp";
        }
        OverthereFile temporaryDirectory = this.getFile(this.temporaryDirectoryPath);
        RuntimeException originalExc = null;
        for (int i = 0; i <= this.temporaryFileCreationRetries; ++i) {
            OverthereFile holder;
            Object holderName = this.temporaryFileHolderDirectoryNamePrefix;
            if (this.temporaryFileHolderDirectoryNameSuffix > 0) {
                holderName = (String)holderName + "." + this.temporaryFileHolderDirectoryNameSuffix;
            }
            if (!(holder = this.getFileForTempFile(temporaryDirectory, (String)holderName)).exists()) {
                logger.trace("Creating holder directory {} for temporary file with name {}", (Object)holder, (Object)name);
                try {
                    originalExc = null;
                    holder.mkdir();
                    this.temporaryFileHolderDirectories.add(holder);
                    OverthereFile tempFile = holder.getFile(name);
                    logger.debug("Generated temporary file name {}", (Object)tempFile);
                    return tempFile;
                }
                catch (RuntimeException exc) {
                    originalExc = exc;
                    logger.debug(String.format("Failed to create holder directory %s - Trying with the next suffix", holder), (Throwable)exc);
                }
            }
            ++this.temporaryFileHolderDirectoryNameSuffix;
        }
        if (originalExc != null) {
            throw new RuntimeIOException("Cannot generate a unique temporary file name on " + String.valueOf(this), originalExc);
        }
        throw new RuntimeIOException("Cannot generate a unique temporary file name on " + String.valueOf(this));
    }

    private void deleteConnectionTemporaryDirectory() {
        for (OverthereFile d : this.temporaryFileHolderDirectories) {
            try {
                logger.info("Deleting temporary directory {}", (Object)d);
                d.deleteRecursively();
            }
            catch (RuntimeException exc) {
                logger.warn("Got exception while deleting connection temporary directory {}. Ignoring it.", (Object)d, (Object)exc);
            }
        }
    }

    protected abstract OverthereFile getFileForTempFile(OverthereFile var1, String var2);

    @Override
    public OverthereFile getWorkingDirectory() {
        return this.workingDirectory;
    }

    @Override
    public void setWorkingDirectory(OverthereFile workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    @Override
    public ConnectionOptions getOptions() {
        return this.options;
    }

    @Override
    public final int execute(CmdLine commandLine) {
        return this.execute(ConsoleOverthereExecutionOutputHandler.sysoutHandler(), ConsoleOverthereExecutionOutputHandler.syserrHandler(), commandLine);
    }

    @Override
    public int execute(OverthereExecutionOutputHandler stdoutHandler, OverthereExecutionOutputHandler stderrHandler, CmdLine commandLine) {
        OverthereProcess process = this.startProcess(commandLine);
        Thread stdoutReaderThread = null;
        Thread stderrReaderThread = null;
        CountDownLatch latch = new CountDownLatch(2);
        Map mdcContext = MDC.getCopyOfContextMap();
        stdoutReaderThread = this.getThread("stdout", commandLine.toString(), stdoutHandler, process.getStdout(), latch, mdcContext);
        stdoutReaderThread.start();
        stderrReaderThread = this.getThread("stderr", commandLine.toString(), stderrHandler, process.getStderr(), latch, mdcContext);
        stderrReaderThread.start();
        try {
            latch.await();
            int n = process.waitFor();
            this.quietlyJoinThread(stdoutReaderThread);
            this.quietlyJoinThread(stderrReaderThread);
            return n;
        }
        catch (InterruptedException exc) {
            try {
                Thread.currentThread().interrupt();
                logger.info("Execution interrupted, destroying the process.");
                process.destroy();
                throw new RuntimeIOException("Execution interrupted", exc);
            }
            catch (Throwable throwable) {
                this.quietlyJoinThread(stdoutReaderThread);
                this.quietlyJoinThread(stderrReaderThread);
                throw throwable;
            }
        }
    }

    private void quietlyJoinThread(Thread thread) {
        if (thread != null) {
            try {
                thread.interrupt();
                thread.join();
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private Thread getThread(final String streamName, final String commandLine, final OverthereExecutionOutputHandler outputHandler, final InputStream stream, final CountDownLatch latch, final Map<String, String> mdcContext) {
        Thread t = new Thread(this, String.format("%s reader", streamName)){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Map previous = MDC.getCopyOfContextMap();
                this.setMDCContext(mdcContext);
                StringBuilder lineBuffer = new StringBuilder();
                InputStreamReader stdoutReader = new InputStreamReader(stream);
                try {
                    int cInt = stdoutReader.read();
                    while (cInt > -1) {
                        char c = (char)cInt;
                        outputHandler.handleChar(c);
                        if (c != '\r' && c != '\n') {
                            lineBuffer.append(c);
                        }
                        if (c == '\n') {
                            outputHandler.handleLine(lineBuffer.toString());
                            lineBuffer.setLength(0);
                        }
                        cInt = stdoutReader.read();
                    }
                }
                catch (Exception exc) {
                    logger.error(String.format("An exception occured reading %s while executing [%s] on %s", streamName, commandLine, this), (Throwable)exc);
                }
                finally {
                    OverthereUtils.closeQuietly(stdoutReader);
                    if (lineBuffer.length() > 0) {
                        outputHandler.handleLine(lineBuffer.toString());
                    }
                    this.setMDCContext(previous);
                    latch.countDown();
                }
            }

            private void setMDCContext(Map<String, String> context) {
                if (context == null) {
                    MDC.clear();
                } else {
                    MDC.setContextMap(context);
                }
            }
        };
        t.setDaemon(true);
        return t;
    }

    @Override
    @Deprecated
    public final int execute(OverthereProcessOutputHandler handler, CmdLine commandLine) {
        return this.execute(OverthereProcessOutputHandlerWrapper.wrapStdout(handler), OverthereProcessOutputHandlerWrapper.wrapStderr(handler), commandLine);
    }

    @Override
    public OverthereProcess startProcess(CmdLine commandLine) {
        throw new UnsupportedOperationException("Cannot start a process on " + String.valueOf(this));
    }

    @Override
    public final boolean canStartProcess() {
        return this.canStartProcess;
    }

    @Override
    public abstract String toString();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseOverthereConnection that = (BaseOverthereConnection)o;
        return this.options.equals(that.options) && this.protocol.equals(that.protocol);
    }

    public int hashCode() {
        int result = this.protocol.hashCode();
        result = 31 * result + this.options.hashCode();
        return result;
    }

    protected void finalize() throws Throwable {
        if (this.isConnected) {
            logger.error(String.format("Connection [%s] was not closed, closing automatically.", this), this.openStack);
            OverthereUtils.closeQuietly(this);
        }
        super.finalize();
    }
}

