/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.local;

import com.xebialabs.deployit.booter.local.AbstractGlobalContextManager;
import com.xebialabs.deployit.booter.local.GlobalContext;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

final class LocalGlobalContextManager
extends AbstractGlobalContextManager {
    LocalGlobalContextManager() {
    }

    @Override
    public void loadStoredDefaults(File configFile) {
        if (!configFile.exists()) {
            this.logger.info("Could not find '" + String.valueOf(configFile) + "', continuing without loading defaults");
            return;
        }
        if (configFile.isDirectory()) {
            this.logger.error(String.valueOf(configFile) + " is a directory but should be a plain file, aborting!");
            throw new IllegalStateException("Please remove " + String.valueOf(configFile) + " and try again.");
        }
        try (BufferedReader br = new BufferedReader(new FileReader(configFile));){
            br.lines().forEach(this::processLine);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read '" + configFile.toString() + "'", e);
        }
    }

    private void processLine(String line) {
        if (!line.startsWith("#") && line.contains("=")) {
            int i = line.indexOf("=");
            String key = line.substring(0, i);
            this.addContextEntry(key, line.substring(i + 1));
        }
    }

    @Override
    public void storeDefaults(File configFile) {
        if (configFile != null) {
            if (!configFile.getParentFile().exists() || !configFile.getParentFile().isDirectory()) {
                this.logger.warn("Not writing {} because the directory does not exist", (Object)configFile);
                return;
            }
            try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(configFile));){
                bufferedWriter.append(this.header());
                bufferedWriter.newLine();
                bufferedWriter.newLine();
                this.getContextEntries().forEach(pair -> {
                    GlobalContext.Value v = pair.value;
                    if (v.isShouldWrite()) {
                        try {
                            if (v.description != null && !v.description.isEmpty()) {
                                bufferedWriter.append("# ").append(this.toComment(v));
                                bufferedWriter.newLine();
                            }
                            bufferedWriter.append(v.isExplicit() ? "" : "#").append(pair.key).append('=').append(v.getValue());
                            bufferedWriter.newLine();
                        }
                        catch (IOException e) {
                            this.logger.error("Could not write to '" + String.valueOf(configFile) + "'", (Throwable)e);
                        }
                    }
                });
            }
            catch (FileNotFoundException e) {
                this.logger.error("Could not start writing to '" + String.valueOf(configFile) + "'", (Throwable)e);
            }
            catch (IOException e) {
                this.logger.error("Could not write to '" + String.valueOf(configFile) + "'", (Throwable)e);
            }
        }
    }
}

