/*
 * Decompiled with CFR 0.152.
 */
package abbi.io.abbisdk.model;

import abbi.io.abbisdk.bk;
import abbi.io.abbisdk.bw;
import abbi.io.abbisdk.ca;
import abbi.io.abbisdk.cc;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WMPromotionObject {
    public long mPromotionId;
    public c mTrigger;
    private String mUrl;
    private int mPriority;
    public int mCap;
    private String mName;
    private String mTriggerKey;
    private boolean mIsActive;
    public b mCls;
    private List<bw> mActions;
    private int mDisplayCount;
    private d mTriggerType;
    private long mTriggeredByPromotionId;
    private boolean mWasImpressionSent;
    private long mLastCtaId;
    private String mLastCta;

    public WMPromotionObject() {
    }

    public WMPromotionObject(JSONObject jSONObject) {
        this.mPromotionId = jSONObject.optLong("_id");
        this.mTrigger = this.parseTrigger(jSONObject.optInt("trigger"));
        this.mUrl = jSONObject.optString("url");
        this.mPriority = jSONObject.optInt("priority", 1);
        this.mCap = jSONObject.optInt("cap", 1);
        if (this.mCap == -1) {
            this.mCap = Integer.MAX_VALUE;
        }
        this.mName = jSONObject.optString("name");
        this.mIsActive = jSONObject.optBoolean("enabled");
        this.mCls = WMPromotionObject.parseCls(jSONObject.optString("cls"));
        this.mTriggerKey = jSONObject.optString("key", "");
        this.mActions = new ArrayList<bw>();
        JSONArray jSONArray = jSONObject.optJSONArray("actions");
        if (jSONArray != null) {
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                try {
                    this.mActions.add(new bw(jSONArray.getJSONObject(i2)));
                    continue;
                }
                catch (JSONException jSONException) {
                    bk.a("Can't add action object from JSON - " + jSONException.getMessage(), new Object[0]);
                }
            }
        }
        if (this.mName == null) {
            this.mName = jSONObject.optString("name");
        }
        if (this.mPromotionId == 0L) {
            this.mPromotionId = jSONObject.optLong("promotionID");
        }
    }

    public static WMPromotionObject promotionWithData(JSONObject jSONObject) {
        int n2 = jSONObject.optInt("version");
        b b2 = WMPromotionObject.parseCls(jSONObject.optString("cls"));
        if (b2 != null) {
            switch (b2) {
                case a: 
                case c: 
                case d: {
                    return new ca(jSONObject, n2, 0L);
                }
                case b: {
                    return new cc(jSONObject, n2);
                }
            }
        }
        return null;
    }

    private c parseTrigger(int n2) {
        switch (n2) {
            case -1: {
                this.mTriggerType = d.c;
                return c.a;
            }
            case 0: {
                this.mTriggerType = d.f;
                return c.b;
            }
            case 1: {
                this.mTriggerType = d.e;
                return c.c;
            }
        }
        return null;
    }

    private static a parseCampaignType(int n2) {
        switch (n2) {
            case 1: {
                return a.a;
            }
            case 6: {
                return a.b;
            }
        }
        return null;
    }

    private static b parseCls(String string) {
        switch (string) {
            case "PROMOTION_BUILDER": {
                return b.a;
            }
            case "WALKTHROUGH": {
                return b.b;
            }
            case "SURVEY": {
                return b.c;
            }
            case "LAUNCHER": {
                return b.d;
            }
        }
        return null;
    }

    public boolean didReachCappingLimit() {
        abbi.io.abbisdk.b b2 = abbi.io.abbisdk.b.a();
        int n2 = b2.d(this.mPromotionId);
        return n2 >= this.mCap;
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("cls", (Object)this.mCls.a());
            jSONObject.put("trigger", (Object)Integer.toString(this.mTrigger.a()));
            jSONObject.put("key", (Object)this.mTriggerKey);
            jSONObject.put("_id", this.mPromotionId);
            jSONObject.put("url", (Object)this.mUrl);
            jSONObject.put("priority", this.mPriority);
            jSONObject.put("cap", this.mCap);
            jSONObject.put("name", (Object)this.mName);
            jSONObject.put("enabled", this.mIsActive);
            JSONArray jSONArray = new JSONArray();
            if (this.mActions != null) {
                for (int i2 = 0; i2 < this.mActions.size(); ++i2) {
                    JSONObject jSONObject2 = this.mActions.get(i2).a();
                    jSONArray.put(i2, (Object)jSONObject2);
                }
                jSONObject.put("actions", (Object)jSONArray);
            }
        }
        catch (JSONException jSONException) {
            bk.a("JSONException: " + jSONException.getMessage(), new Object[0]);
        }
        return jSONObject;
    }

    public void increaseDisplayCount() {
        ++this.mDisplayCount;
    }

    public boolean isWalkthrough() {
        return this.mCls == b.b;
    }

    public boolean isShoutout() {
        return this.mCls == b.a;
    }

    public boolean isLauncher() {
        return this.mCls == b.d;
    }

    public boolean wasLinked() {
        return this.mTriggerType == d.b || this.mTriggerType == d.h || this.mTriggerType == d.d;
    }

    public long getPromotionId() {
        return this.mPromotionId;
    }

    public void setPromotionId(long l2) {
        this.mPromotionId = l2;
    }

    public c getTrigger() {
        return this.mTrigger;
    }

    public d getTriggerType() {
        return this.mTriggerType;
    }

    public String getTriggerTypeString() {
        if (this.mTriggerType == null) {
            return "auto";
        }
        switch (this.mTriggerType) {
            case b: 
            case d: 
            case h: {
                return this.mTriggerType.a() + "_" + this.getTriggeredByPromotionId();
            }
            case c: {
                return this.getTriggerKey();
            }
            case e: 
            case g: {
                return "auto_static";
            }
            case f: {
                return "auto_happy_moment";
            }
        }
        return "auto";
    }

    public void setTriggerType(d d2) {
        this.mTriggerType = d2;
    }

    public String getUrl() {
        return this.mUrl;
    }

    public int getPriority() {
        return this.mPriority;
    }

    public int getCap() {
        return this.mCap;
    }

    public b getCls() {
        return this.mCls;
    }

    public String getTriggerKey() {
        return this.mTriggerKey;
    }

    public List<bw> getActions() {
        return this.mActions;
    }

    public String getName() {
        return this.mName;
    }

    public boolean isActive() {
        return this.mIsActive;
    }

    public int getDisplayCount() {
        return this.mDisplayCount;
    }

    public long getTriggeredByPromotionId() {
        return this.mTriggeredByPromotionId;
    }

    public void setTriggeredByPromotionId(long l2) {
        this.mTriggeredByPromotionId = l2;
    }

    public boolean wasImpressionSent() {
        return this.mWasImpressionSent;
    }

    public void setImpressionSent() {
        this.mWasImpressionSent = true;
    }

    public long getLastCtaId() {
        return this.mLastCtaId;
    }

    public void setLastCtaId(long l2) {
        this.mLastCtaId = l2;
    }

    public String getLastCta() {
        return this.mLastCta;
    }

    public void setLastCta(String string) {
        this.mLastCta = string;
    }

    public String toString() {
        return "WMPromotionObject {mPromotionId=" + this.mPromotionId + ", mTrigger='" + (Object)((Object)this.mTrigger) + '\'' + ", mUrl=" + this.mUrl + '\'' + ", mPriority=" + this.mPriority + '\'' + ", mCap=" + this.mCap + '\'' + ", mName=" + this.mName + '}';
    }

    public static enum c {
        a(-1),
        b(0),
        c(1);

        private int d;

        private c(int n3) {
            this.d = n3;
        }

        public int a() {
            return this.d;
        }
    }

    public static enum b {
        a("PROMOTION_BUILDER"),
        b("WALKTHROUGH"),
        c("SURVEY"),
        d("LAUNCHER");

        private String e;

        private b(String string2) {
            this.e = string2;
        }

        public String a() {
            return this.e;
        }

        public String b() {
            switch (this.e) {
                case "PROMOTION_BUILDER": {
                    return "ShoutOut";
                }
                case "WALKTHROUGH": {
                    return "Walk-Thru";
                }
                case "SURVEY": {
                    return "Survey";
                }
                case "LAUNCHER": {
                    return "Launcher";
                }
            }
            return "";
        }
    }

    public static enum a {
        a(1),
        b(6);

        private int c;

        private a(int n3) {
            this.c = n3;
        }
    }

    public static enum d {
        a("auto"),
        b("linked"),
        c("key"),
        d("launcher"),
        e("auto_static"),
        f("auto_happy_moment"),
        g("safe_start"),
        h("connect");

        public String i;

        private d(String string2) {
            this.i = string2;
        }

        public String a() {
            return this.i;
        }
    }
}

