/*
 * Decompiled with CFR 0.152.
 */
package abbi.io.abbisdk.model;

import abbi.io.abbisdk.b;
import abbi.io.abbisdk.bw;
import abbi.io.abbisdk.ci;
import abbi.io.abbisdk.cj;
import abbi.io.abbisdk.ck;
import abbi.io.abbisdk.cl;
import abbi.io.abbisdk.cp;
import abbi.io.abbisdk.cr;
import abbi.io.abbisdk.d;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WMPromotionObject {
    protected long mPromotionId;
    protected cj.d mTrigger;
    private String mUrl;
    private int mPriority;
    protected int mCap;
    private String mName;
    private String mUiType;
    private boolean mIsActive;
    protected cj.b mCls;
    private List<cl> mActions;
    private long mPromotionRevisionId;
    private String mDirection;
    private cj.c mStatus;
    private ck mPromotionEventsData = new ck();
    private int mDisplayCount;
    private boolean mWasImpressionSent;
    private long mLastCtaId;
    private String mLastCta;
    private Boolean mIsRequestAccessibilityFocus;
    private ArrayList<Long> mLabels;

    public WMPromotionObject() {
    }

    public WMPromotionObject(JSONObject jSONObject) {
        this();
        JSONObject jSONObject2;
        this.mPromotionId = jSONObject.optLong("_id");
        this.mTrigger = this.parseTrigger(jSONObject.optInt("trigger"));
        this.mUrl = jSONObject.optString("url");
        this.mPriority = jSONObject.optInt("priority", 1);
        this.mCap = jSONObject.optInt("cap", 1);
        if (this.mCap == -1) {
            this.mCap = Integer.MAX_VALUE;
        }
        this.mName = jSONObject.optString("name");
        this.mIsActive = jSONObject.optBoolean("enabled");
        this.mStatus = WMPromotionObject.parseStatus(jSONObject.optInt("status"));
        this.mCls = WMPromotionObject.parseCls(jSONObject.optString("cls"));
        this.mPromotionEventsData.a(jSONObject.optString("key", ""));
        this.mPromotionRevisionId = jSONObject.optLong("promotion_revision_id", 1L);
        this.mUiType = jSONObject.optString("ui_type");
        this.mActions = new ArrayList<cl>();
        JSONArray jSONArray = jSONObject.optJSONArray("actions");
        if (jSONArray != null) {
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                try {
                    this.mActions.add(new cl(jSONArray.getJSONObject(i2)));
                    continue;
                }
                catch (JSONException jSONException) {
                    bw.a("Can't add action object from JSON - " + jSONException.getMessage(), new Object[0]);
                }
            }
        }
        if (this.mName == null) {
            this.mName = jSONObject.optString("name");
        }
        if (this.mPromotionId == 0L) {
            this.mPromotionId = jSONObject.optLong("promotionID");
        }
        this.mIsRequestAccessibilityFocus = (jSONObject2 = jSONObject.optJSONObject("accessibility")) != null ? Boolean.valueOf(jSONObject2.optBoolean("requestAccessibilityFocus")) : null;
        this.mDirection = jSONObject.optString("direction", "ltr");
        this.mLabels = new ArrayList();
        this.setLabels(jSONObject);
    }

    public static WMPromotionObject promotionWithData(JSONObject jSONObject) {
        int n2 = jSONObject.optInt("version");
        cj.b b2 = WMPromotionObject.parseCls(jSONObject.optString("cls"));
        if (b2 != null) {
            switch (b2) {
                case a: 
                case c: 
                case e: {
                    return new cp(jSONObject, n2, 0L);
                }
                case d: {
                    return new ci(jSONObject, n2, 0L);
                }
                case b: {
                    return new cr(jSONObject, n2);
                }
            }
        }
        return null;
    }

    private cj.d parseTrigger(int n2) {
        switch (n2) {
            case -1: {
                this.mPromotionEventsData.a(ck.b.c);
                return cj.d.a;
            }
            case 0: {
                this.mPromotionEventsData.a(ck.b.f);
                return cj.d.b;
            }
            case 1: {
                this.mPromotionEventsData.a(ck.b.e);
                return cj.d.c;
            }
        }
        return null;
    }

    private static cj.a parseCampaignType(int n2) {
        switch (n2) {
            case 1: {
                return cj.a.a;
            }
            case 6: {
                return cj.a.b;
            }
        }
        return null;
    }

    private static cj.c parseStatus(int n2) {
        switch (n2) {
            case 0: {
                return cj.c.a;
            }
            case 1: {
                return cj.c.b;
            }
            case 2: {
                return cj.c.c;
            }
        }
        return null;
    }

    private static cj.b parseCls(String string) {
        switch (string) {
            case "PROMOTION_BUILDER": {
                return cj.b.a;
            }
            case "WALKTHROUGH": {
                return cj.b.b;
            }
            case "SURVEY": {
                return cj.b.c;
            }
            case "NATIVE_SURVEY": {
                return cj.b.e;
            }
            case "LAUNCHER": {
                return cj.b.d;
            }
            case "WAIT_FOR": {
                return cj.b.f;
            }
        }
        return null;
    }

    public int getPromotionCount() {
        d d2 = d.a();
        return d2.d(this.mPromotionId);
    }

    public boolean didReachCappingLimit() {
        d d2 = d.a();
        int n2 = d2.d(this.mPromotionId);
        return n2 >= this.mCap;
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("cls", (Object)this.mCls.a());
            jSONObject.put("trigger", (Object)Integer.toString(this.mTrigger.a()));
            jSONObject.put("key", (Object)this.mPromotionEventsData.g());
            jSONObject.put("_id", this.mPromotionId);
            jSONObject.put("url", (Object)this.mUrl);
            jSONObject.put("priority", this.mPriority);
            jSONObject.put("cap", this.mCap);
            jSONObject.put("name", (Object)this.mName);
            jSONObject.put("enabled", this.mIsActive);
            jSONObject.put("promotion_revision_id", this.mPromotionRevisionId);
            jSONObject.put("direction", (Object)this.mDirection);
            jSONObject.put("status", this.mStatus.a());
            if (this.mUiType != null) {
                jSONObject.put("ui_type", (Object)this.mUiType);
            }
            JSONArray jSONArray = new JSONArray();
            if (this.mActions != null) {
                for (int i2 = 0; i2 < this.mActions.size(); ++i2) {
                    JSONObject jSONObject2 = this.mActions.get(i2).a();
                    jSONArray.put(i2, (Object)jSONObject2);
                }
                jSONObject.put("actions", (Object)jSONArray);
            }
        }
        catch (Exception exception) {
            bw.a(exception.getMessage(), new Object[0]);
        }
        return jSONObject;
    }

    public void increaseDisplayCount() {
        ++this.mDisplayCount;
    }

    public boolean isWalkthrough() {
        return this.mCls == cj.b.b;
    }

    public boolean isCampaignHasAutoSteps() {
        if (!this.isWalkthrough()) {
            return false;
        }
        cr cr2 = (cr)this;
        for (cp cp2 : cr2.i()) {
            if (!cp2.B()) continue;
            return true;
        }
        return false;
    }

    public boolean isCurrentStepWT() {
        try {
            if (this.isWalkthrough() && ((cr)this).d().A()) {
                return true;
            }
        }
        catch (Exception exception) {
            bw.a(exception.getMessage(), new Object[0]);
        }
        return false;
    }

    public boolean isShoutout() {
        return this.mCls == cj.b.a;
    }

    public boolean isLauncher() {
        return this.mCls == cj.b.d;
    }

    public boolean isNativeSurvey() {
        return this.mCls == cj.b.e;
    }

    public long getPromotionId() {
        return this.mPromotionId;
    }

    public void setPromotionId(long l2) {
        this.mPromotionId = l2;
    }

    public cj.d getTrigger() {
        return this.mTrigger;
    }

    public ck getPromotionEventsData() {
        return this.mPromotionEventsData;
    }

    public long getPromotionRevisionId() {
        return this.mPromotionRevisionId;
    }

    public String getUrl() {
        return this.mUrl;
    }

    public int getPriority() {
        return this.mPriority;
    }

    public int getCap() {
        return this.mCap;
    }

    public cj.b getCls() {
        return this.mCls;
    }

    public List<cl> getActions() {
        return this.mActions;
    }

    public String getName() {
        return this.mName;
    }

    public boolean isActive() {
        return this.mIsActive;
    }

    public cj.c getStatus() {
        return this.mStatus;
    }

    public int getDisplayCount() {
        return this.mDisplayCount;
    }

    public boolean wasImpressionSent() {
        return this.mWasImpressionSent;
    }

    public void setImpressionSent() {
        this.mWasImpressionSent = true;
    }

    public long getLastCtaId() {
        return this.mLastCtaId;
    }

    public void setLastCtaId(long l2) {
        this.mLastCtaId = l2;
    }

    public String getLastCta() {
        return this.mLastCta;
    }

    public void setLastCta(String string) {
        this.mLastCta = string;
    }

    public Boolean getIsRequestAccessibilityFocus() {
        return this.mIsRequestAccessibilityFocus;
    }

    public boolean shouldAnimate() {
        b b2 = null;
        if (this.isWalkthrough()) {
            cr cr2 = (cr)this;
            b2 = cr2.d().G();
            if (b2 == null) {
                b2 = cr2.v();
            }
        } else if (this instanceof cp) {
            b2 = ((cp)this).G();
        }
        return b2 == null || b2.a() != -1;
    }

    public String getDirection() {
        return this.mDirection;
    }

    public ArrayList<Long> getLabels() {
        return this.mLabels;
    }

    private void setLabels(JSONObject jSONObject) {
        try {
            JSONArray jSONArray = jSONObject.optJSONArray("campaign_labels");
            if (jSONArray != null) {
                for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                    this.mLabels.add(jSONArray.getLong(i2));
                }
            }
        }
        catch (Exception exception) {
            bw.a("Failed to handle with promotion label " + exception.getMessage(), new Object[0]);
        }
    }

    public String toString() {
        return "WMPromotionObject {mPromotionId=" + this.mPromotionId + ", mTrigger='" + (Object)((Object)this.mTrigger) + '\'' + ", mUrl=" + this.mUrl + '\'' + ", mPriority=" + this.mPriority + '\'' + ", mCap=" + this.mCap + '\'' + ", mName=" + this.mName + '}';
    }
}

