/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.journal;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.codehaus.activemq.journal.InvalidRecordLocationException;
import org.codehaus.activemq.journal.Journal;
import org.codehaus.activemq.journal.JournalEventListener;
import org.codehaus.activemq.journal.RecordLocation;
import org.codehaus.activemq.management.CountStatisticImpl;
import org.codehaus.activemq.management.TimeStatisticImpl;
import org.codehaus.activemq.util.IndentPrinter;

public class JournalStatsFilter
implements Journal {
    private final TimeStatisticImpl writeLatency = new TimeStatisticImpl("writeLatency", "The amount of time that is spent waiting for a record to be written to the Journal");
    private final CountStatisticImpl writeRecordsCounter = new CountStatisticImpl("writeRecordsCounter", "The number of records that have been written by the Journal");
    private final CountStatisticImpl writeBytesCounter = new CountStatisticImpl("writeBytesCounter", "The number of bytes that have been written by the Journal");
    private final TimeStatisticImpl synchedWriteLatency = new TimeStatisticImpl(this.writeLatency, "synchedWriteLatency", "The amount of time that is spent waiting for a synch record to be written to the Journal");
    private final TimeStatisticImpl unsynchedWriteLatency = new TimeStatisticImpl(this.writeLatency, "unsynchedWriteLatency", "The amount of time that is spent waiting for a non synch record to be written to the Journal");
    private final TimeStatisticImpl readLatency = new TimeStatisticImpl("readLatency", "The amount of time that is spent waiting for a record to be read from the Journal");
    private final CountStatisticImpl readBytesCounter = new CountStatisticImpl("readBytesCounter", "The number of bytes that have been read by the Journal");
    private final Journal next;
    private boolean detailedStats;

    public JournalStatsFilter(Journal next) {
        this.next = next;
    }

    public RecordLocation write(byte[] data, boolean sync) throws IOException {
        long start = System.currentTimeMillis();
        RecordLocation answer = this.next.write(data, sync);
        long end = System.currentTimeMillis();
        this.writeRecordsCounter.increment();
        this.writeBytesCounter.add((long)data.length);
        if (sync) {
            this.synchedWriteLatency.addTime(end - start);
        } else {
            this.unsynchedWriteLatency.addTime(end - start);
        }
        return answer;
    }

    public byte[] read(RecordLocation location) throws InvalidRecordLocationException, IOException {
        long start = System.currentTimeMillis();
        byte[] answer = this.next.read(location);
        long end = System.currentTimeMillis();
        this.readBytesCounter.add((long)answer.length);
        this.readLatency.addTime(end - start);
        return answer;
    }

    public void setMark(RecordLocation recordLocator, boolean force) throws InvalidRecordLocationException, IOException {
        this.next.setMark(recordLocator, force);
    }

    public RecordLocation getMark() {
        return this.next.getMark();
    }

    public void close() throws IOException {
        this.next.close();
    }

    public void setJournalEventListener(JournalEventListener eventListener) {
        this.next.setJournalEventListener(eventListener);
    }

    public RecordLocation getNextRecordLocation(RecordLocation lastLocation) throws IOException, InvalidRecordLocationException {
        return this.next.getNextRecordLocation(lastLocation);
    }

    public void dump(IndentPrinter out) {
        out.printIndent();
        out.println("Journal Stats {");
        out.incrementIndent();
        out.printIndent();
        out.println("Throughput           : " + this.getThroughputKps() + " k/s and " + this.getThroughputRps() + " records/s");
        out.printIndent();
        out.println("Latency with force   : " + this.getAvgSyncedLatencyMs() + " ms");
        out.printIndent();
        out.println("Latency without force: " + this.getAvgUnSyncedLatencyMs() + " ms");
        out.printIndent();
        out.println("Raw Stats {");
        out.incrementIndent();
        out.printIndent();
        out.println((Object)this.writeRecordsCounter);
        out.printIndent();
        out.println((Object)this.writeBytesCounter);
        out.printIndent();
        out.println((Object)this.writeLatency);
        out.incrementIndent();
        out.printIndent();
        out.println((Object)this.synchedWriteLatency);
        out.printIndent();
        out.println((Object)this.unsynchedWriteLatency);
        out.decrementIndent();
        out.printIndent();
        out.println((Object)this.readBytesCounter);
        out.printIndent();
        out.println((Object)this.readLatency);
        out.decrementIndent();
        out.printIndent();
        out.println("}");
        out.decrementIndent();
        out.printIndent();
        out.println("}");
    }

    public String toString() {
        if (this.detailedStats) {
            StringWriter w = new StringWriter();
            PrintWriter pw = new PrintWriter(w);
            this.dump(new IndentPrinter(pw, "  "));
            return w.getBuffer().toString();
        }
        StringWriter w = new StringWriter();
        PrintWriter pw = new PrintWriter(w);
        IndentPrinter out = new IndentPrinter(pw, "  ");
        out.println("Throughput           : " + this.getThroughputKps() + " k/s and " + this.getThroughputRps() + " records/s");
        out.printIndent();
        out.println("Latency with force   : " + this.getAvgSyncedLatencyMs() + " ms");
        out.printIndent();
        out.println("Latency without force: " + this.getAvgUnSyncedLatencyMs() + " ms");
        return w.getBuffer().toString();
    }

    public JournalStatsFilter enableDetailedStats(boolean detailedStats) {
        this.detailedStats = detailedStats;
        return this;
    }

    public double getThroughputKps() {
        long totalTime = this.writeBytesCounter.getLastSampleTime() - this.writeBytesCounter.getStartTime();
        return (double)this.writeBytesCounter.getCount() / (double)totalTime / 1024.0 * 1000.0;
    }

    public double getThroughputRps() {
        long totalTime = this.writeRecordsCounter.getLastSampleTime() - this.writeRecordsCounter.getStartTime();
        return (double)this.writeRecordsCounter.getCount() / (double)totalTime * 1000.0;
    }

    public double getWritesPerSecond() {
        return this.writeLatency.getAveragePerSecond();
    }

    public double getAvgSyncedLatencyMs() {
        return this.synchedWriteLatency.getAverageTime();
    }

    public double getAvgUnSyncedLatencyMs() {
        return this.unsynchedWriteLatency.getAverageTime();
    }

    public void reset() {
        this.writeLatency.reset();
        this.writeBytesCounter.reset();
        this.writeRecordsCounter.reset();
        this.synchedWriteLatency.reset();
        this.unsynchedWriteLatency.reset();
        this.readLatency.reset();
        this.readBytesCounter.reset();
    }
}

