/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.journal.impl;

import EDU.oswego.cs.dl.util.concurrent.Latch;
import java.nio.ByteBuffer;
import org.codehaus.activemq.journal.impl.Mark;
import org.codehaus.activemq.journal.impl.Record;

public class BatchedWrite {
    private final Latch writeDoneLatch = new Latch();
    private Record data = null;
    public Throwable error;
    private final ByteBuffer byteBuffer;
    private long firstSequenceId = -1L;
    private long lastSequenceId;
    private Mark mark;
    private boolean appendDisabled = false;
    private boolean appendInProgress = false;

    public BatchedWrite(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
    }

    public synchronized void disableAppend() throws InterruptedException {
        this.appendDisabled = true;
        while (this.appendInProgress) {
            this.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean append(Record record) {
        BatchedWrite batchedWrite = this;
        synchronized (batchedWrite) {
            if (this.appendDisabled) {
                return false;
            }
            this.appendInProgress = true;
        }
        record.fill(this.byteBuffer);
        if (record.remaining() == 0) {
            if (this.firstSequenceId == -1L) {
                this.firstSequenceId = record.getHeader().sequenceId;
            }
            this.lastSequenceId = record.getHeader().sequenceId;
            if (record.getMark() != null) {
                this.mark = record.getMark();
            }
        }
        batchedWrite = this;
        synchronized (batchedWrite) {
            this.appendInProgress = false;
            this.notify();
            if (this.appendDisabled) {
                return false;
            }
            return this.byteBuffer.remaining() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForForce() throws Throwable {
        this.writeDoneLatch.acquire();
        BatchedWrite batchedWrite = this;
        synchronized (batchedWrite) {
            if (this.error != null) {
                throw this.error;
            }
        }
    }

    public void forced() {
        this.writeDoneLatch.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFailed(Throwable error) {
        BatchedWrite batchedWrite = this;
        synchronized (batchedWrite) {
            this.error = error;
        }
        this.writeDoneLatch.release();
    }

    public Record getData() {
        return this.data;
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public Mark getMark() {
        return this.mark;
    }

    public long getLastSequenceId() {
        return this.lastSequenceId;
    }

    public long getFirstSequenceId() {
        return this.firstSequenceId;
    }
}

