/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.journal.impl;

import org.codehaus.activemq.journal.RecordLocation;

public class RecordLocationImpl
implements RecordLocation {
    private final byte fileMangerId;
    private final byte segmentIndex;
    private final int segmentOffset;
    private final long sequenceId;

    public RecordLocationImpl(byte fileMangerId, byte segmentIndex, int fileOffset, long sequenceId) {
        this.fileMangerId = fileMangerId;
        this.segmentIndex = segmentIndex;
        this.segmentOffset = fileOffset;
        this.sequenceId = sequenceId;
    }

    public RecordLocationImpl(byte fileMangerId, byte segmentIndex, int fileOffset) {
        this.fileMangerId = fileMangerId;
        this.segmentIndex = segmentIndex;
        this.segmentOffset = fileOffset;
        this.sequenceId = -1L;
    }

    public int compareTo(Object o) {
        return (int)(this.sequenceId - ((RecordLocationImpl)o).sequenceId);
    }

    public int hashCode() {
        return this.segmentOffset ^ this.segmentIndex ^ this.fileMangerId << 8 ^ (int)this.sequenceId;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != RecordLocationImpl.class) {
            return false;
        }
        RecordLocationImpl rl = (RecordLocationImpl)o;
        return rl.sequenceId == this.sequenceId && rl.segmentOffset == this.segmentOffset && rl.segmentIndex == this.segmentIndex && rl.fileMangerId == this.fileMangerId;
    }

    public String toString() {
        return "" + this.fileMangerId + ":" + this.segmentIndex + ":" + this.segmentOffset + ":" + this.sequenceId;
    }

    public byte getFileMangerId() {
        return this.fileMangerId;
    }

    public byte getSegmentIndex() {
        return this.segmentIndex;
    }

    public int getSegmentOffset() {
        return this.segmentOffset;
    }

    public long getSequenceId() {
        return this.sequenceId;
    }

    public RecordLocationImpl setSegmentIndexAndOffset(byte segmentIndex, int offset) {
        return new RecordLocationImpl(this.fileMangerId, segmentIndex, offset);
    }

    public RecordLocationImpl setSequence(long seq) {
        return new RecordLocationImpl(this.fileMangerId, this.segmentIndex, this.segmentOffset, seq);
    }
}

