package ai.digital.config.server.client

import ai.digital.config.server.api.{ConfigurationPropertiesService, FileExtension, FilterCondition}
import ai.digital.config.ConfigFileFilter
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Qualifier
import org.springframework.boot.context.event.ApplicationReadyEvent
import org.springframework.context.event.EventListener


class CentralConfigEncryptor(val configFileFilter: ConfigFileFilter, @Qualifier("defaultConfigurationPropertiesService")
val centralConfigurationPropertiesService: ConfigurationPropertiesService)
  extends Logging {

  @EventListener(Array(classOf[ApplicationReadyEvent]))
  def run(): Unit = {
    val properties = centralConfigurationPropertiesService.propertiesEncrypt(configFileFilter, FileExtension.YAML,
      "password", FilterCondition.CONTAINS)
    properties ++ centralConfigurationPropertiesService.propertiesEncrypt(configFileFilter, FileExtension.YAML,
      "clientSecret", FilterCondition.CONTAINS)
    logger.info(s"Encrypted following properties $properties")
  }
}
