package ai.digital.config.server.client

import grizzled.slf4j.Logging
import org.springframework.cloud.context.refresh.ContextRefresher
import org.springframework.context.annotation.Primary
import org.springframework.stereotype.Component
import org.springframework.scheduling.annotation.Scheduled

import scala.jdk.CollectionConverters._

@Primary
@Component
class LocalConfigurationRefresh(val contextRefresher: ContextRefresher) extends ConfigurationRefresh with Logging {

  override def refreshCentralConfiguration(): Set[String] = {
    val confPropertyKeys = contextRefresher.refresh().asScala.toSet
    if (confPropertyKeys.nonEmpty) {
      logger.info(s"Refreshed property keys $confPropertyKeys")
    } else {
      logger.debug("No refreshed property keys")
    }
    confPropertyKeys
  }

  @Scheduled(initialDelayString = "${deploy.server.config.refresh.initial-delay:120000}", fixedDelayString = "${deploy.server.config.refresh.fixed-delay:60000}")
  def scheduleRefreshCentralConfiguration(): Unit =
    try {
      refreshCentralConfiguration()
    } catch {
      case e: RuntimeException =>
        if (logger.isDebugEnabled)
          logger.warn(s"Cannot execute periodic refresh of properties", e)
        else
          logger.warn(s"Cannot execute periodic refresh of properties: ${e.getMessage}")
    }
}
