package ai.digital.config.server

import ai.digital.config.server.api.PropertyValue
import org.apache.commons.configuration2.{PropertiesConfiguration, PropertiesConfigurationLayout}
import org.springframework.core.io.Resource

import java.io.{FileReader, FileWriter}

trait PropertiesManagementWithComments extends PropertiesManagement {

  protected def writeProperties(propertiesResource: Resource,
                                originalProperties: Map[String, AnyRef],
                                updateProperties: Map[String, PropertyValue],
                                removeProperties: Iterable[String]): Unit = {
    val reader = new FileReader(propertiesResource.getFile)
    try {
      val layout = new PropertiesConfigurationLayout()
      val properties = new PropertiesConfiguration()
      properties.setLayout(layout)
      layout.load(properties, new FileReader(propertiesResource.getFile))

      originalProperties
        .foreach { case (key, value) => properties.setProperty(key, value) }

      updateProperties
        .filter(!_._2.commentedValue)
        .foreach { case (key, value) =>
          if (properties.containsKey(key))
            properties.setProperty(key, value.value)
          else
            properties.addProperty(key, value.value)

          Option(value.comment)
            .filter(_.nonEmpty)
            .foreach(v => layout.setComment(key, v))
        }

      updateProperties
        .filter(_._2.commentedValue)
        .keys
        .foreach(properties.clearProperty)

      removeProperties.foreach(properties.clearProperty)

      val writer = new FileWriter(propertiesResource.getFile)
      try {
        properties.write(writer)
      } finally {
        writer.close()
      }
    } finally {
      reader.close()
    }
  }
}
